set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '2332403',
      2,
      1,
      NULL,
      2,
      NULL,
      2.620107,
      0.422013,
      NULL,
      NULL,
      ' 6- 5-1996',
      18.694137,
      NULL,
      3,
      0,
      0.018269,
      ' 8-25-1975',
      36.691381,
      4,
      NULL,
      104,
      0,
      NULL,
      ' 3- 5-1996',
      ' 9- 1-1982',
      0,
      2.963638,
      1.468594,
      NULL,
      0.094508,
      1.896007,
      0,
      1.556068,
      0.523856,
      10,
      0,
      15.055482,
      1,
      15.677380,
      21,
      0,
      4,
      5,
      0,
      NULL,
      0.821653,
      1,
      0,
      NULL,
      1,
      NULL,
      0.067821,
      1.369229,
      3,
      0,
      0,
      3,
      NULL,
      3,
      3,
      0,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      2,
      2.697037,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      6,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      1,
      5,
      0,
      1,
      1,
      2,
      1,
      NULL,
      3,
      0,
      4,
      3,
      5,
      NULL,
      0,
      NULL,
      4,
      NULL,
      0,
      3,
      4,
      NULL,
      0.380874,
      '11-25-1986',
      NULL,
      '11-25-1981',
      NULL,
      2,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0.810314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2.079075,
      0.648281,
      5,
      1,
      1,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.424244,
      1.698036,
      NULL,
      1.829311,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4.464405,
      1.126988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.717897,
      1,
      0.609702,
      1,
      0,
      2,
      17,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.814362,
      1,
      1,
      0,
      1,
      3,
      1,
      1,
      0,
      1,
      3,
      NULL,
      NULL,
      2,
      5.108762,
      5.770936,
      1.611334,
      0,
      1,
      0.365953,
      1.514121,
      0,
      0,
      NULL,
      0,
      1,
      0.448902,
      NULL,
      13.797215,
      4,
      0,
      0,
      1,
      7.139440,
      2,
      6.823381,
      2,
      NULL,
      0,
      7,
      0,
      NULL,
      0.778162,
      30,
      0,
      NULL,
      NULL,
      NULL,
      43,
      NULL,
      NULL,
      2,
      2.644848,
      '21140',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      11,
      9.210769,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.566943,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.601188,
      NULL,
      3.677141,
      1,
      NULL,
      NULL,
      0.873709,
      0,
      2.458307,
      0,
      NULL,
      NULL,
      0.587457,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.801473,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.067243,
      NULL,
      NULL,
      4,
      1,
      5.816976,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.331934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.902663,
      NULL,
      3.407310,
      NULL,
      NULL,
      1.581337,
      0,
      NULL,
      NULL,
      5,
      1.563505,
      1,
      1,
      1.993158,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.659657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309995,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.571906,
      NULL,
      NULL,
      1.135730,
      NULL,
      NULL,
      1.271097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.788464,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.490204,
      3,
      0,
      1,
      NULL,
      NULL,
      2,
      2.483270,
      NULL,
      NULL,
      5,
      7,
      2,
      NULL,
      NULL,
      0.276762,
      2,
      1.347634,
      2.778723,
      0,
      1.937622,
      3,
      NULL,
      2,
      NULL,
      6.254903,
      NULL,
      0,
      1,
      0.412624,
      3.062028,
      3.678878,
      0.080524,
      NULL,
      2,
      0,
      1.349427,
      3,
      1.610744,
      0.379550,
      4,
      2.166170,
      4,
      1.635145,
      6,
      NULL,
      1,
      1,
      0,
      1.496707,
      0,
      0,
      NULL,
      2.469779,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271520,
      NULL,
      NULL,
      0.530103,
      NULL,
      NULL,
      0.870644,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.985348,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2,
      1.256229,
      NULL,
      NULL,
      3.132599,
      NULL,
      NULL,
      NULL,
      0.825636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.306726,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.468303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825171,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.409400,
      NULL,
      NULL,
      NULL,
      0.536861,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0.104810,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.379184,
      NULL,
      NULL,
      1,
      NULL,
      0.345193,
      NULL,
      14,
      1.854514,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.136318,
      NULL,
      0.359020,
      0,
      1,
      2,
      1,
      0.994083,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.100554,
      2.353868,
      NULL,
      0.927987,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.227625,
      NULL,
      0,
      NULL,
      1.479238,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.252906,
      NULL,
      1587.393003,
      NULL,
      1.759737,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097245,
      1.788322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143008,
      1.672395,
      1.084284,
      NULL,
      0.702629,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.842578,
      NULL,
      NULL,
      0,
      12,
      NULL,
      3.090127,
      0.080697,
      2.946709,
      0.119308,
      3,
      NULL,
      0,
      3,
      0.702445,
      3,
      3,
      2,
      NULL,
      2,
      2,
      1.122706,
      0,
      0,
      NULL,
      0.271219,
      NULL,
      NULL,
      1.908956,
      1,
      NULL,
      1.604248,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      0.262175,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.361592,
      1.170845,
      NULL,
      NULL,
      2,
      NULL,
      2.868481,
      0.184102,
      1.199639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.504367,
      NULL,
      0,
      NULL,
      0,
      3,
      3,
      0,
      NULL,
      NULL,
      51.139100,
      130.518878,
      NULL,
      2.237584,
      3,
      '23004',
      '30341',
      '',
      1,
      '',
      '',
      '',
      3.863513,
      '3414',
      '',
      '');
commit;
end;
/


