set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4.829052,
      2.603466,
      0.654611,
      1.711014,
      1.297967,
      3,
      0.976886,
      2.938542,
      '114',
      NULL,
      2.255935,
      NULL,
      '3423401',
      1,
      1.260446,
      2,
      1,
      '4302',
      3.307973,
      NULL,
      NULL,
      NULL,
      ' 2- 5-1979',
      76.700984,
      84.923700,
      NULL,
      0,
      NULL,
      ' 9- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 7-19-1996',
      NULL,
      '11- 2-2002',
      0,
      3,
      1.606611,
      2,
      1,
      3,
      2,
      1,
      0.200664,
      NULL,
      NULL,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.186310,
      1.195401,
      1,
      2.442593,
      7.544568,
      NULL,
      1.282560,
      2,
      3,
      7,
      3.192799,
      4,
      0,
      1,
      1,
      1,
      5,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      6.573375,
      1,
      2,
      1,
      0,
      1.091434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      1,
      1.014675,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      NULL,
      5,
      3,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0.151293,
      NULL,
      1,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      3,
      2,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      2,
      NULL,
      1,
      NULL,
      5,
      NULL,
      2,
      4,
      1,
      0.565762,
      2.687657,
      NULL,
      NULL,
      ' 9-25-1987',
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.205666,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.910826,
      7.914570,
      5,
      1,
      1.461507,
      0.687080,
      NULL,
      NULL,
      NULL,
      0.614109,
      3,
      1.002300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.216913,
      NULL,
      0.122980,
      NULL,
      NULL,
      1.495742,
      1,
      1,
      11,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      0,
      2,
      NULL,
      1,
      2,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      1.890048,
      4,
      NULL,
      NULL,
      NULL,
      3.860045,
      1,
      1.255990,
      NULL,
      0.112529,
      1.664636,
      1,
      0,
      1,
      1.057650,
      NULL,
      1,
      10,
      NULL,
      1,
      6,
      8.730202,
      4.502578,
      4,
      NULL,
      0,
      0,
      3.232737,
      2.562485,
      4.904453,
      3,
      1,
      66,
      NULL,
      11,
      59.596371,
      0,
      0,
      2.345771,
      '41322',
      '21314',
      '',
      NULL,
      NULL,
      '',
      '',
      2.269615,
      '2233',
      NULL,
      '',
      3.331035,
      4.578962,
      13,
      56.020004,
      0.514037,
      48.331719,
      3,
      NULL,
      4,
      0.677977,
      2.489876,
      2,
      1.409081,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.586814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      0.259614,
      NULL,
      0.882328,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.392795,
      2.385027,
      NULL,
      2,
      2.838613,
      1.118300,
      NULL,
      NULL,
      NULL,
      0.771636,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      0.038767,
      0.224882,
      3.418534,
      0.273489,
      NULL,
      NULL,
      0.947392,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      0.662427,
      0,
      0.338185,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      0.516073,
      1,
      NULL,
      0.838903,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.058930,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.190113,
      1,
      0,
      NULL,
      NULL,
      5,
      NULL,
      5,
      1.167141,
      1.778518,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.811751,
      1.256298,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.596353,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.873431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.669361,
      1,
      1,
      NULL,
      NULL,
      5,
      4,
      1.643681,
      1.131773,
      2,
      NULL,
      4.147541,
      2.525962,
      0.388987,
      0.835644,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.717365,
      2.553625,
      1.339915,
      10,
      9,
      3,
      2,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1.125602,
      0.738538,
      NULL,
      NULL,
      0,
      9.524962,
      4,
      4,
      4,
      NULL,
      3,
      0,
      4,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453237,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.972238,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.987109,
      3,
      0,
      3.181689,
      NULL,
      6,
      NULL,
      NULL,
      9,
      0.310877,
      NULL,
      18.076860,
      1,
      3,
      3,
      0,
      0,
      1,
      1,
      0,
      3.441575,
      1.137732,
      1.953964,
      0.413879,
      NULL,
      NULL,
      NULL,
      1,
      1.639102,
      0,
      NULL,
      0,
      3.199056,
      NULL,
      0.072049,
      2,
      1,
      0.610632,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1.507924,
      1.334769,
      2,
      NULL,
      1,
      NULL,
      2.165238,
      NULL,
      3.517174,
      0.057121,
      0,
      0.308139,
      1,
      NULL,
      1,
      3.521179,
      NULL,
      0,
      2.302031,
      NULL,
      0,
      1,
      1.644445,
      1,
      NULL,
      0,
      0.551328,
      1.125852,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.783042,
      3,
      13,
      4,
      6.362195,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      101.340921,
      31.643757,
      NULL,
      95.876530,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9,
      5.612442,
      1,
      NULL,
      0.397535,
      14.211842,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0.221841,
      0,
      1,
      NULL,
      1,
      1.319874,
      1,
      1.448722,
      0,
      0.124572,
      NULL,
      0,
      NULL,
      0.774430,
      NULL,
      1.323907,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.121020,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.651818,
      NULL,
      0.715266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.957204,
      0.207931,
      1,
      NULL,
      0.504123,
      NULL,
      2,
      NULL,
      514,
      NULL,
      3,
      NULL,
      0.714524,
      NULL,
      0.727209,
      NULL,
      0,
      1,
      0.941991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724300,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640973,
      NULL,
      NULL,
      0.922219,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.106617,
      NULL,
      1,
      NULL,
      1.836173,
      0.356771,
      NULL,
      19.738459,
      12.862482,
      0,
      NULL,
      0,
      2.883419,
      2,
      0,
      1,
      4.483703,
      3,
      5,
      3,
      0,
      NULL,
      3,
      NULL,
      0.864394,
      1,
      0,
      NULL,
      NULL,
      1.458826,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.183345,
      NULL,
      2.316300,
      0.981421,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      NULL,
      1.478356,
      NULL,
      NULL,
      0,
      2.942274,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      4,
      7,
      0,
      NULL,
      2,
      56.416520,
      15.475753,
      1,
      3,
      NULL,
      '12403',
      '31111',
      '',
      0,
      '',
      '',
      '',
      3.739330,
      '1113',
      '',
      '');
commit;
end;
/


