set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7108881';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '0003113',
      3.257347,
      NULL,
      4,
      3,
      '4034',
      3.177676,
      NULL,
      NULL,
      NULL,
      ' 1-21-1993',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 8- 0-1987',
      12.467237,
      NULL,
      NULL,
      31.764289,
      NULL,
      ' 1-27-1982',
      ' 8-16-2001',
      ' 1-25-1997',
      2.058428,
      2.521683,
      0.176927,
      1,
      0.567031,
      NULL,
      2,
      0,
      NULL,
      95.983855,
      2,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      18.246537,
      3,
      NULL,
      NULL,
      1.684152,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0.779492,
      NULL,
      2,
      0.381946,
      1,
      6,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.928607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.457984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2,
      1,
      1,
      0,
      1,
      0,
      0,
      1.041330,
      NULL,
      1.306036,
      2,
      0,
      2,
      4,
      1,
      5,
      5,
      1,
      1,
      NULL,
      5,
      NULL,
      5,
      NULL,
      NULL,
      3,
      4,
      5,
      5,
      1,
      3,
      1,
      2,
      2,
      0,
      4,
      NULL,
      ' 8- 8-1991',
      NULL,
      ' 2-29-2000',
      2,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.292400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.395064,
      1.660511,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      1.233446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.030625,
      3.589995,
      0.379210,
      0,
      NULL,
      0.228562,
      1,
      3.309037,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2.874652,
      2,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1.008102,
      0.460261,
      1.393878,
      0.551080,
      1.069142,
      0,
      1.180082,
      1,
      4,
      1,
      0,
      4,
      NULL,
      6.987519,
      2,
      10,
      5,
      5.294973,
      3.129292,
      5,
      2,
      0,
      1,
      16,
      2,
      2,
      NULL,
      29,
      27,
      10.567727,
      3,
      0.196508,
      NULL,
      '02323',
      NULL,
      '',
      NULL,
      '02110',
      '',
      '',
      0.673716,
      '',
      '',
      '',
      2,
      NULL,
      112.860417,
      12,
      3,
      NULL,
      5.797144,
      3.791180,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.387048,
      NULL,
      NULL,
      1.134745,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.914897,
      NULL,
      NULL,
      1.351443,
      NULL,
      NULL,
      1.377848,
      NULL,
      NULL,
      1.607326,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568288,
      NULL,
      NULL,
      0.927870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.839684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.728473,
      0.361828,
      0.965384,
      0,
      1,
      2,
      0,
      0,
      1.840190,
      NULL,
      1.766590,
      1.611046,
      3.894417,
      0.983195,
      2,
      0,
      0.784187,
      1,
      NULL,
      NULL,
      5,
      NULL,
      0.521924,
      NULL,
      NULL,
      NULL,
      1.224973,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.840040,
      NULL,
      NULL,
      1.280306,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.068779,
      0.045890,
      2,
      0,
      NULL,
      NULL,
      4.448355,
      0.491757,
      7,
      NULL,
      0.627413,
      NULL,
      NULL,
      3.247622,
      2.942424,
      0.677059,
      NULL,
      3.070885,
      0,
      1,
      1.618325,
      1.591527,
      3.967239,
      NULL,
      5.473188,
      1,
      1.938347,
      1.825660,
      0,
      1.029405,
      2.381331,
      NULL,
      0,
      0,
      1.775382,
      1,
      NULL,
      4,
      NULL,
      6,
      NULL,
      NULL,
      1.773572,
      1.504376,
      NULL,
      NULL,
      1,
      0.397026,
      0.963254,
      1.479714,
      0,
      0.071452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.851366,
      1.960362,
      1,
      NULL,
      3.568005,
      NULL,
      NULL,
      NULL,
      334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.627451,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.384195,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.615592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544317,
      NULL,
      NULL,
      NULL,
      1.603553,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.793597,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.154682,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3.625122,
      2.091505,
      0.059903,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.642022,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.418567,
      NULL,
      NULL,
      1569,
      16,
      NULL,
      1,
      NULL,
      0.319365,
      1,
      0,
      NULL,
      0.597881,
      NULL,
      1,
      0,
      0,
      1,
      1.328858,
      1.288683,
      0,
      0.353314,
      0.929188,
      1.891353,
      NULL,
      1.096332,
      NULL,
      0.803970,
      NULL,
      2,
      NULL,
      2,
      NULL,
      9.857712,
      NULL,
      0,
      NULL,
      17.626910,
      NULL,
      1.402107,
      1.144235,
      NULL,
      1.321662,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.428412,
      NULL,
      1,
      NULL,
      2.456052,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.717784,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921636,
      0.507598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.735588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.990348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.141606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045760,
      2.091081,
      NULL,
      3,
      NULL,
      1,
      NULL,
      72.987851,
      NULL,
      0.758064,
      NULL,
      2.355376,
      NULL,
      3,
      NULL,
      1,
      24.687043,
      20.632036,
      1.109832,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      0,
      1,
      0,
      NULL,
      8.628494,
      2,
      2.128286,
      0.612304,
      2.347217,
      2.849281,
      0.145329,
      NULL,
      3.079665,
      1.105887,
      3.976320,
      0.032976,
      1.965798,
      NULL,
      0.162148,
      1,
      NULL,
      1,
      0.227485,
      NULL,
      3,
      3,
      1,
      3,
      3,
      1.026874,
      3.213659,
      2,
      0,
      1.038829,
      3.283069,
      NULL,
      0,
      3.237716,
      3.284729,
      NULL,
      NULL,
      3,
      2.487088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.538604,
      0,
      0.455716,
      0.820162,
      1.091057,
      NULL,
      4,
      1,
      6,
      0.039287,
      1,
      2,
      28,
      53,
      4,
      1.914754,
      5,
      '10030',
      '24324',
      '30301',
      0.992995,
      '31342',
      '41130',
      '',
      0.496351,
      '',
      '',
      '');
commit;
end;
/


