set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400554';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-1-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '0332330',
      NULL,
      1,
      1,
      0,
      '2432',
      NULL,
      0,
      NULL,
      NULL,
      '10- 4-1983',
      34.546477,
      NULL,
      4,
      1.703659,
      NULL,
      ' 9-20-1980',
      5,
      NULL,
      171,
      44,
      NULL,
      ' 2- 0-1998',
      ' 5-16-1997',
      ' 8-29-1977',
      1.398196,
      1,
      3,
      NULL,
      1,
      1,
      NULL,
      0.468746,
      1.957656,
      NULL,
      3,
      NULL,
      3.901760,
      4.119356,
      10.683645,
      1,
      1.071798,
      3,
      0,
      NULL,
      0.296727,
      1,
      2,
      0.191967,
      0,
      2,
      NULL,
      0.131150,
      NULL,
      1,
      1.842689,
      NULL,
      3,
      2,
      2.145186,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      3,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.011498,
      0.793621,
      0,
      1,
      NULL,
      1.275003,
      NULL,
      1,
      0.821867,
      2,
      1.185116,
      NULL,
      0.096056,
      1.358217,
      0.024859,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      0,
      0,
      1,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1.821518,
      NULL,
      1.004439,
      1,
      3,
      0,
      1,
      NULL,
      2,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      5,
      5,
      5,
      NULL,
      4,
      0,
      NULL,
      5,
      0,
      1,
      1,
      0,
      2,
      '11-13-1996',
      20.840556,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      0.759061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.574633,
      1.534545,
      3.026366,
      2,
      NULL,
      1.655187,
      1.450105,
      0.363993,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.295756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.749298,
      3.485605,
      1,
      1,
      1.556850,
      0.425363,
      1.280408,
      0.517133,
      24,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      2,
      0,
      1,
      NULL,
      1,
      1,
      0.687460,
      3,
      0.648990,
      0,
      3,
      1,
      1,
      NULL,
      0,
      0,
      1.981098,
      1.904435,
      NULL,
      0,
      1,
      1.934532,
      1,
      7,
      6.620730,
      6.989358,
      10.301490,
      9.899243,
      NULL,
      4,
      3,
      0,
      NULL,
      2,
      0,
      NULL,
      1,
      1,
      NULL,
      47,
      50,
      17.184451,
      2,
      1,
      3.417928,
      NULL,
      '',
      '',
      0.028562,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      0.224663,
      37,
      19.076555,
      2,
      15.254293,
      0.335396,
      2.583962,
      NULL,
      0,
      NULL,
      NULL,
      0.859419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.281210,
      NULL,
      NULL,
      1.858874,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.616550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839939,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.869357,
      1.999270,
      NULL,
      NULL,
      2,
      0.240857,
      3.601004,
      0.751630,
      0,
      NULL,
      1.968633,
      0,
      0.968285,
      0.816733,
      1.147679,
      NULL,
      1.552507,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.798711,
      NULL,
      NULL,
      3.179223,
      NULL,
      0,
      1,
      1.926015,
      NULL,
      NULL,
      NULL,
      0.099645,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.943667,
      3,
      1,
      0.590817,
      2.698717,
      0.248753,
      0.978910,
      NULL,
      NULL,
      7.695311,
      4.537889,
      3,
      1.909375,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.839053,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.722965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967104,
      NULL,
      NULL,
      2.215646,
      NULL,
      NULL,
      7,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.141598,
      2,
      2,
      0,
      3.039623,
      3,
      3.491870,
      1,
      0.918305,
      NULL,
      2,
      1.784824,
      2.256932,
      0,
      0,
      1.518305,
      2.495879,
      1,
      NULL,
      NULL,
      2.990310,
      1.607818,
      2,
      NULL,
      7.613969,
      3.506747,
      0.507982,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.491995,
      1,
      1,
      0.391138,
      NULL,
      3.971252,
      NULL,
      NULL,
      0.961472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.747598,
      NULL,
      NULL,
      0.543977,
      NULL,
      NULL,
      1.046162,
      1.944269,
      0.796679,
      1,
      1,
      3.973925,
      0,
      NULL,
      NULL,
      0.159638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.722864,
      NULL,
      NULL,
      NULL,
      1.524876,
      NULL,
      NULL,
      NULL,
      0.822576,
      NULL,
      NULL,
      NULL,
      0.846814,
      NULL,
      NULL,
      NULL,
      1.124551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.893606,
      NULL,
      NULL,
      NULL,
      0.806386,
      2,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      1.907624,
      NULL,
      1.501247,
      1.490989,
      3.659802,
      0.711701,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      147.075461,
      1,
      1,
      0,
      1.583196,
      0,
      0,
      NULL,
      NULL,
      1.146192,
      1,
      1,
      1,
      1,
      0,
      1.879430,
      0.130412,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      10.622475,
      1.455670,
      NULL,
      0.243800,
      2,
      5,
      1,
      3.099370,
      0,
      0.246430,
      1,
      NULL,
      NULL,
      0.843110,
      NULL,
      0.803037,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1.902845,
      NULL,
      0.914263,
      0.992314,
      NULL,
      0.483913,
      1,
      NULL,
      1.869006,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2.094808,
      NULL,
      0,
      0.309584,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499340,
      NULL,
      1.528329,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      56.194773,
      4,
      1.956099,
      0.504328,
      '13344',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


