set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9716945';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      '40',
      40,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      '2123',
      2,
      1.463303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052055,
      1,
      ' 0-23-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 4-22-1981',
      ' 5-20-1987',
      ' 8-28-2003',
      NULL,
      2.537074,
      2,
      1.554148,
      0.432303,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.194919,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.683875,
      0,
      1,
      0.337112,
      0.193303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      NULL,
      NULL,
      4,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      7.788734,
      1,
      0,
      1,
      0,
      1.799164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.154155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.820488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.928878,
      NULL,
      0.954307,
      1,
      0,
      0,
      1,
      2,
      1,
      2,
      0,
      0,
      4,
      NULL,
      3,
      1,
      1,
      1,
      0,
      1,
      3,
      NULL,
      5,
      NULL,
      3,
      3,
      1,
      0,
      1.883121,
      1,
      ' 2-20-1987',
      360,
      ' 5-22-1977',
      60,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      2.703861,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.786230,
      1.275586,
      0,
      3.363637,
      0.246768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3.516238,
      1.802878,
      1.023881,
      1.159402,
      NULL,
      11,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      3.962981,
      1.419885,
      1.032380,
      1.079527,
      NULL,
      1,
      4.650344,
      0,
      1.039917,
      3,
      1,
      0.539436,
      0.024573,
      NULL,
      NULL,
      3,
      0.867582,
      0.878847,
      0.352010,
      NULL,
      4.247647,
      4.252222,
      10,
      10.779783,
      2,
      2,
      2.355229,
      4.336548,
      3,
      NULL,
      2.382621,
      53.059314,
      1,
      3.808012,
      7,
      NULL,
      NULL,
      16.685607,
      4,
      0,
      0.093643,
      '2130',
      NULL,
      '',
      0.917585,
      NULL,
      '',
      NULL,
      1,
      NULL,
      NULL,
      '',
      NULL,
      48,
      80,
      NULL,
      0.230397,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      3,
      NULL,
      1.994966,
      NULL,
      NULL,
      NULL,
      1,
      1.987319,
      1.237246,
      NULL,
      NULL,
      0.861225,
      NULL,
      NULL,
      0,
      0,
      1.898327,
      0.773269,
      NULL,
      NULL,
      0.887132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.106348,
      4.253811,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.841261,
      NULL,
      NULL,
      3.241795,
      NULL,
      0.105161,
      0.757291,
      NULL,
      NULL,
      NULL,
      6.149323,
      2.156886,
      0,
      1.221000,
      0.132814,
      0,
      NULL,
      NULL,
      4.351323,
      2.663583,
      0.118778,
      1,
      NULL,
      NULL,
      0.181551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.830183,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.796036,
      0,
      3,
      5.094460,
      NULL,
      0,
      NULL,
      3.077243,
      1,
      0.052028,
      NULL,
      NULL,
      3,
      1.633346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.796921,
      1,
      0,
      0,
      0,
      1.139465,
      NULL,
      NULL,
      NULL,
      2.610192,
      0.363538,
      1,
      NULL,
      1.350209,
      1.329994,
      0.261782,
      NULL,
      NULL,
      1,
      3,
      1,
      0.018291,
      NULL,
      1,
      0.541869,
      1,
      3.685310,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550927,
      NULL,
      NULL,
      0.344203,
      NULL,
      NULL,
      0.833787,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.432279,
      NULL,
      NULL,
      2.389455,
      NULL,
      NULL,
      2.118310,
      NULL,
      NULL,
      2.563971,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.721586,
      1.130602,
      3.322162,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.428863,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762072,
      NULL,
      NULL,
      NULL,
      1.498348,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.596145,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660908,
      0,
      NULL,
      NULL,
      0.941601,
      NULL,
      NULL,
      NULL,
      0.860585,
      NULL,
      NULL,
      NULL,
      2.105532,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.674673,
      0.833964,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.861552,
      NULL,
      0,
      3.360180,
      76.520716,
      36,
      0.907733,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      85,
      80.001507,
      1.064902,
      1,
      NULL,
      NULL,
      0.921753,
      0.115910,
      1.933025,
      0,
      0.759673,
      1.879564,
      1.274312,
      NULL,
      1.029256,
      1,
      0.950949,
      0,
      0.728542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.954747,
      0.978068,
      3.092013,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.432313,
      NULL,
      0.725762,
      NULL,
      0.295691,
      NULL,
      0,
      NULL,
      0.591284,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.328503,
      NULL,
      NULL,
      1.972417,
      0,
      0,
      0,
      1.574861,
      1.786418,
      NULL,
      3.035753,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.699004,
      1,
      1.651138,
      0,
      0.520439,
      0,
      4,
      5,
      4,
      NULL,
      NULL,
      NULL,
      35.452767,
      50,
      5,
      0.806397,
      3.279275,
      '0013',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.593298,
      '',
      '',
      '');
commit;
end;
/


