set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.536545,
      0.621976,
      NULL,
      2.786263,
      5,
      1,
      NULL,
      1,
      '21',
      NULL,
      NULL,
      13.055969,
      '0130430',
      4,
      0.355088,
      1,
      NULL,
      '2133',
      NULL,
      0.221982,
      NULL,
      NULL,
      ' 2-23-1998',
      138,
      126,
      NULL,
      NULL,
      1,
      ' 2-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390198,
      NULL,
      0.440700,
      3.668566,
      1.327003,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      11,
      3.092076,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.873740,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      0,
      1.387367,
      NULL,
      2,
      3,
      3,
      3,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      2.796100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.079860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      3,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      7.709392,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      3,
      NULL,
      0,
      0,
      1,
      5,
      1,
      4,
      4,
      3,
      5,
      0,
      0,
      2,
      0,
      0,
      1,
      2.938019,
      '11-21-1990',
      165.392651,
      '10- 2-1977',
      19,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.416180,
      1.465896,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.744818,
      0,
      4,
      0.572328,
      0,
      NULL,
      5,
      1.303726,
      NULL,
      NULL,
      0.420407,
      1.055200,
      0.865839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.783986,
      1.000380,
      0.047687,
      1.767995,
      0.311739,
      0.181712,
      0,
      NULL,
      0,
      0.712555,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      3,
      0,
      1,
      NULL,
      3,
      1,
      2,
      NULL,
      2.533371,
      1,
      NULL,
      NULL,
      0.200698,
      0.054945,
      2,
      1.465666,
      0.599482,
      1.838641,
      0,
      0,
      0,
      0.094680,
      1.845883,
      0,
      1,
      NULL,
      1.106538,
      3.392546,
      NULL,
      0.204958,
      NULL,
      0,
      NULL,
      1.539879,
      NULL,
      6.608998,
      NULL,
      NULL,
      NULL,
      31,
      3,
      1,
      74,
      NULL,
      NULL,
      NULL,
      NULL,
      2.552817,
      1,
      '12243',
      '34214',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      6,
      48,
      32,
      3,
      22.655705,
      1.127431,
      0.251408,
      0,
      3.297374,
      3.982869,
      2,
      0.847416,
      NULL,
      NULL,
      1.834528,
      NULL,
      NULL,
      0.116444,
      NULL,
      0.207133,
      0.099317,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.106241,
      NULL,
      NULL,
      1.624356,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.915977,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.172916,
      NULL,
      NULL,
      1.855737,
      NULL,
      NULL,
      1.457764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668684,
      0,
      2,
      1.013183,
      0,
      NULL,
      2,
      1,
      0.615243,
      1.060264,
      1.225982,
      0,
      7,
      NULL,
      5,
      3,
      3.833953,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7.195637,
      NULL,
      NULL,
      NULL,
      1.082448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3.358173,
      NULL,
      0.616320,
      0.210634,
      4.826611,
      1.948196,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.731351,
      4,
      6,
      3.954753,
      NULL,
      3.037523,
      NULL,
      1,
      1.474640,
      0.262805,
      3.298438,
      3.911013,
      NULL,
      3.825135,
      0.447222,
      1.187539,
      NULL,
      1.251173,
      1.007407,
      1.172888,
      1,
      1.395890,
      NULL,
      3,
      NULL,
      NULL,
      1.922567,
      0.376267,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.937952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.352118,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.609395,
      NULL,
      NULL,
      0.906245,
      NULL,
      0.626942,
      0,
      1.836541,
      2,
      1.354223,
      NULL,
      NULL,
      3.167004,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.905988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.841418,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      11.369450,
      0.240499,
      2,
      3,
      0.828009,
      1,
      NULL,
      NULL,
      0.622486,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079402,
      NULL,
      0,
      247,
      1.193316,
      NULL,
      0,
      1,
      0,
      1.978326,
      1.389886,
      0,
      1,
      1,
      1.817377,
      1.590438,
      1,
      0.394235,
      0.880851,
      1.834278,
      0,
      1.240841,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471624,
      0.781925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722158,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705473,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844362,
      NULL,
      0.939287,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.612323,
      3,
      0.370109,
      1.906722,
      NULL,
      136,
      0.659526,
      3.862171,
      1.059995,
      NULL,
      0.265915,
      2,
      1,
      0,
      31,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1.357152,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0.880646,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.229819,
      NULL,
      0.855972,
      0,
      NULL,
      2.184862,
      NULL,
      NULL,
      1,
      3.462311,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.317367,
      NULL,
      1,
      0,
      NULL,
      0.202388,
      NULL,
      NULL,
      0.942418,
      1.172181,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907150,
      NULL,
      NULL,
      NULL,
      1.729102,
      NULL,
      1,
      NULL,
      2,
      0.699970,
      NULL,
      NULL,
      23.550488,
      126,
      NULL,
      3,
      4,
      NULL,
      '01104',
      NULL,
      1.181504,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


