set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9777759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      0,
      1.761380,
      1.197465,
      NULL,
      2.009035,
      1.352472,
      1,
      '314',
      '13002441',
      66.266705,
      60,
      '2144012',
      NULL,
      1,
      6,
      NULL,
      '0431',
      1,
      1,
      NULL,
      NULL,
      ' 5- 7-1977',
      22.250106,
      30,
      NULL,
      2,
      NULL,
      '11- 7-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 6-12-1995',
      NULL,
      ' 7- 5-1981',
      1,
      1.724059,
      NULL,
      1,
      1,
      0,
      2,
      0,
      NULL,
      0.068919,
      6,
      9.798764,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.811732,
      1,
      1,
      1,
      1,
      1.544071,
      1.751509,
      0.921707,
      2,
      NULL,
      1.481777,
      NULL,
      NULL,
      0,
      1,
      2,
      3,
      1,
      1,
      1,
      0,
      1,
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.525789,
      NULL,
      NULL,
      0.654878,
      NULL,
      NULL,
      1,
      3,
      1,
      3.130814,
      1.570885,
      NULL,
      NULL,
      0.857616,
      NULL,
      2,
      1.667870,
      3.544485,
      2.062627,
      1.485108,
      0,
      NULL,
      1,
      1,
      0.549460,
      1,
      1,
      NULL,
      2,
      NULL,
      0,
      3.507718,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      5,
      NULL,
      3,
      NULL,
      1,
      5,
      0,
      0,
      0,
      5.871355,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      3,
      0,
      NULL,
      2,
      0,
      NULL,
      4,
      5,
      3,
      NULL,
      1,
      NULL,
      NULL,
      518.420987,
      '11-14-1998',
      1,
      2.071308,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.645530,
      1,
      NULL,
      0,
      1.665281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.277116,
      0,
      1,
      2,
      13,
      NULL,
      1.600870,
      NULL,
      NULL,
      NULL,
      1,
      0.714120,
      NULL,
      NULL,
      2,
      0,
      2,
      0,
      1,
      1,
      0,
      1,
      2,
      0,
      NULL,
      2.489414,
      1,
      0,
      0,
      NULL,
      0.391043,
      1,
      1,
      0,
      0,
      0,
      0.422919,
      1,
      1,
      0,
      NULL,
      0.538054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      36,
      NULL,
      52,
      42.515969,
      0,
      4,
      2.759643,
      '24312',
      '14024',
      '',
      1,
      '',
      '',
      NULL,
      0.578496,
      '',
      '',
      '',
      3.656769,
      5,
      116,
      NULL,
      0.045643,
      7,
      0.043637,
      3.609169,
      1,
      NULL,
      3,
      3.608286,
      0.180040,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.242594,
      1.925059,
      NULL,
      NULL,
      0.493538,
      NULL,
      NULL,
      2,
      2.979273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.525157,
      2,
      1.869412,
      0,
      1.033572,
      NULL,
      NULL,
      NULL,
      1.379151,
      NULL,
      NULL,
      NULL,
      3.530441,
      3,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.835966,
      2,
      0.578696,
      0.201773,
      3,
      3,
      1.653962,
      1.368550,
      2.565294,
      0.859470,
      NULL,
      1.387186,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.556415,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.802505,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.423867,
      0,
      3,
      0,
      3,
      1.040111,
      NULL,
      NULL,
      NULL,
      4,
      1.161682,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.849687,
      NULL,
      NULL,
      1.416171,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.910082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.868371,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.675062,
      0,
      3,
      1.742923,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      7.034771,
      2.196320,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.154652,
      0,
      0,
      3.754273,
      NULL,
      1,
      6,
      2.205031,
      NULL,
      5.711451,
      2.756089,
      0.060224,
      1.518482,
      NULL,
      NULL,
      0,
      0,
      1.410053,
      1.391856,
      1.212082,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747133,
      0.868073,
      1,
      1,
      1.256586,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.952686,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.327066,
      1,
      1,
      NULL,
      NULL,
      1.188414,
      NULL,
      NULL,
      0.262467,
      NULL,
      0.231737,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.912891,
      NULL,
      1,
      0.939360,
      1.505127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.239304,
      NULL,
      0.006763,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.310904,
      NULL,
      1.846467,
      NULL,
      1.153569,
      0.135596,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.920348,
      0,
      NULL,
      0.066049,
      NULL,
      0.252044,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.579055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.434431,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.130450,
      NULL,
      0,
      NULL,
      NULL,
      3.347506,
      NULL,
      NULL,
      NULL,
      3.129230,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.068645,
      1,
      27.314543,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      0,
      0,
      1,
      1,
      2,
      NULL,
      1,
      2.185507,
      0.184015,
      NULL,
      NULL,
      NULL,
      NULL,
      2.801166,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1.731172,
      1.586347,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.534958,
      NULL,
      1,
      1.459814,
      NULL,
      1.036161,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.173689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125288,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      42,
      5,
      NULL,
      NULL,
      '21312',
      '22421',
      '',
      1.465242,
      NULL,
      '',
      '',
      0.400937,
      NULL,
      '',
      NULL);
commit;
end;
/


