set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '1014203',
      1.222873,
      0.114962,
      3,
      2,
      '1034',
      NULL,
      1.478182,
      NULL,
      NULL,
      ' 3- 3-1983',
      NULL,
      NULL,
      3,
      2,
      NULL,
      ' 1-17-2003',
      NULL,
      1.802157,
      91,
      NULL,
      NULL,
      ' 1-22-1980',
      NULL,
      ' 6-12-1991',
      2,
      0,
      1,
      NULL,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      11.674061,
      4,
      23.399870,
      0,
      12.241123,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0.934000,
      1.362916,
      0.092505,
      2.654545,
      0.237672,
      3,
      1,
      1,
      2,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      5,
      1,
      0,
      0,
      1,
      0,
      11.042893,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      5,
      0.785031,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      0.464775,
      0,
      1,
      NULL,
      0.934986,
      2.941104,
      1,
      NULL,
      1.305412,
      1,
      0,
      4,
      2.098854,
      0,
      NULL,
      0.341307,
      0.668326,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      2,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1.188395,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      4,
      0,
      1,
      0,
      0,
      3,
      1,
      0,
      4,
      4,
      5,
      0,
      4,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      5,
      2,
      4,
      0,
      ' 4-28-1981',
      2,
      ' 1-28-1977',
      2,
      0.105786,
      0,
      1,
      0,
      2,
      3,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      1.844560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.088881,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.992975,
      2,
      NULL,
      3,
      NULL,
      1.883568,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.074914,
      2,
      1.108281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895688,
      NULL,
      0,
      0.542774,
      0,
      0,
      1,
      NULL,
      21.268272,
      2.187228,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.907116,
      0.574442,
      NULL,
      1,
      1,
      3,
      2,
      2,
      3,
      1,
      0,
      2,
      2.457469,
      3.534097,
      NULL,
      1,
      0,
      1,
      3.297906,
      0.171098,
      1,
      0,
      0,
      NULL,
      0.884761,
      0,
      0,
      1,
      0.957688,
      2,
      0,
      2,
      3.629948,
      7,
      7.019746,
      0.636838,
      3.464229,
      0,
      0,
      5,
      2,
      NULL,
      0,
      14,
      2,
      1.538145,
      NULL,
      16,
      7,
      3.571840,
      5,
      NULL,
      2,
      '1040',
      '40244',
      '',
      NULL,
      '1313',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.743472,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.974537,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470229,
      NULL,
      0,
      97.462642,
      11,
      1,
      2.710248,
      1.554661,
      1.804815,
      0.346140,
      1,
      1,
      0,
      1,
      3.094173,
      1.535217,
      3,
      0,
      0,
      0.451580,
      1,
      1,
      0.116805,
      NULL,
      0.223744,
      NULL,
      0.287752,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.431554,
      NULL,
      0,
      NULL,
      4,
      0.731194,
      23,
      NULL,
      3.660677,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.829840,
      NULL,
      0.461111,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      3.392992,
      NULL,
      0.008233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954990,
      1.878187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.437672,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.354503,
      NULL,
      1.569956,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.479665,
      1.849221,
      1,
      1.204355,
      1.815727,
      1,
      NULL,
      NULL,
      0.520874,
      0.572649,
      1,
      0.527044,
      NULL,
      1,
      0.620503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      7,
      0.788099,
      0.435315,
      1,
      2,
      6.082762,
      1,
      3,
      0.886967,
      NULL,
      1.302522,
      1.899085,
      0,
      NULL,
      0.881894,
      0.983487,
      NULL,
      0,
      1,
      1,
      0,
      1.621975,
      1,
      0.929783,
      1,
      1.355103,
      1.203512,
      1,
      NULL,
      0,
      1.854460,
      1.237672,
      0,
      0.707375,
      0,
      NULL,
      3.865752,
      NULL,
      1.362249,
      0,
      0.440420,
      NULL,
      3.380987,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.360128,
      NULL,
      NULL,
      1,
      0.563830,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      70,
      37,
      5,
      NULL,
      NULL,
      '4020',
      '12012',
      '',
      0,
      '4131',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


