set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9747583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      0.421038,
      2.618834,
      2,
      1.100740,
      3.903157,
      NULL,
      '201',
      '31201411',
      NULL,
      44,
      '4133113',
      3.659255,
      0.111645,
      0,
      1,
      NULL,
      0,
      1.885997,
      NULL,
      NULL,
      NULL,
      141.549581,
      97.412621,
      NULL,
      3,
      3.022384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265756,
      0.252897,
      1.564342,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.974122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.898527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      0.928761,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      1.551992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1.897192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.372975,
      0,
      2.594598,
      NULL,
      2.409846,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.606453,
      1,
      0.798496,
      1,
      0.510213,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.964206,
      NULL,
      NULL,
      0,
      1.199786,
      1.283932,
      NULL,
      NULL,
      0.932471,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      2,
      0,
      3,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.324096,
      2.725654,
      2.346382,
      NULL,
      1.044798,
      0,
      NULL,
      0,
      0.308476,
      1.323548,
      1,
      0.673544,
      NULL,
      1.228540,
      0,
      1,
      1.551625,
      0.254448,
      0.459859,
      3.371075,
      4,
      1,
      4.512002,
      0.284107,
      4.443187,
      2,
      1,
      NULL,
      3.343942,
      0,
      1.887155,
      29.942164,
      1,
      NULL,
      49,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      '22230',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0.311984,
      NULL,
      213.190163,
      38.716402,
      NULL,
      29,
      1,
      5.788970,
      2,
      NULL,
      1.881419,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.490455,
      0.448746,
      1.240131,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.952246,
      1.961418,
      1,
      1,
      NULL,
      NULL,
      0.914611,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.185060,
      1,
      0,
      1,
      NULL,
      1.106376,
      NULL,
      1.769784,
      0.982501,
      NULL,
      NULL,
      NULL,
      0.480511,
      NULL,
      NULL,
      0.968412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.197531,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.788868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166035,
      3.996867,
      0.168350,
      0,
      0.824941,
      1.164696,
      1,
      NULL,
      2.889803,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646481,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.109516,
      0,
      0.846800,
      0.822603,
      1,
      1,
      7,
      5.669133,
      0,
      1.837876,
      NULL,
      NULL,
      0.710306,
      NULL,
      NULL,
      2,
      0,
      0,
      0.894401,
      NULL,
      NULL,
      2,
      2.131565,
      1,
      2,
      2.057875,
      1.691198,
      1,
      NULL,
      1.353413,
      0,
      NULL,
      0,
      NULL,
      3.486186,
      NULL,
      NULL,
      NULL,
      1.068192,
      0,
      NULL,
      NULL,
      0.034942,
      NULL,
      NULL,
      0,
      2.406005,
      0.663474,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      3.843738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.077603,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.397672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760239,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.312164,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.211228,
      NULL,
      1,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.904242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.076274,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.584729,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.138284,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.172216,
      NULL,
      NULL,
      NULL,
      0.179333,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.523739,
      NULL,
      NULL,
      NULL,
      0.152586,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      21,
      5,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.856527,
      1.201783,
      1.116551,
      0.839468,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      222.445158,
      9,
      0.933333,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0.348588,
      1,
      NULL,
      1.008661,
      0.786411,
      1,
      1.335771,
      0,
      0.927533,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.892746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.278753,
      1,
      NULL,
      0.102328,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.316485,
      NULL,
      1,
      NULL,
      1,
      1.312969,
      0.217792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.264353,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.182663,
      1,
      1.121683,
      NULL,
      2,
      1,
      1.691763,
      0.626920,
      1.023805,
      NULL,
      3,
      NULL,
      1.835943,
      1,
      0.576425,
      1.041119,
      0,
      0.055083,
      0,
      0,
      NULL,
      1.828705,
      0,
      NULL,
      1,
      0.894821,
      0.497537,
      1.778724,
      1,
      1.616410,
      3.476061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.314910,
      1.614610,
      1,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      37.536470,
      1,
      0,
      NULL,
      '41043',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      1.927706,
      '',
      '',
      NULL);
commit;
end;
/


