set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8112687';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '1304420',
      3,
      1.447301,
      3,
      1,
      '3124',
      NULL,
      1.298943,
      NULL,
      NULL,
      ' 2-29-1990',
      9.487706,
      NULL,
      5,
      3,
      1.589645,
      ' 1-11-1975',
      5.713042,
      0.816619,
      252.568048,
      90,
      1,
      ' 5-25-1990',
      '10-15-1980',
      ' 6-14-1987',
      1,
      2.388706,
      0,
      2,
      0,
      0.824021,
      0,
      NULL,
      0,
      NULL,
      0,
      13,
      1,
      28,
      0,
      NULL,
      2.507051,
      NULL,
      NULL,
      2.211604,
      0.091455,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1.527800,
      1.062878,
      0.625152,
      0,
      3,
      4,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.963147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3.090118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0.298485,
      NULL,
      0.692278,
      2,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      4,
      5,
      NULL,
      1,
      5,
      4,
      1,
      1,
      0,
      NULL,
      5,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0.565970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.156905,
      2.731945,
      1.312475,
      6.020894,
      1.945384,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.607189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      1,
      1.645950,
      1,
      0.855939,
      NULL,
      NULL,
      0.017297,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.464428,
      2,
      1,
      1,
      NULL,
      2,
      2,
      1,
      3,
      2,
      2,
      0,
      0,
      0.937710,
      5,
      0,
      1.938805,
      0,
      0,
      0.420990,
      NULL,
      0,
      1,
      0.635850,
      1.630153,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      57,
      41.186351,
      3,
      0.698906,
      2.001819,
      NULL,
      '',
      '',
      0.543001,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      3,
      15.439561,
      NULL,
      22.106565,
      3.018489,
      17.504991,
      NULL,
      1.273299,
      0,
      3.772882,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.223733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.266307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.383285,
      NULL,
      1.754266,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973237,
      NULL,
      NULL,
      0.562705,
      NULL,
      NULL,
      0.038706,
      NULL,
      NULL,
      2.683865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      1.975603,
      0.526843,
      NULL,
      NULL,
      1.234889,
      NULL,
      NULL,
      3.577977,
      2.047067,
      NULL,
      1.198446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043861,
      NULL,
      NULL,
      0.572874,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.052301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.343916,
      1,
      1,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      0,
      NULL,
      5.475714,
      NULL,
      2,
      3.020675,
      0.555255,
      1,
      2.087119,
      0,
      1.134401,
      0.782462,
      NULL,
      2,
      4.350204,
      4,
      2.630767,
      0,
      2,
      0,
      0.628566,
      2.695276,
      NULL,
      0,
      NULL,
      1,
      2,
      2.066720,
      1,
      NULL,
      5,
      NULL,
      0.237257,
      0.841575,
      1,
      1.151755,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.896276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.781423,
      NULL,
      NULL,
      0.023789,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.290288,
      0.807923,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.269088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678381,
      1.418786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.209442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.350908,
      0.527106,
      NULL,
      NULL,
      0.198817,
      NULL,
      NULL,
      NULL,
      0.860357,
      2,
      NULL,
      NULL,
      NULL,
      1.851385,
      NULL,
      NULL,
      1,
      1.046441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      4.950634,
      NULL,
      NULL,
      NULL,
      0.973711,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.566525,
      0.110842,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566857,
      NULL,
      NULL,
      138.040479,
      1.735101,
      1,
      0.600336,
      0.567276,
      0,
      0.128427,
      1,
      1.527668,
      0.068849,
      1.214155,
      1,
      0,
      NULL,
      0.824706,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1.035569,
      0.369262,
      0.562000,
      1,
      1,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      0.001577,
      0,
      1,
      NULL,
      0,
      1.084396,
      0.848356,
      NULL,
      1.719048,
      1.338832,
      NULL,
      1,
      1.581352,
      0,
      3.394935,
      0.770430,
      1.367263,
      NULL,
      1.840190,
      0.680349,
      NULL,
      1.476841,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1.942844,
      NULL,
      0.337164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952348,
      NULL,
      NULL,
      1.986759,
      0,
      NULL,
      2,
      0,
      0,
      0.478974,
      19.772686,
      58.088862,
      0,
      0,
      3.806957,
      '22130',
      '',
      '',
      1.536185,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


