set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906739';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '0103411',
      NULL,
      1,
      0,
      3,
      '1301',
      2.660211,
      1,
      NULL,
      NULL,
      ' 2- 4-1989',
      29.842997,
      NULL,
      5,
      3.211068,
      0,
      '10- 6-1979',
      6,
      NULL,
      353.913628,
      NULL,
      NULL,
      ' 9- 5-1992',
      ' 8- 8-1986',
      ' 4- 0-1983',
      2.919124,
      NULL,
      NULL,
      2.149898,
      NULL,
      NULL,
      2,
      1,
      1,
      1.042842,
      6,
      12.394757,
      5,
      0.217469,
      NULL,
      1,
      6,
      5,
      3,
      0.736101,
      0,
      2,
      1,
      0.306745,
      0,
      1,
      0.137890,
      0,
      0.430423,
      NULL,
      1.080368,
      1,
      5,
      0,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.438476,
      0.927043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      0,
      4,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      2,
      5,
      1,
      5,
      NULL,
      0,
      2,
      4,
      1,
      5,
      NULL,
      NULL,
      2,
      2,
      1,
      4,
      1,
      NULL,
      1,
      1,
      0,
      3.527031,
      ' 5-19-1983',
      1.405811,
      ' 6-12-1981',
      1,
      1.621039,
      2,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934405,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      2.651462,
      0.167230,
      8.647762,
      2,
      3.505806,
      1,
      NULL,
      2.591379,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0.651512,
      11.614318,
      2,
      1.057404,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.185746,
      0,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      3,
      0.561730,
      0.681148,
      0,
      1,
      0.362630,
      0.761074,
      3.256477,
      0,
      1,
      1,
      0,
      0,
      0.409356,
      1.305718,
      NULL,
      NULL,
      0,
      0.253026,
      0,
      9.632728,
      9.280335,
      NULL,
      6.718088,
      6,
      4.832902,
      NULL,
      NULL,
      6.304038,
      NULL,
      2.723180,
      1.001011,
      41.821252,
      1,
      2.431863,
      NULL,
      46,
      43,
      8,
      0,
      NULL,
      2.546473,
      NULL,
      '01041',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      50.945490,
      13.290496,
      0,
      20.496593,
      2,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.782332,
      0.941795,
      NULL,
      NULL,
      0.699708,
      NULL,
      NULL,
      0.660973,
      NULL,
      NULL,
      0.858785,
      NULL,
      NULL,
      1.646324,
      NULL,
      NULL,
      5.130739,
      2,
      1.501404,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.508166,
      0,
      1,
      0.929062,
      0,
      0.725849,
      NULL,
      1,
      1.374814,
      0,
      0,
      0,
      0,
      1.174821,
      1.883174,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.001026,
      1.607909,
      NULL,
      2.358693,
      1.437957,
      0,
      NULL,
      NULL,
      3,
      0.123425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.893128,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.155235,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.302740,
      NULL,
      NULL,
      0.922011,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.979349,
      2.232036,
      NULL,
      1.517892,
      NULL,
      0.981146,
      1,
      NULL,
      1,
      2.815314,
      2,
      NULL,
      0.677322,
      NULL,
      NULL,
      1.057088,
      NULL,
      NULL,
      0,
      1.595434,
      3,
      1.795134,
      NULL,
      NULL,
      0,
      NULL,
      0.798136,
      1.689227,
      NULL,
      NULL,
      2,
      1,
      2,
      1.554282,
      1.790874,
      NULL,
      NULL,
      0,
      0.564203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.034049,
      NULL,
      NULL,
      1.221787,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.491810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.723104,
      0.766275,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.479257,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.896075,
      0.529316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296859,
      0,
      NULL,
      NULL,
      0.995935,
      NULL,
      NULL,
      NULL,
      0.908938,
      NULL,
      NULL,
      NULL,
      1.857401,
      NULL,
      NULL,
      NULL,
      1.329360,
      NULL,
      NULL,
      NULL,
      0,
      1.026595,
      NULL,
      NULL,
      NULL,
      0.300904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.655271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.867693,
      0.123648,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.644549,
      NULL,
      NULL,
      NULL,
      2,
      2.685503,
      1.670291,
      0.345018,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.989442,
      0,
      NULL,
      NULL,
      1.814984,
      NULL,
      NULL,
      1.929195,
      NULL,
      1,
      111,
      1.554651,
      3,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1.347470,
      NULL,
      1.663514,
      0,
      2.359560,
      1.785804,
      1,
      NULL,
      0.534782,
      NULL,
      0.578811,
      NULL,
      0,
      NULL,
      0.060131,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4.946995,
      NULL,
      1.002655,
      1.474882,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.414903,
      NULL,
      0.211708,
      NULL,
      0.235827,
      NULL,
      0,
      NULL,
      0.482243,
      NULL,
      1.358445,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.213802,
      NULL,
      1.575038,
      NULL,
      1,
      NULL,
      1.461017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1.845492,
      1.103760,
      NULL,
      3,
      4.331133,
      3.077221,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0.874218,
      1,
      NULL,
      NULL,
      1,
      0.588995,
      NULL,
      0.736847,
      0,
      NULL,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.131541,
      NULL,
      0.350803,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.950423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.434237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.096756,
      0.775234,
      0,
      0.648745,
      1,
      1,
      1,
      NULL,
      4,
      1.454050,
      NULL,
      NULL,
      6.959499,
      27,
      NULL,
      1.807691,
      NULL,
      '24004',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


