set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7211810';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      0.500197,
      0,
      NULL,
      NULL,
      '4112',
      0.010814,
      0.473314,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      3.126401,
      1,
      ' 3-29-2003',
      37.391622,
      2.754807,
      110,
      80.102166,
      NULL,
      NULL,
      NULL,
      ' 6-11-1987',
      2,
      0.268184,
      0,
      0.020798,
      0,
      1.351266,
      NULL,
      1,
      0,
      44,
      4,
      NULL,
      2.017072,
      20,
      9,
      3,
      9,
      2,
      2,
      4.610078,
      0.544164,
      NULL,
      NULL,
      1,
      3.194944,
      NULL,
      0.021734,
      1.376535,
      NULL,
      1.929584,
      1.741401,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1.007831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319557,
      1.598437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.227845,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0.843914,
      2,
      1,
      1,
      NULL,
      0,
      0,
      5,
      4,
      0,
      NULL,
      0,
      5,
      NULL,
      1,
      1,
      NULL,
      1,
      4,
      0,
      0,
      1,
      0,
      2,
      0,
      0,
      5.717757,
      0.884098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.413600,
      0,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153383,
      0.924879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398918,
      0,
      0,
      NULL,
      0,
      1,
      0.524122,
      NULL,
      2.087902,
      0.776246,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      2,
      0,
      1,
      3,
      0,
      NULL,
      2,
      1,
      0,
      2,
      2.279399,
      1.043853,
      3.473602,
      1.583778,
      1,
      0.806047,
      NULL,
      NULL,
      1,
      1,
      0,
      0.739871,
      0.419945,
      1.188073,
      NULL,
      1.819625,
      2.289118,
      NULL,
      NULL,
      5.776313,
      0.038307,
      1.794929,
      4,
      NULL,
      3.136796,
      1.062864,
      NULL,
      0,
      3,
      2,
      17,
      0,
      1.313510,
      20,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      '',
      '',
      '',
      NULL,
      '44402',
      '',
      '',
      1,
      '',
      '',
      '',
      2.026248,
      17,
      NULL,
      33.723018,
      1.287103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.737485,
      NULL,
      NULL,
      1.633946,
      NULL,
      NULL,
      1.594049,
      NULL,
      NULL,
      1.790875,
      NULL,
      NULL,
      2,
      3,
      1,
      1.100434,
      3,
      0.725587,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      5.377576,
      NULL,
      1,
      1.418027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.915508,
      0,
      NULL,
      NULL,
      1.411767,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.433240,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      3,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498011,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.337466,
      1,
      0.708847,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.418931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.177697,
      NULL,
      NULL,
      1.475281,
      NULL,
      NULL,
      0.697018,
      NULL,
      NULL,
      1.957615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.034013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.406226,
      1.476094,
      1.098006,
      NULL,
      0,
      0,
      0,
      1.738719,
      2.078577,
      NULL,
      0,
      4.782568,
      NULL,
      1,
      0,
      0.816168,
      NULL,
      NULL,
      3,
      2,
      0,
      1.486831,
      NULL,
      NULL,
      0.721788,
      1,
      1.416471,
      3.441703,
      2.862356,
      1,
      0,
      NULL,
      NULL,
      0,
      0.603371,
      1,
      1,
      0,
      0.405537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.033078,
      57.223817,
      0.899958,
      NULL,
      NULL,
      NULL,
      0.666511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422825,
      NULL,
      NULL,
      0.078767,
      NULL,
      NULL,
      1,
      NULL,
      1.263533,
      201,
      0.081763,
      1.030706,
      2.754865,
      0.261662,
      2.069318,
      0.597644,
      3,
      1.616888,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.566517,
      0,
      0.604036,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.225020,
      NULL,
      93,
      NULL,
      NULL,
      37.531070,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.907167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.535339,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.205446,
      NULL,
      0,
      1.701824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      9.864025,
      3.730053,
      0.838882,
      1.255680,
      3,
      NULL,
      NULL,
      1.357324,
      1.019531,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.205250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.139323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.184583,
      NULL,
      3,
      5,
      3,
      3.709762,
      1,
      3,
      18,
      6.085761,
      NULL,
      0,
      3.256563,
      '12423',
      '20101',
      '',
      0.665134,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


