set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7211810';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '2210313',
      1,
      0,
      5,
      1,
      '3322',
      0,
      NULL,
      NULL,
      NULL,
      ' 9-17-1976',
      24.068698,
      NULL,
      3,
      NULL,
      12,
      ' 0- 3-2001',
      35.758902,
      2,
      188,
      148.526026,
      1,
      NULL,
      NULL,
      ' 2-11-1984',
      1.202738,
      1,
      NULL,
      NULL,
      0,
      0,
      2,
      0.231739,
      NULL,
      81.286998,
      1,
      13.115310,
      4,
      20.587447,
      23,
      3,
      24.999205,
      NULL,
      NULL,
      7.247679,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.977110,
      NULL,
      0.359938,
      0,
      5,
      2,
      2,
      1.309957,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0.037225,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.599353,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      2,
      0,
      3,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      2.290805,
      0,
      1,
      1,
      NULL,
      0.574295,
      NULL,
      0.388319,
      4,
      1,
      NULL,
      NULL,
      3,
      3,
      0,
      3,
      5,
      0,
      NULL,
      4,
      5,
      1,
      2,
      5,
      2,
      1,
      3,
      1,
      1,
      1,
      0,
      5,
      0,
      NULL,
      2,
      ' 2-17-1989',
      161,
      NULL,
      115,
      1.680426,
      1,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.985822,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.225221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.094529,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.487637,
      NULL,
      1,
      1,
      1,
      0.262957,
      1.239265,
      0,
      NULL,
      0.171016,
      1.247574,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      1,
      0,
      1,
      3,
      0,
      NULL,
      3,
      3,
      NULL,
      0,
      0.607294,
      1,
      2,
      NULL,
      119,
      62,
      NULL,
      NULL,
      90.789796,
      1.702946,
      1,
      0,
      3.316161,
      0.721692,
      0,
      1,
      1.125576,
      NULL,
      3.511285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.946626,
      '21022',
      '',
      '',
      0.041927,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3,
      3,
      13.077125,
      31.591666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.842997,
      0,
      0.819146,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170127,
      NULL,
      NULL,
      1.675932,
      NULL,
      NULL,
      0.706167,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419223,
      NULL,
      NULL,
      NULL,
      6,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.237278,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043339,
      NULL,
      1.770906,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368481,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.582635,
      3.043234,
      3,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.980064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992999,
      NULL,
      NULL,
      0.569142,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.151596,
      2.867911,
      3.443303,
      1,
      NULL,
      NULL,
      NULL,
      6.800159,
      NULL,
      0,
      NULL,
      1.347275,
      3.994868,
      4,
      NULL,
      1.782333,
      1,
      0,
      3.607259,
      3,
      1.645100,
      1.310611,
      0,
      2.441788,
      1.431549,
      5.077417,
      4,
      1,
      2,
      1,
      0.466263,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.468787,
      2,
      NULL,
      0.616464,
      2,
      NULL,
      2,
      0,
      NULL,
      0,
      0.398489,
      NULL,
      1,
      NULL,
      NULL,
      1.945841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670430,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.913147,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.124243,
      0.253135,
      0,
      3.548294,
      1.315699,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.342395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.360565,
      NULL,
      NULL,
      NULL,
      1.949929,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.569641,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.779531,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1.213738,
      NULL,
      NULL,
      NULL,
      1,
      74,
      NULL,
      1,
      NULL,
      NULL,
      0.318851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.270240,
      NULL,
      0,
      1,
      1.622166,
      1.659940,
      0,
      0.872207,
      NULL,
      1,
      NULL,
      0.474871,
      0,
      1.962076,
      1,
      1,
      1,
      1.350477,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      4.459601,
      5,
      0.665504,
      NULL,
      NULL,
      9.271277,
      0.526733,
      2,
      1,
      1,
      1,
      NULL,
      0.370773,
      1,
      NULL,
      NULL,
      0.931842,
      NULL,
      1.217532,
      0,
      NULL,
      0.575360,
      1.413931,
      NULL,
      3.125849,
      0.156555,
      NULL,
      2,
      0,
      NULL,
      0.247040,
      2.272022,
      NULL,
      0,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.061501,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      6,
      2.514223,
      1.417699,
      3.377008,
      NULL,
      73.016895,
      2,
      NULL,
      3.564954,
      '42240',
      '',
      '',
      0.986407,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


