set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7211810';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '2240013',
      2.328095,
      0,
      6,
      2,
      '0134',
      1,
      0.796083,
      NULL,
      NULL,
      '11-29-2002',
      25,
      NULL,
      0,
      NULL,
      5,
      ' 6-27-1988',
      NULL,
      1,
      100.229478,
      153,
      3,
      NULL,
      NULL,
      '10-27-1979',
      NULL,
      1.901676,
      1,
      2.957385,
      1.833890,
      NULL,
      4,
      0,
      0,
      98,
      5,
      7,
      4,
      3,
      23,
      5,
      4.381761,
      3,
      1,
      1,
      0.070311,
      NULL,
      1,
      3.722090,
      0.891172,
      1,
      0,
      NULL,
      0.216538,
      NULL,
      1,
      2,
      2,
      3,
      0.877899,
      4,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.604020,
      NULL,
      NULL,
      0.434835,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      5,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      4,
      0,
      0.114703,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0.024061,
      NULL,
      5,
      0,
      NULL,
      0,
      2,
      0,
      5,
      5,
      3,
      0,
      NULL,
      3,
      3,
      NULL,
      2,
      NULL,
      0,
      4,
      0,
      0,
      5,
      1,
      2,
      NULL,
      4.147292,
      2,
      ' 7-17-1995',
      NULL,
      ' 3-26-1984',
      244,
      2,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.296029,
      0.033080,
      NULL,
      NULL,
      NULL,
      6,
      1.722975,
      NULL,
      0.129463,
      NULL,
      3,
      0.208392,
      NULL,
      NULL,
      NULL,
      1.856658,
      NULL,
      1.316250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.956547,
      1,
      1.338519,
      1.218020,
      1,
      NULL,
      2.187216,
      0.876551,
      NULL,
      NULL,
      NULL,
      2,
      1.127968,
      0,
      2,
      3,
      3,
      NULL,
      1,
      2,
      3,
      2,
      3,
      3,
      NULL,
      0,
      3,
      3.938971,
      1.784775,
      0.042826,
      NULL,
      0,
      1.068185,
      1.941324,
      0.996133,
      0.623570,
      NULL,
      NULL,
      0.863474,
      1,
      1.458754,
      3,
      0,
      3,
      2,
      2.093941,
      0,
      5,
      0.996877,
      0,
      1,
      NULL,
      2.201579,
      NULL,
      2.811576,
      8,
      0,
      1.479844,
      40,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      '',
      '',
      2,
      '00100',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      27,
      43.353803,
      29.049820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.306865,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0.429841,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.295160,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      6,
      0.704469,
      0,
      0.518286,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.068462,
      2,
      1.997597,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.749284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.555584,
      1.377564,
      1.468940,
      NULL,
      NULL,
      2,
      0.626097,
      0.397193,
      NULL,
      2.546856,
      2.111988,
      1,
      1.525980,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.770848,
      NULL,
      NULL,
      0.878827,
      NULL,
      NULL,
      0.267817,
      0.031723,
      0,
      0.408650,
      NULL,
      NULL,
      1,
      5.271122,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768401,
      NULL,
      NULL,
      1.450438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343855,
      NULL,
      NULL,
      0.095265,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.002849,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      6,
      NULL,
      4.880788,
      4,
      NULL,
      5.259040,
      1.494250,
      3.027139,
      1,
      3.845598,
      3.056582,
      2,
      3.511241,
      3,
      1,
      2,
      7.200558,
      1,
      NULL,
      0,
      3.225562,
      0,
      NULL,
      NULL,
      NULL,
      3.226817,
      2.834514,
      1.628508,
      3,
      NULL,
      2.338706,
      0,
      7.337015,
      NULL,
      NULL,
      0.936636,
      2,
      0.454062,
      2,
      2,
      0.461592,
      0.516303,
      1.112729,
      1.319608,
      1.915154,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.789818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.385238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195744,
      NULL,
      NULL,
      0.038865,
      NULL,
      1.301057,
      NULL,
      0.105795,
      3.805265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.861242,
      NULL,
      NULL,
      NULL,
      3.865900,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.407963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470048,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.160537,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.252888,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.464990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.886842,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      53.842028,
      7,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.328357,
      177.468564,
      0.400036,
      1.674949,
      0,
      1.456794,
      1,
      1,
      3.428801,
      0.714936,
      1.591682,
      0,
      NULL,
      NULL,
      0.149939,
      0.417484,
      0.732034,
      0.647491,
      NULL,
      1,
      3.565343,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.143906,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      105,
      NULL,
      0,
      12,
      21.680861,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.432215,
      NULL,
      2,
      NULL,
      1.717376,
      NULL,
      NULL,
      NULL,
      0.407527,
      NULL,
      0,
      NULL,
      1.296850,
      NULL,
      0,
      NULL,
      1.007674,
      NULL,
      0.782716,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      2.920882,
      3,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.818673,
      NULL,
      0,
      2.304430,
      NULL,
      0.402108,
      1.303882,
      NULL,
      1,
      3.137911,
      NULL,
      NULL,
      3.845309,
      NULL,
      3.560327,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.591744,
      NULL,
      3,
      0,
      1.422442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.089031,
      NULL,
      1.478491,
      NULL,
      0,
      NULL,
      0,
      2,
      4,
      1.370244,
      2,
      0.939821,
      NULL,
      11.694915,
      NULL,
      1,
      3.263924,
      '01140',
      '01044',
      NULL,
      0.626763,
      '44004',
      NULL,
      NULL,
      0.805100,
      '',
      '',
      NULL);
commit;
end;
/


