set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      '4043',
      3.909269,
      0,
      NULL,
      NULL,
      '10-12-1976',
      NULL,
      NULL,
      4,
      3,
      1.643896,
      ' 7-13-1988',
      NULL,
      NULL,
      28.430651,
      112.943281,
      1,
      NULL,
      NULL,
      '11- 7-1998',
      0,
      NULL,
      NULL,
      0,
      1.874128,
      1.592686,
      2,
      1.645271,
      0.194687,
      NULL,
      1,
      17.089393,
      0.094482,
      20.862114,
      9.085655,
      5,
      NULL,
      5,
      3,
      6.784470,
      1,
      0,
      0,
      NULL,
      1.752762,
      1,
      1.526416,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      3,
      2,
      1,
      1,
      3,
      1,
      2,
      3,
      4,
      NULL,
      1,
      4,
      1,
      7.901669,
      1,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.002833,
      3,
      0,
      2,
      3.530964,
      NULL,
      NULL,
      0.138619,
      1.444142,
      1,
      3.184605,
      3,
      1.576100,
      3,
      2,
      1.495978,
      0,
      1,
      NULL,
      5,
      6,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      3,
      3,
      5,
      3,
      0,
      1,
      4,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      4,
      1,
      1,
      3,
      1,
      5,
      4,
      1,
      NULL,
      NULL,
      4,
      3,
      NULL,
      1,
      0,
      1,
      5,
      5,
      0,
      0,
      0,
      NULL,
      ' 9-28-1992',
      156.057127,
      ' 4-20-2002',
      18,
      3,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.872983,
      1.701335,
      1.937583,
      1.808524,
      6.208726,
      4,
      0.174550,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.906828,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940893,
      0.141600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.891470,
      0.225670,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      87.929541,
      0.777182,
      0.192702,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277091,
      1,
      3,
      3,
      NULL,
      2,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.001740,
      0,
      5.895725,
      5,
      NULL,
      1.304215,
      2,
      1.769891,
      NULL,
      1.559446,
      NULL,
      NULL,
      1.702287,
      0.188891,
      1.491295,
      0,
      1,
      5.348954,
      1,
      NULL,
      6,
      5.586719,
      2,
      10,
      1.685481,
      4,
      NULL,
      3.193040,
      2.905969,
      3,
      3,
      13.667777,
      3,
      3,
      NULL,
      18,
      18,
      19.063860,
      4,
      1,
      NULL,
      NULL,
      '31034',
      '',
      1.208671,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      0,
      0,
      42,
      1,
      NULL,
      2,
      2,
      3,
      1.128269,
      1.084184,
      NULL,
      NULL,
      NULL,
      2.278158,
      3.716242,
      1.757268,
      3,
      0,
      2,
      1.536190,
      3.898651,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      NULL,
      2,
      2.279593,
      2.725597,
      3.376057,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.434507,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.535454,
      NULL,
      NULL,
      NULL,
      3.130787,
      1.415148,
      1,
      3.489821,
      3,
      0,
      1.358936,
      3,
      1,
      NULL,
      1,
      1.330111,
      3,
      3.239750,
      0,
      2.930166,
      NULL,
      NULL,
      1,
      0.562402,
      1,
      0,
      2.854060,
      1,
      NULL,
      NULL,
      NULL,
      0.845693,
      0.154821,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      7,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.678002,
      NULL,
      NULL,
      NULL,
      1.966331,
      NULL,
      NULL,
      0.866931,
      NULL,
      0.826267,
      3.309226,
      3,
      1.228841,
      0.426809,
      NULL,
      NULL,
      5,
      2.384499,
      0,
      1,
      3.578323,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.569474,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.336871,
      NULL,
      NULL,
      1.372613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      5.907147,
      4.536754,
      NULL,
      4,
      NULL,
      0.865544,
      6,
      3,
      2.844428,
      2,
      1.948396,
      NULL,
      1.501603,
      NULL,
      1.102771,
      3,
      0.191243,
      0,
      0,
      5.169717,
      NULL,
      2,
      1.365445,
      0,
      NULL,
      2,
      2.886624,
      0.870424,
      0,
      NULL,
      2.452699,
      0.401876,
      2,
      4.134735,
      1.110554,
      NULL,
      2.363928,
      3.324278,
      NULL,
      0,
      NULL,
      1,
      1,
      0.638178,
      0,
      0.634086,
      0,
      3,
      NULL,
      NULL,
      3.433839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.790140,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.278346,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.566287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211636,
      0.863487,
      NULL,
      1.257254,
      0.074562,
      1.910329,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.898927,
      NULL,
      NULL,
      NULL,
      1.196471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.653372,
      NULL,
      NULL,
      NULL,
      0.044585,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.532297,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.659144,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.882584,
      0,
      1.225739,
      0.269258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154503,
      NULL,
      NULL,
      0.293740,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.330778,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      1.799614,
      0.542801,
      NULL,
      1.090355,
      1.857289,
      NULL,
      1,
      0,
      3,
      1.182496,
      1.938658,
      0,
      NULL,
      1.212301,
      3,
      NULL,
      1,
      NULL,
      0.540568,
      NULL,
      1.796496,
      NULL,
      1,
      NULL,
      2,
      NULL,
      60,
      NULL,
      3.598682,
      1.247614,
      NULL,
      0.674139,
      0,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.632630,
      NULL,
      0.363252,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.930426,
      NULL,
      0.774773,
      NULL,
      1.395760,
      NULL,
      1.698447,
      NULL,
      0,
      0,
      NULL,
      0.871699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158551,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375495,
      1.738975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.452513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.732785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836472,
      1.164404,
      NULL,
      0.078320,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.316812,
      NULL,
      NULL,
      1.256034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.967109,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.410549,
      0.584575,
      3.863149,
      1.745871,
      0,
      NULL,
      0.290470,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3.521451,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      3.822001,
      0,
      NULL,
      1.537207,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.563940,
      0,
      NULL,
      0,
      0.388114,
      NULL,
      0.129314,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.315492,
      1.344824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.882478,
      NULL,
      1.137975,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      38.052279,
      48.932212,
      NULL,
      1,
      2,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


