set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '1132440',
      NULL,
      0,
      5,
      0,
      '3440',
      NULL,
      1.416954,
      NULL,
      NULL,
      ' 3- 3-2002',
      19.566417,
      NULL,
      3,
      0,
      1.507296,
      ' 4-15-1992',
      28,
      0.256616,
      236.507370,
      21.209410,
      1,
      ' 3-16-1993',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.137196,
      0,
      0.015017,
      2,
      0.830693,
      1.784478,
      NULL,
      6,
      10.739516,
      5,
      0.427833,
      18,
      4,
      10.955802,
      5,
      3,
      8,
      1.199325,
      0,
      1,
      0.877615,
      NULL,
      1.572256,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      4,
      1,
      1.194186,
      5,
      1,
      0,
      0,
      NULL,
      NULL,
      5,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      0.420021,
      NULL,
      NULL,
      0.762666,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.592200,
      3,
      0.585144,
      1.054355,
      1,
      1.624210,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.091696,
      0,
      1.195432,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.071766,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      5,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      2,
      5,
      0,
      0,
      3,
      0,
      0,
      1,
      5,
      0,
      2,
      2,
      1,
      3,
      5,
      5,
      3,
      4,
      5,
      4,
      NULL,
      0,
      2,
      4.959200,
      NULL,
      NULL,
      NULL,
      ' 7-24-1987',
      67.836917,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.555222,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043214,
      1.051701,
      2.121040,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.395912,
      5.923049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.938163,
      0.254402,
      NULL,
      NULL,
      0.402977,
      1.121636,
      0,
      2,
      65.713246,
      1.095954,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      2,
      NULL,
      0,
      1,
      3,
      2,
      NULL,
      3,
      3,
      3,
      2.662655,
      2.974855,
      3.373067,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      0.129683,
      NULL,
      0.941072,
      1.648847,
      1,
      0,
      1.728094,
      1.938266,
      0.296192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.317982,
      NULL,
      39,
      40,
      15.148681,
      1,
      0.647056,
      3,
      NULL,
      '04143',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      3.990685,
      7,
      NULL,
      0,
      0,
      41.101496,
      NULL,
      1.515309,
      5,
      1,
      1,
      1.470902,
      0.130911,
      0.862894,
      1,
      0,
      NULL,
      NULL,
      2,
      1.062463,
      1,
      NULL,
      3.034222,
      0,
      0.826018,
      NULL,
      NULL,
      NULL,
      0,
      3.472969,
      1.382254,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.661099,
      NULL,
      NULL,
      0.337072,
      NULL,
      NULL,
      NULL,
      1.794893,
      NULL,
      1,
      0.462247,
      NULL,
      NULL,
      NULL,
      1.999984,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.009839,
      1,
      NULL,
      NULL,
      1.768526,
      NULL,
      NULL,
      1,
      NULL,
      2.526632,
      1.994400,
      NULL,
      1.293950,
      0.315513,
      0,
      1,
      NULL,
      1.315579,
      NULL,
      NULL,
      1.630403,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.972425,
      NULL,
      NULL,
      3.604756,
      1.403453,
      0.400756,
      7,
      7.850875,
      1.952923,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.971958,
      NULL,
      NULL,
      NULL,
      1.355726,
      NULL,
      NULL,
      2.066545,
      0.484605,
      1.836915,
      3.986189,
      0.797886,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      1.517343,
      NULL,
      2.480197,
      0.114605,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072489,
      NULL,
      NULL,
      1.027799,
      NULL,
      NULL,
      1.910837,
      NULL,
      NULL,
      1.962181,
      NULL,
      NULL,
      0.158582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.493930,
      0.255786,
      4.997142,
      0,
      NULL,
      2.876891,
      0,
      1,
      0.528612,
      0.607066,
      1.939748,
      1.242276,
      3.540391,
      1,
      9,
      9,
      NULL,
      2.860417,
      3,
      2.345308,
      3.028926,
      NULL,
      1,
      0,
      0,
      0.783451,
      0,
      1.492403,
      2.903076,
      1,
      9.142607,
      NULL,
      0,
      7.420675,
      NULL,
      2,
      3,
      2,
      0.874792,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.747078,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.800069,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0,
      1.189713,
      1.041362,
      1,
      1.470122,
      3.598473,
      NULL,
      NULL,
      NULL,
      1.194937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.153444,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.949965,
      NULL,
      NULL,
      NULL,
      1.796245,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.915967,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.497985,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0.083974,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441729,
      NULL,
      NULL,
      0.051237,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707695,
      NULL,
      12,
      0,
      0.973200,
      0,
      0,
      NULL,
      NULL,
      1,
      0.114808,
      1,
      0.666375,
      0,
      NULL,
      1,
      0.100517,
      1.604136,
      NULL,
      1.351297,
      1,
      NULL,
      2,
      NULL,
      0.582582,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      35.227347,
      NULL,
      1.056680,
      15,
      NULL,
      0.989104,
      0.735310,
      0.203661,
      NULL,
      1,
      NULL,
      0.911699,
      NULL,
      1.446962,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.489461,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.149136,
      NULL,
      NULL,
      NULL,
      1.570074,
      NULL,
      1.644479,
      NULL,
      1.127947,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723538,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.494442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234311,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.757365,
      0,
      0.265591,
      NULL,
      NULL,
      NULL,
      1.835663,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.352452,
      NULL,
      0.130856,
      0,
      0,
      NULL,
      0.024259,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.860422,
      1,
      3.570882,
      NULL,
      1,
      NULL,
      1.115035,
      NULL,
      NULL,
      NULL,
      NULL,
      1.413630,
      1.895831,
      NULL,
      0,
      NULL,
      0.706869,
      NULL,
      NULL,
      NULL,
      1.172777,
      NULL,
      0,
      NULL,
      0,
      0.887889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      0,
      2.992292,
      2,
      2.049269,
      0.937523,
      1,
      1,
      NULL,
      NULL,
      0.307847,
      NULL,
      0,
      NULL,
      NULL,
      0.821679,
      NULL,
      NULL,
      0.952236,
      1.741392,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1.224734,
      NULL,
      0,
      3.348087,
      NULL,
      1.639728,
      1,
      NULL,
      0.275508,
      0.330789,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.014399,
      NULL,
      0.476604,
      NULL,
      1,
      NULL,
      2,
      5,
      NULL,
      1.605308,
      NULL,
      NULL,
      60.028300,
      98,
      3,
      NULL,
      4.789159,
      '33233',
      '44202',
      '',
      NULL,
      '',
      '',
      '',
      1.935373,
      NULL,
      '',
      '');
commit;
end;
/


