set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '1034441',
      2.314806,
      NULL,
      NULL,
      2,
      '4240',
      1.152360,
      1.144943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.580310,
      2,
      ' 4-11-1982',
      3.189714,
      2,
      NULL,
      51.239259,
      2,
      NULL,
      ' 0-18-1997',
      '11-25-1987',
      2,
      NULL,
      0,
      1.580174,
      1.659304,
      0.973183,
      0,
      1.406909,
      0,
      NULL,
      8,
      4,
      3.364931,
      15,
      NULL,
      5,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      1,
      1.449525,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1.588649,
      0,
      0,
      NULL,
      5,
      2,
      0,
      4,
      1,
      NULL,
      1,
      NULL,
      3,
      6,
      0,
      NULL,
      2,
      1,
      1.806636,
      NULL,
      NULL,
      0.145237,
      NULL,
      NULL,
      3,
      NULL,
      1.356764,
      NULL,
      3,
      2,
      0.623106,
      0,
      2.260837,
      1,
      1.361633,
      1,
      1.430358,
      3,
      1.442350,
      0,
      0.903991,
      1.743397,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      1,
      5,
      NULL,
      0,
      3,
      NULL,
      0,
      4,
      3,
      0,
      4.780684,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      4,
      2,
      NULL,
      4,
      1,
      2,
      2,
      3,
      3,
      2,
      0,
      2,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      6,
      3.520456,
      ' 7-29-1976',
      89,
      ' 0-23-1996',
      NULL,
      0.090271,
      2,
      0,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      5,
      0,
      0,
      1,
      2.309933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.883352,
      0,
      1.955260,
      0.323467,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555534,
      1.470016,
      NULL,
      2,
      NULL,
      1.583702,
      NULL,
      NULL,
      NULL,
      NULL,
      0.926459,
      5,
      1.012470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.958414,
      0.624949,
      1.833069,
      45.488016,
      1.318688,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.478092,
      1,
      3,
      2,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2,
      0,
      1,
      0.125807,
      0,
      1.630072,
      0.931068,
      0,
      NULL,
      0.076253,
      1.792235,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      7.000823,
      11.887920,
      1.745374,
      4.785653,
      5.372165,
      2.347957,
      5.870286,
      NULL,
      5,
      2.581583,
      2,
      NULL,
      30,
      2,
      0.683849,
      NULL,
      NULL,
      28,
      3,
      NULL,
      NULL,
      5,
      '33201',
      '42031',
      NULL,
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      0,
      NULL,
      38,
      NULL,
      3.606718,
      10.513277,
      0,
      0.460462,
      1,
      0.182234,
      3,
      1.180579,
      2.886358,
      2,
      0,
      3.457712,
      NULL,
      NULL,
      2,
      1,
      0,
      2,
      2,
      1,
      0.661647,
      NULL,
      NULL,
      0,
      2,
      1,
      3,
      2.532648,
      NULL,
      2.546607,
      2.503055,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.979289,
      1.797534,
      0.160584,
      NULL,
      NULL,
      2,
      2.679813,
      6.062806,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.168643,
      1,
      0.947374,
      NULL,
      3,
      1.324244,
      2.830805,
      NULL,
      1.038903,
      NULL,
      3,
      1.462723,
      1,
      0,
      NULL,
      NULL,
      0,
      3.273333,
      3.482131,
      0,
      1,
      1.272144,
      1,
      0,
      NULL,
      NULL,
      1.673816,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.728591,
      1,
      NULL,
      6,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423919,
      0,
      NULL,
      3,
      3.433696,
      0,
      1,
      NULL,
      NULL,
      3.377543,
      3,
      NULL,
      NULL,
      3.590412,
      0.920671,
      0.050531,
      NULL,
      NULL,
      5.239018,
      4.092285,
      1,
      1.731633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822970,
      NULL,
      NULL,
      1.164300,
      NULL,
      NULL,
      0.171186,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.968623,
      2.096100,
      1.755199,
      2.410432,
      5.143041,
      1,
      6,
      3.228653,
      1,
      7.272544,
      2,
      NULL,
      1.391525,
      2.566867,
      0.231799,
      NULL,
      0,
      1.189136,
      3.352429,
      3.480476,
      2,
      4,
      NULL,
      NULL,
      3.620659,
      3.766240,
      2.714120,
      0.124037,
      1,
      3.594647,
      0,
      1,
      3,
      2.460781,
      1.025663,
      3.897803,
      NULL,
      5.427520,
      6.949429,
      3.634591,
      0,
      3.141769,
      2.017607,
      1,
      3,
      1.217532,
      0.661751,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.231913,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.686443,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.400346,
      NULL,
      NULL,
      2.557933,
      NULL,
      NULL,
      1,
      1.694883,
      0.455008,
      NULL,
      0,
      0.718463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.582092,
      NULL,
      NULL,
      NULL,
      0.916652,
      NULL,
      NULL,
      NULL,
      0.842316,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.533516,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.170491,
      NULL,
      NULL,
      NULL,
      4.455639,
      NULL,
      NULL,
      NULL,
      0.308202,
      NULL,
      NULL,
      NULL,
      2.679002,
      1,
      2.743122,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.849589,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      235,
      13,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0.163339,
      NULL,
      NULL,
      1.976344,
      0,
      2.658187,
      0,
      3,
      NULL,
      1,
      1,
      0,
      NULL,
      0.315014,
      NULL,
      2.504565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.548064,
      NULL,
      61.288713,
      NULL,
      3,
      NULL,
      18.556423,
      NULL,
      3.100834,
      4.015558,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.872459,
      NULL,
      NULL,
      NULL,
      1.573470,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.706562,
      NULL,
      1,
      NULL,
      1.633178,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.666127,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.054451,
      NULL,
      1,
      NULL,
      1.477856,
      NULL,
      0.032244,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022041,
      NULL,
      0.685391,
      NULL,
      NULL,
      NULL,
      NULL,
      0.334325,
      0.237753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.823716,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961343,
      3,
      NULL,
      1,
      NULL,
      1.700875,
      NULL,
      NULL,
      NULL,
      0.508543,
      NULL,
      0,
      NULL,
      1.697516,
      1.544799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      3,
      0,
      2,
      NULL,
      NULL,
      4,
      2,
      3.293255,
      0,
      1,
      1.256283,
      NULL,
      2,
      3.286644,
      NULL,
      1,
      3.139415,
      NULL,
      0,
      2.277141,
      NULL,
      2,
      0,
      NULL,
      0,
      0.838695,
      NULL,
      1.653789,
      NULL,
      NULL,
      1,
      1.976680,
      NULL,
      NULL,
      1,
      NULL,
      3.870607,
      NULL,
      NULL,
      0.781573,
      1,
      NULL,
      1,
      1.885726,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      6,
      6,
      NULL,
      NULL,
      NULL,
      29.939826,
      41.614683,
      3,
      1,
      3.779136,
      '40341',
      '44043',
      '',
      1,
      '',
      '',
      NULL,
      0.179849,
      NULL,
      '',
      NULL);
commit;
end;
/


