set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015749';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '0411302',
      0,
      0.078020,
      0,
      0,
      '3204',
      2,
      0.081587,
      NULL,
      NULL,
      ' 1-27-1976',
      40,
      NULL,
      0,
      3.354135,
      1.983948,
      '11-15-2003',
      NULL,
      0,
      17.107311,
      8,
      2,
      NULL,
      ' 9- 8-1995',
      ' 0-17-1983',
      0,
      2.076902,
      0,
      1,
      0.697107,
      3,
      NULL,
      1.971569,
      1.455124,
      3,
      6,
      5.470917,
      8,
      12.120558,
      19,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      3.135079,
      0,
      1,
      NULL,
      1,
      0,
      5,
      1,
      1,
      NULL,
      4,
      0,
      0,
      2.331174,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      0.348560,
      NULL,
      NULL,
      0,
      0,
      1.500690,
      NULL,
      0,
      5,
      0,
      NULL,
      3,
      1,
      3,
      1,
      5,
      2,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      4,
      0,
      NULL,
      4,
      1,
      4,
      1,
      1,
      0,
      0,
      3,
      NULL,
      5,
      ' 5-18-1974',
      8.825450,
      0.389506,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      2,
      0.882342,
      4,
      1,
      1.758804,
      NULL,
      NULL,
      1.920190,
      4,
      NULL,
      NULL,
      3.476251,
      NULL,
      0.095983,
      0,
      5.739098,
      NULL,
      3,
      NULL,
      2.086699,
      NULL,
      0.489217,
      NULL,
      NULL,
      2.358450,
      7.431058,
      2,
      0,
      0,
      0,
      0.232480,
      ' 7-24-1974',
      NULL,
      NULL,
      10,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.577094,
      NULL,
      0,
      1,
      0.686037,
      2.494090,
      0,
      1,
      1.135032,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      3,
      0,
      1,
      2,
      NULL,
      3,
      NULL,
      0,
      4.258314,
      0.795632,
      NULL,
      2,
      0.770399,
      1.782624,
      1,
      0,
      1,
      NULL,
      0.953409,
      0.613212,
      1,
      1,
      2.277676,
      1.770321,
      9,
      11,
      0.087071,
      1,
      0.692486,
      NULL,
      NULL,
      1.138641,
      NULL,
      2,
      0,
      NULL,
      4.616140,
      3,
      1,
      NULL,
      12,
      NULL,
      103,
      3,
      1,
      3.957995,
      NULL,
      NULL,
      '',
      2.219164,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      33.704488,
      97,
      1.604928,
      3,
      49.969399,
      7.478452,
      NULL,
      3,
      NULL,
      1.398976,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.189750,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.984498,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.634294,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020101,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.477856,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887421,
      NULL,
      NULL,
      1.952630,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.707334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132719,
      1.681877,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2,
      NULL,
      0.057945,
      1.867537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.910299,
      NULL,
      NULL,
      1.960636,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.583922,
      NULL,
      NULL,
      3,
      1.149724,
      1.486054,
      2,
      1.398089,
      1,
      5,
      5.767016,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008060,
      NULL,
      NULL,
      0.715069,
      NULL,
      1.863281,
      2,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0.664939,
      0.530280,
      NULL,
      0.218279,
      1,
      0.978808,
      3,
      3.731185,
      NULL,
      NULL,
      1.184566,
      6.969691,
      0,
      1.705352,
      4,
      0,
      0.274006,
      1,
      2,
      2,
      0,
      1,
      NULL,
      1.294315,
      NULL,
      1.911992,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297825,
      NULL,
      NULL,
      3.774745,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.591193,
      NULL,
      NULL,
      1.742078,
      2,
      1,
      1.530491,
      1,
      2.119565,
      1,
      NULL,
      NULL,
      3,
      2.866951,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      3.847810,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.840410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.351301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.218876,
      0.005644,
      NULL,
      NULL,
      1,
      1.949414,
      NULL,
      NULL,
      2.628367,
      2,
      NULL,
      NULL,
      0,
      1.672129,
      NULL,
      NULL,
      0.098500,
      NULL,
      NULL,
      NULL,
      3.146489,
      NULL,
      NULL,
      NULL,
      1,
      3.211069,
      NULL,
      NULL,
      4.716717,
      6.287796,
      NULL,
      NULL,
      3,
      0,
      6,
      0,
      0.822455,
      6,
      1,
      1,
      NULL,
      NULL,
      1.186356,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.610828,
      6,
      0.189621,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      342.208746,
      7.526157,
      1,
      NULL,
      1.225250,
      0.516477,
      1.810813,
      0,
      0.701178,
      1.903170,
      0.337220,
      2.585273,
      1,
      1,
      0.041728,
      NULL,
      0.533578,
      1.232935,
      1,
      0,
      NULL,
      3.696503,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.538308,
      NULL,
      112,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249386,
      NULL,
      1.433198,
      NULL,
      1,
      NULL,
      1.754933,
      NULL,
      1.913248,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.072209,
      NULL,
      1,
      NULL,
      0.749058,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712505,
      0.709388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.476013,
      NULL,
      1,
      NULL,
      0.631062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.190026,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.324732,
      3.551680,
      NULL,
      1.829406,
      NULL,
      0.086679,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.330978,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      8.201262,
      0,
      1.482723,
      2,
      NULL,
      8.953387,
      NULL,
      0,
      0,
      1.897124,
      1,
      0.305455,
      0.622804,
      NULL,
      0,
      NULL,
      3,
      1,
      0,
      0.084204,
      1.869774,
      2,
      0,
      0.833726,
      1.627996,
      1,
      0,
      3.631360,
      0,
      0,
      2.080917,
      2.459415,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.903999,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.720133,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444578,
      NULL,
      0.359586,
      0,
      1.165521,
      0,
      NULL,
      NULL,
      0,
      0.246711,
      1,
      0.060759,
      1,
      1.130026,
      2,
      3.784277,
      NULL,
      0.641568,
      1.957377,
      0,
      1,
      1,
      NULL,
      1.473510,
      0,
      0.430050,
      NULL,
      2.233953,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      2,
      6,
      0.389545,
      NULL,
      NULL,
      18.932276,
      NULL,
      4,
      0,
      0.412886,
      '01211',
      '33024',
      '',
      0.544065,
      '43441',
      '',
      '',
      1.232495,
      '',
      '',
      '');
commit;
end;
/


