set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9675175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31',
      '11',
      13,
      NULL,
      '3031143',
      NULL,
      NULL,
      NULL,
      NULL,
      '1010',
      3,
      NULL,
      NULL,
      NULL,
      ' 5-11-2000',
      144,
      4.375556,
      NULL,
      3.073112,
      NULL,
      ' 3-18-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '10-12-1996',
      ' 3-25-1999',
      ' 2-17-1985',
      NULL,
      2.103919,
      0,
      1,
      0.470152,
      1.906707,
      NULL,
      1.568660,
      0.274341,
      44,
      5,
      17.632185,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1.765628,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1.982731,
      0,
      0,
      0,
      NULL,
      3.859455,
      4,
      0,
      NULL,
      0,
      NULL,
      4,
      0,
      NULL,
      0,
      0,
      2,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.666285,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.835808,
      NULL,
      0.625736,
      1,
      0,
      3.532243,
      1.447109,
      1,
      NULL,
      0.085786,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      0,
      NULL,
      1,
      4.704912,
      NULL,
      0,
      NULL,
      1.628432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      4,
      1,
      0,
      1,
      3,
      0,
      NULL,
      3,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      4,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '11- 6-1982',
      119.145769,
      '11-27-1989',
      7,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      5,
      2,
      NULL,
      1.505590,
      0.649506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3.324399,
      3.784499,
      1.990698,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.780569,
      2,
      0,
      NULL,
      1.389353,
      3,
      NULL,
      2.736761,
      1,
      4.541324,
      0,
      0.621818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.069291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.343225,
      2,
      1,
      1.175980,
      0.083660,
      1.891899,
      12,
      1,
      0.401651,
      NULL,
      NULL,
      NULL,
      3,
      0.230214,
      1.125110,
      2,
      3,
      2,
      0,
      2,
      NULL,
      2,
      0,
      3,
      3,
      2,
      0,
      3.161867,
      3.485044,
      1.504785,
      1.473351,
      NULL,
      NULL,
      NULL,
      1,
      0.083477,
      1.699432,
      1,
      1,
      0.638595,
      NULL,
      1.207104,
      0.862634,
      1,
      NULL,
      7.138866,
      3,
      1.654445,
      NULL,
      7,
      1.536024,
      3.188999,
      0.286261,
      1,
      2,
      1.128779,
      NULL,
      2,
      3,
      0,
      NULL,
      6,
      62,
      NULL,
      1.313092,
      2.803783,
      '24130',
      '',
      '',
      NULL,
      '33411',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3,
      22,
      46.290719,
      NULL,
      0.172752,
      33.773759,
      6.918752,
      1,
      5,
      NULL,
      1.502249,
      0.446022,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.383759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152487,
      0,
      0,
      0,
      0,
      0.228656,
      0.133954,
      0.387147,
      1.422506,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.210197,
      3.053645,
      0.119536,
      1,
      3.741852,
      0.721308,
      NULL,
      2,
      4,
      3.475620,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.559884,
      1.045266,
      1.022901,
      2.493804,
      1.799206,
      0,
      1,
      0.476579,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0.133163,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.387530,
      NULL,
      0.432154,
      0,
      0.279773,
      NULL,
      NULL,
      1.750079,
      1.970512,
      0.686728,
      5,
      3.622398,
      3.673139,
      0,
      1.664531,
      NULL,
      NULL,
      NULL,
      0.050376,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0.717024,
      3,
      1.639695,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3,
      1.718806,
      NULL,
      NULL,
      NULL,
      7.123825,
      0.461676,
      1,
      0.788090,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.368440,
      NULL,
      NULL,
      0.623909,
      NULL,
      NULL,
      0.762694,
      1,
      1,
      4.060027,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.668122,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2,
      NULL,
      3,
      NULL,
      0.650860,
      7,
      4,
      7.448868,
      0,
      0.502837,
      2,
      2.401822,
      0,
      NULL,
      2,
      1,
      3.116981,
      1.662429,
      2.510064,
      2,
      3,
      0.978781,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      1.181983,
      NULL,
      1.579657,
      1,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.764567,
      NULL,
      NULL,
      3.096069,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      1.078722,
      1.644338,
      1.436434,
      0.088316,
      2.211403,
      0.908623,
      NULL,
      NULL,
      0.702894,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1.131017,
      0,
      NULL,
      NULL,
      0.137738,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.091501,
      NULL,
      NULL,
      1.499760,
      0.770660,
      NULL,
      NULL,
      1.621614,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      2.597990,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.980007,
      0.481898,
      NULL,
      NULL,
      0.441487,
      1.026284,
      NULL,
      NULL,
      8.366353,
      1,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      2,
      2.222802,
      0.504014,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.871144,
      1.311424,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.024780,
      NULL,
      1.345907,
      346.405300,
      0.538422,
      1,
      1.754345,
      1.868266,
      NULL,
      0.974576,
      1,
      1.314966,
      0.460088,
      1,
      1.760541,
      0.643217,
      1.916507,
      0.505629,
      0,
      1.926157,
      0.887473,
      1.036741,
      1.156522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247106,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      1.336100,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.298517,
      NULL,
      1,
      NULL,
      NULL,
      1.812252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.604190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.773994,
      NULL,
      0.619042,
      NULL,
      1.912092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.656013,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      3.581865,
      2,
      1.378536,
      1,
      NULL,
      2.448857,
      NULL,
      0.928851,
      3.495746,
      NULL,
      0,
      0.859254,
      0.252097,
      NULL,
      1.395620,
      1.158054,
      NULL,
      2.663743,
      0.730263,
      0.367616,
      0.193876,
      NULL,
      0,
      0.785543,
      0.443596,
      3,
      0,
      0.814565,
      0,
      0,
      NULL,
      1,
      1,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      0,
      0.764476,
      2.199885,
      0.628992,
      1.865565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064636,
      0,
      NULL,
      0.433681,
      0.743891,
      0.701038,
      2,
      6,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      42.505914,
      5,
      5.444020,
      2,
      '22322',
      NULL,
      '',
      0,
      '33024',
      '',
      '',
      0.033235,
      '',
      '',
      '');
commit;
end;
/


