set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9019484';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2,
      4,
      1.472176,
      5.451799,
      2,
      0,
      2,
      '00',
      '22424234',
      17,
      NULL,
      '4433001',
      NULL,
      1.482243,
      NULL,
      0,
      '2434',
      5,
      1,
      NULL,
      NULL,
      NULL,
      65,
      30,
      NULL,
      1.445359,
      1,
      ' 6- 8-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '10-15-1979',
      ' 1- 1-1988',
      NULL,
      0.884235,
      1.990518,
      2.136789,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      11.211371,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.809048,
      1,
      NULL,
      0.063325,
      0,
      1.253626,
      1.177842,
      0,
      0,
      5.579810,
      1.240527,
      0,
      5,
      5,
      3,
      5,
      0,
      2,
      5,
      NULL,
      2,
      4,
      1,
      3,
      NULL,
      NULL,
      0,
      8,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      6.151997,
      0.655322,
      NULL,
      3,
      1.178247,
      1.294540,
      0,
      0,
      NULL,
      3.852590,
      NULL,
      NULL,
      0.959122,
      NULL,
      1,
      0,
      3,
      5,
      2,
      1,
      0.431974,
      2,
      2,
      0.807758,
      1.899006,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      5,
      2,
      0,
      5,
      NULL,
      4,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      4.780350,
      0,
      0,
      0,
      1,
      0.774428,
      NULL,
      1.050358,
      1,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      4,
      0,
      0,
      2,
      1,
      NULL,
      0,
      3,
      5,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.912846,
      ' 5- 5-1977',
      68.059332,
      NULL,
      2.430047,
      0.819447,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0.511918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3,
      0,
      1.974638,
      1,
      0.735070,
      4.556278,
      2,
      5.651328,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313601,
      1.044593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.580664,
      0.640266,
      NULL,
      NULL,
      NULL,
      3.707738,
      19,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.867794,
      0.757769,
      0,
      2,
      NULL,
      2,
      NULL,
      1,
      3,
      0,
      NULL,
      0,
      1,
      1.556390,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1.428141,
      0.278629,
      1.159361,
      1,
      1,
      0.306562,
      2,
      0.480257,
      1.975485,
      5,
      5,
      7,
      5,
      6.925988,
      NULL,
      2.689602,
      NULL,
      0.837141,
      1,
      0,
      55.791594,
      0,
      3,
      28,
      NULL,
      4,
      71,
      2,
      NULL,
      3.511274,
      '43202',
      '41304',
      '',
      2.955467,
      '2143',
      '',
      '',
      2.468322,
      '0111',
      '',
      '',
      NULL,
      7.839333,
      16.231681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.960651,
      1.970494,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.060412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.726563,
      67.424535,
      2.540437,
      0,
      0.295984,
      0.969669,
      1,
      1,
      0,
      1,
      0.143503,
      3,
      0,
      NULL,
      0,
      1.872562,
      1,
      1.012091,
      1.536127,
      3,
      1,
      0.579302,
      0,
      0,
      NULL,
      0,
      3.859507,
      1,
      2,
      2.599555,
      1.883022,
      2,
      NULL,
      1.822042,
      2,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.444022,
      0.606212,
      0.036221,
      NULL,
      1.759704,
      0,
      1,
      1.167632,
      0,
      NULL,
      1.538297,
      0.465284,
      0,
      0,
      1,
      0.474268,
      NULL,
      NULL,
      1.607149,
      2.400045,
      1.367012,
      0,
      1.611166,
      0.220185,
      NULL,
      1,
      0.534260,
      0,
      2,
      1,
      0.799910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.771293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      1.619418,
      NULL,
      2,
      19,
      1.888147,
      21.001262,
      1.620798,
      NULL,
      NULL,
      NULL,
      2.668519,
      1.804089,
      NULL,
      1.505959,
      NULL,
      2.608243,
      NULL,
      NULL,
      NULL,
      72,
      NULL,
      23.665526,
      NULL,
      3,
      NULL,
      2,
      NULL,
      3,
      0.351162,
      3.047789,
      NULL,
      0,
      NULL,
      0.150768,
      NULL,
      NULL,
      NULL,
      1.461873,
      0.568088,
      2,
      NULL,
      0,
      NULL,
      0.703506,
      NULL,
      NULL,
      NULL,
      9,
      1.135103,
      1,
      2.728124,
      2,
      0,
      3,
      3.248169,
      NULL,
      3.504670,
      2.407255,
      2,
      1.044311,
      3.956535,
      2.419112,
      1.132295,
      2.893514,
      22,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      NULL,
      0.044059,
      0,
      4.672723,
      1.774351,
      2.521410,
      1,
      1.072881,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.387091,
      NULL,
      0.795831,
      NULL,
      NULL,
      1.747938,
      0.447656,
      NULL,
      0,
      NULL,
      NULL,
      0.439381,
      2,
      NULL,
      1.406342,
      0,
      NULL,
      1.949888,
      1.226306,
      NULL,
      3.370341,
      0.046800,
      NULL,
      1.076394,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.376901,
      NULL,
      0,
      NULL,
      NULL,
      3,
      4,
      0.595942,
      1.909733,
      NULL,
      81.740383,
      48,
      1,
      5.315106,
      5.978679,
      NULL,
      '04240',
      '',
      0.234823,
      '1304',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '');
commit;
end;
/


