set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8736657';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '3020233',
      3,
      1.359150,
      1,
      0,
      '2012',
      0,
      1.972737,
      NULL,
      NULL,
      ' 5-25-1994',
      37,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      29.706965,
      2.894280,
      131.486480,
      8,
      NULL,
      '11-24-2001',
      ' 1- 7-2000',
      ' 6-24-1997',
      NULL,
      NULL,
      1,
      1,
      0,
      1.775981,
      3,
      0,
      NULL,
      13,
      1,
      NULL,
      4,
      34,
      104,
      5,
      5,
      0,
      2,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1.123022,
      NULL,
      0.486980,
      0,
      1,
      0,
      1,
      4,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      5,
      NULL,
      NULL,
      1,
      NULL,
      1.222312,
      NULL,
      NULL,
      0.765318,
      NULL,
      NULL,
      5,
      1,
      0.896517,
      0,
      1,
      NULL,
      0,
      1.487668,
      2.218683,
      1.471350,
      1,
      0.860910,
      1.841542,
      1.282928,
      3,
      1.669303,
      NULL,
      NULL,
      1.272780,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.533865,
      1.801851,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      3,
      NULL,
      2,
      3,
      NULL,
      0,
      1,
      1,
      0,
      4,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.788332,
      0,
      0,
      0,
      3,
      2,
      0,
      2,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      1,
      1,
      3,
      5,
      3,
      5,
      0,
      3,
      3,
      NULL,
      0,
      2,
      5,
      3.181024,
      ' 1-25-1980',
      324,
      NULL,
      347,
      3,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      771,
      NULL,
      1.752933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.583354,
      0.370364,
      3.919881,
      3,
      0,
      1.315993,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.218633,
      1,
      1,
      0,
      1.864088,
      3,
      30,
      3.542268,
      NULL,
      9.025895,
      52.785544,
      7,
      3,
      1.768269,
      1.670774,
      3,
      0,
      3,
      1,
      0,
      0,
      2,
      NULL,
      3,
      NULL,
      NULL,
      1.406048,
      0.281948,
      6.569115,
      NULL,
      0.855108,
      5.019718,
      NULL,
      1,
      4.147944,
      0.384598,
      0,
      0.582072,
      1.226309,
      NULL,
      3,
      0,
      2.731735,
      1.907111,
      3,
      9.604629,
      3.424571,
      NULL,
      NULL,
      1.319086,
      3,
      1,
      6.817430,
      3.413527,
      1.785074,
      0,
      24.370677,
      0,
      1,
      NULL,
      37,
      14,
      46.240289,
      4,
      1.085102,
      3,
      '41200',
      '12021',
      '21143',
      1.818823,
      '',
      '',
      NULL,
      1.071623,
      '',
      NULL,
      '',
      3.304508,
      42,
      NULL,
      32,
      NULL,
      25.623942,
      19.049652,
      9,
      NULL,
      0.899750,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.751865,
      NULL,
      NULL,
      0.509974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404587,
      1.541411,
      0.765505,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.164457,
      NULL,
      NULL,
      0.986916,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.941649,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951021,
      1.388589,
      NULL,
      NULL,
      NULL,
      1.281837,
      NULL,
      NULL,
      1,
      0,
      0.194400,
      NULL,
      0.216301,
      0.987312,
      1,
      1.813083,
      2,
      0.498985,
      0.414480,
      3,
      NULL,
      1.123347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.481368,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      3.036956,
      0,
      1.456834,
      NULL,
      NULL,
      4.382246,
      5,
      5.911685,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.676101,
      NULL,
      NULL,
      1.153828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.878810,
      NULL,
      NULL,
      NULL,
      9,
      5.196227,
      2,
      1.354197,
      NULL,
      NULL,
      3,
      2,
      5,
      6.835690,
      NULL,
      NULL,
      0,
      0.067154,
      0,
      3.548345,
      NULL,
      3.827137,
      6.687852,
      1,
      3.702281,
      3,
      1.861857,
      1.266830,
      NULL,
      0,
      3.547548,
      3.170056,
      2.926261,
      3,
      NULL,
      1.755338,
      2.939702,
      9,
      3.191909,
      0.540209,
      0,
      4.497622,
      1.334294,
      2.272284,
      NULL,
      0,
      1.936173,
      0,
      0,
      NULL,
      NULL,
      3.094334,
      NULL,
      NULL,
      1.950622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165964,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      1.517475,
      2,
      0,
      NULL,
      NULL,
      5.681172,
      5.416218,
      NULL,
      NULL,
      NULL,
      19.721703,
      NULL,
      NULL,
      3.136215,
      3,
      NULL,
      NULL,
      1,
      0.334979,
      NULL,
      NULL,
      0.892653,
      1.547060,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      0.452240,
      NULL,
      NULL,
      2,
      0.990006,
      NULL,
      NULL,
      0.935045,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.046782,
      1.971084,
      NULL,
      NULL,
      NULL,
      0.920712,
      NULL,
      NULL,
      1.694764,
      1,
      NULL,
      NULL,
      1.699999,
      1,
      NULL,
      NULL,
      2.998935,
      0,
      NULL,
      NULL,
      0.694612,
      2,
      NULL,
      NULL,
      1,
      1.296338,
      NULL,
      NULL,
      NULL,
      9.034874,
      NULL,
      NULL,
      NULL,
      1.975732,
      8,
      4,
      NULL,
      66,
      9.826294,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.074442,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      19226,
      1201.183594,
      NULL,
      NULL,
      0.458927,
      0.116790,
      0,
      1,
      NULL,
      2.836899,
      0,
      1,
      1.500977,
      NULL,
      1,
      0,
      0.097627,
      1.581039,
      0.144558,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.576065,
      NULL,
      NULL,
      NULL,
      2,
      24,
      45,
      0.942400,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.264669,
      NULL,
      0,
      NULL,
      1.457827,
      NULL,
      0.380599,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238402,
      0.859105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310940,
      1.927194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417285,
      1,
      3,
      NULL,
      2.931533,
      NULL,
      1016.972089,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.168723,
      NULL,
      0,
      1.104512,
      4.639207,
      NULL,
      1.628922,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      3.763861,
      1.341099,
      1,
      0,
      7,
      1,
      3.484345,
      1,
      1.738635,
      0.042668,
      0,
      1.299246,
      0,
      0.038822,
      NULL,
      1,
      0,
      0.257557,
      0.396097,
      0.292403,
      0.307937,
      1,
      3.110464,
      0.827068,
      0.184256,
      1.208714,
      1,
      1.689829,
      2,
      NULL,
      1,
      1.508889,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.782874,
      NULL,
      1.628924,
      NULL,
      NULL,
      2,
      0.445466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646499,
      2.027721,
      2.262399,
      0.116733,
      NULL,
      NULL,
      NULL,
      0,
      0.756706,
      NULL,
      3.598151,
      NULL,
      NULL,
      NULL,
      1.810622,
      0,
      0.257156,
      1,
      NULL,
      3,
      3,
      3,
      NULL,
      0.796545,
      NULL,
      0.876072,
      NULL,
      6.791713,
      1,
      NULL,
      0.775631,
      NULL,
      1.457225,
      0.728429,
      0.949315,
      1,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      45.051368,
      90.171211,
      NULL,
      0.415492,
      1.261744,
      '30004',
      '10401',
      '12420',
      0.175392,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


