set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '2321142',
      2.819646,
      1,
      5,
      1,
      '4102',
      1,
      0.522165,
      NULL,
      NULL,
      ' 6-19-1977',
      5,
      NULL,
      3,
      1.044123,
      2.253152,
      ' 7-19-1992',
      56.838509,
      2,
      309.721976,
      60.731203,
      NULL,
      '11-23-1998',
      ' 0-27-2002',
      ' 6-21-1982',
      0.636671,
      1.310222,
      1,
      0,
      1.907615,
      1,
      2,
      1,
      NULL,
      30,
      6,
      NULL,
      2,
      12,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.030976,
      0,
      0,
      NULL,
      1,
      1.899573,
      0.328845,
      1.590327,
      0,
      NULL,
      1.811501,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      5,
      2,
      NULL,
      2,
      1,
      4,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.134209,
      NULL,
      NULL,
      0.615513,
      NULL,
      NULL,
      1,
      0,
      1.962453,
      0.193880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      2,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1.128515,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      5,
      2,
      NULL,
      0,
      2,
      0,
      3,
      0,
      3,
      3,
      '11-26-1999',
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      136.582707,
      1.160845,
      1.527135,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.849768,
      6,
      7.334417,
      NULL,
      NULL,
      1.441891,
      1.573392,
      NULL,
      NULL,
      1,
      0.380285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.506441,
      1.578073,
      1.201828,
      0,
      0.877446,
      NULL,
      0.796854,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      2,
      NULL,
      2,
      0,
      NULL,
      2,
      0,
      1,
      0,
      5.063712,
      5,
      NULL,
      NULL,
      0,
      1,
      0.312557,
      1.838573,
      0,
      1,
      0,
      0,
      NULL,
      1.048369,
      0,
      3,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      29,
      13,
      NULL,
      3,
      0,
      0,
      '22041',
      '33211',
      '11014',
      1,
      '',
      '',
      '',
      0.448419,
      '',
      '',
      '',
      3.187112,
      31.951731,
      14.339158,
      13.491807,
      1.304864,
      NULL,
      NULL,
      NULL,
      NULL,
      2.469165,
      0.090964,
      0.593013,
      2,
      0,
      3,
      15.436611,
      NULL,
      NULL,
      0.775060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679224,
      NULL,
      NULL,
      0,
      3,
      0,
      0.972178,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.675344,
      NULL,
      NULL,
      4.343564,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.847959,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.168395,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614418,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.754444,
      NULL,
      NULL,
      0.626586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.799366,
      NULL,
      NULL,
      1.394266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562569,
      NULL,
      NULL,
      1.260934,
      NULL,
      NULL,
      1.504000,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.577225,
      4.799703,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.974106,
      NULL,
      0.717840,
      0,
      1.787425,
      3.579861,
      1.162356,
      6,
      0.172332,
      2,
      1.275397,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      3,
      3,
      3,
      5.779145,
      3.870738,
      NULL,
      NULL,
      2,
      3.053000,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.850328,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432746,
      0,
      0,
      0.922736,
      1,
      1.262049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111937,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1.885841,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.653872,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      9.670046,
      0,
      0.011941,
      0,
      1,
      NULL,
      0.782693,
      NULL,
      NULL,
      1,
      0.870076,
      0.752605,
      1.841135,
      0,
      0.564450,
      1,
      0,
      1.484990,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.090494,
      NULL,
      NULL,
      NULL,
      106,
      NULL,
      NULL,
      18.878596,
      NULL,
      NULL,
      3,
      0.057634,
      NULL,
      1.333437,
      NULL,
      0.293653,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.253469,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.933136,
      NULL,
      0,
      NULL,
      0.045807,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.824315,
      NULL,
      0.574221,
      1,
      NULL,
      0.273143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      NULL,
      1.278162,
      NULL,
      906,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.215387,
      NULL,
      0.039267,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101169,
      1.360720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2.862309,
      NULL,
      724.329960,
      NULL,
      2.149067,
      NULL,
      NULL,
      NULL,
      3.191974,
      1.031403,
      3,
      NULL,
      NULL,
      1,
      1.095042,
      3.002860,
      1.674393,
      1,
      1,
      1,
      1.243102,
      0.853249,
      NULL,
      1.776777,
      0,
      5.280578,
      1.714430,
      2.495402,
      0.622449,
      0.180163,
      0.097501,
      NULL,
      1.019771,
      1,
      NULL,
      1.138056,
      1.092915,
      NULL,
      1,
      0.596355,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.076537,
      0.432321,
      NULL,
      0.792651,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.519399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.964228,
      NULL,
      1,
      2,
      7,
      1.928124,
      NULL,
      NULL,
      47,
      NULL,
      4,
      1,
      4.002264,
      '02013',
      '32114',
      '02303',
      0.108588,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


