set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4330130',
      NULL,
      0.483107,
      NULL,
      3,
      NULL,
      2,
      1.957594,
      NULL,
      NULL,
      NULL,
      62,
      NULL,
      1,
      3,
      NULL,
      NULL,
      53,
      3.734790,
      90,
      143,
      2,
      NULL,
      ' 9-20-1993',
      ' 8-15-1975',
      1.228751,
      3,
      1,
      0.463777,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      11,
      4,
      0,
      2.924830,
      3,
      12.100801,
      0,
      2,
      3.915523,
      0,
      1,
      2,
      0,
      1,
      1.845597,
      1,
      NULL,
      NULL,
      0.826626,
      1,
      3,
      NULL,
      7,
      1.747026,
      1,
      NULL,
      NULL,
      3,
      0,
      1,
      4,
      NULL,
      1,
      0,
      0,
      0,
      2.766229,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.204356,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.242269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.551449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      4,
      2,
      1,
      0,
      5,
      0,
      2,
      5,
      NULL,
      2,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      ' 5- 2-1978',
      17,
      ' 8- 8-1988',
      23,
      1.072788,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.960913,
      1.672560,
      1.987049,
      5,
      1.589103,
      0.614339,
      2,
      2,
      5.548888,
      3,
      0.663836,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.535001,
      6,
      4.028618,
      4.762420,
      1.376135,
      NULL,
      NULL,
      NULL,
      1,
      2.661683,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.826835,
      0.535734,
      1,
      0,
      0,
      0.894025,
      0.099175,
      2.323580,
      28,
      0,
      1.941679,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      3,
      5,
      3.923612,
      5.577025,
      7.166192,
      1,
      NULL,
      0.220435,
      0,
      1.568789,
      NULL,
      1.332631,
      0.543076,
      0,
      1,
      NULL,
      0,
      1.776317,
      NULL,
      1,
      10.774993,
      9,
      4.445481,
      11.859714,
      6,
      3,
      4,
      0,
      0,
      NULL,
      1,
      NULL,
      14.812363,
      3,
      0.221057,
      NULL,
      68,
      34,
      18,
      2,
      0.139102,
      2,
      '43400',
      NULL,
      '',
      0,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '',
      NULL,
      50,
      22,
      55,
      1.948198,
      NULL,
      NULL,
      NULL,
      NULL,
      3.475152,
      NULL,
      1.405696,
      2,
      NULL,
      NULL,
      1.997871,
      NULL,
      NULL,
      0.379146,
      NULL,
      NULL,
      0.371072,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.350401,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763925,
      NULL,
      NULL,
      0.550878,
      NULL,
      NULL,
      1.390581,
      NULL,
      NULL,
      1.920449,
      5,
      0.475333,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.354096,
      NULL,
      NULL,
      0.333074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.642568,
      NULL,
      NULL,
      0.565542,
      NULL,
      NULL,
      0.620141,
      NULL,
      1.992180,
      0.209094,
      NULL,
      NULL,
      3,
      1.620501,
      NULL,
      1,
      NULL,
      NULL,
      1.382593,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.677151,
      NULL,
      NULL,
      1.572792,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.302545,
      NULL,
      NULL,
      0.715268,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.688850,
      NULL,
      NULL,
      0.652638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.600033,
      0.237731,
      1,
      NULL,
      NULL,
      3.057344,
      2.159646,
      1,
      1.659310,
      0.634714,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.709986,
      1.408596,
      1,
      2.536954,
      0.312896,
      7.695444,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      0,
      0.913395,
      0.643134,
      NULL,
      0.541797,
      0.001838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908280,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.946290,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.173883,
      NULL,
      NULL,
      1.925890,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.174386,
      0,
      0.223046,
      0.967098,
      1.148246,
      NULL,
      0.057510,
      NULL,
      NULL,
      1.260502,
      NULL,
      NULL,
      NULL,
      2.414032,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.164792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741825,
      NULL,
      NULL,
      NULL,
      1.997936,
      NULL,
      NULL,
      NULL,
      0.808187,
      NULL,
      NULL,
      NULL,
      0.043524,
      NULL,
      NULL,
      NULL,
      1.555086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.741675,
      NULL,
      NULL,
      NULL,
      2.842806,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.492812,
      NULL,
      NULL,
      NULL,
      7.757380,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.681614,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.127044,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.819640,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      229,
      10,
      1.276114,
      NULL,
      NULL,
      1.375994,
      1.726297,
      3,
      1.341968,
      3,
      0.832500,
      1,
      NULL,
      0,
      1.833932,
      0,
      NULL,
      0,
      1,
      2.955111,
      NULL,
      0.199031,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.349640,
      21,
      NULL,
      0.191570,
      0.847292,
      2,
      NULL,
      0.578119,
      NULL,
      1.657181,
      NULL,
      1,
      NULL,
      1.348649,
      NULL,
      0.827111,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.532017,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.713449,
      NULL,
      0,
      NULL,
      1.536644,
      1.311064,
      0.972619,
      NULL,
      NULL,
      0.574179,
      NULL,
      1.017721,
      NULL,
      NULL,
      NULL,
      1.691207,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155590,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762282,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534326,
      NULL,
      0.074956,
      NULL,
      0.786132,
      NULL,
      NULL,
      NULL,
      1.552775,
      1.175881,
      NULL,
      NULL,
      0.207335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748159,
      NULL,
      1.153966,
      NULL,
      1.369845,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0.649079,
      NULL,
      1.141184,
      1,
      2.271877,
      0.212953,
      0.937036,
      0,
      1.170072,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.854046,
      0.991105,
      NULL,
      0.973783,
      0,
      NULL,
      3,
      3,
      NULL,
      0.933623,
      NULL,
      NULL,
      0.568989,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.676163,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.009294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820771,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      1.499163,
      NULL,
      NULL,
      35,
      65.617618,
      NULL,
      0.609827,
      5.460069,
      '10120',
      '34431',
      '',
      1,
      '',
      '',
      '',
      3.090659,
      '43011',
      '',
      NULL);
commit;
end;
/


