set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '2412410',
      2.302983,
      NULL,
      5,
      1,
      '1130',
      3,
      0.652845,
      NULL,
      NULL,
      ' 8-29-1992',
      39.841119,
      NULL,
      NULL,
      1.976034,
      0,
      '10-20-1978',
      30.293255,
      0,
      NULL,
      147,
      NULL,
      NULL,
      ' 6-10-1992',
      ' 0-13-1986',
      0.742770,
      3,
      2.688046,
      3,
      0.716304,
      NULL,
      1,
      1,
      1.070528,
      3.081248,
      NULL,
      16.772836,
      0,
      NULL,
      15.064139,
      5,
      1,
      0,
      NULL,
      7.554249,
      0.246999,
      0,
      0,
      NULL,
      0,
      1.451966,
      1.871368,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      5,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      6,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.487429,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.519381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4,
      1,
      0,
      NULL,
      2,
      NULL,
      3,
      0,
      3,
      0,
      3,
      2,
      3,
      0,
      2,
      2,
      ' 4-19-1982',
      33,
      '11- 8-1977',
      93,
      0,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      113,
      2,
      0,
      2,
      3,
      0.937813,
      2,
      1.809979,
      1,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.227407,
      1.966648,
      4.597717,
      4,
      3.750426,
      5.688373,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.526706,
      0.608481,
      1.248714,
      0.618433,
      0.261560,
      0.122736,
      1.178466,
      26.842656,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.427521,
      1.105753,
      1,
      3,
      3,
      NULL,
      2,
      0,
      NULL,
      3,
      0,
      NULL,
      4,
      3.408434,
      3,
      7.128772,
      1.748929,
      NULL,
      0,
      1,
      1.569467,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0.370809,
      3,
      NULL,
      NULL,
      4,
      7,
      6.901875,
      4,
      1,
      NULL,
      NULL,
      3.864409,
      1,
      2,
      0.166724,
      65,
      0,
      0,
      NULL,
      47,
      21,
      32.295530,
      0,
      0.733554,
      5.376352,
      '03440',
      '11332',
      NULL,
      0.814128,
      '',
      '',
      NULL,
      NULL,
      '31224',
      '',
      '',
      0.051630,
      32.582384,
      20,
      44,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.008644,
      NULL,
      NULL,
      1,
      1.664831,
      NULL,
      NULL,
      1.193045,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.807751,
      2,
      3.104698,
      0,
      NULL,
      NULL,
      1.705860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751385,
      NULL,
      NULL,
      1.775947,
      NULL,
      NULL,
      NULL,
      9.873727,
      NULL,
      1,
      1.452426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.628260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458121,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.947815,
      NULL,
      NULL,
      0.753476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039990,
      0.434783,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1.792132,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.214620,
      NULL,
      NULL,
      0.019005,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.164153,
      NULL,
      NULL,
      0.441234,
      NULL,
      NULL,
      0.936296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863025,
      5,
      1,
      1.153975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.192234,
      3.564328,
      1.622910,
      0.858848,
      0,
      6,
      0.537065,
      3,
      NULL,
      0,
      0.466044,
      2.356104,
      0.793727,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.726837,
      5.533232,
      7,
      0,
      5.362812,
      5.782867,
      0.828396,
      0.400417,
      1,
      3,
      1.574897,
      1.765130,
      0,
      0,
      0.866193,
      2,
      NULL,
      NULL,
      0.207677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151763,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.059816,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.097016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802582,
      0,
      NULL,
      0,
      1,
      0.540398,
      0.036390,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269557,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.973158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.320060,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.984023,
      NULL,
      NULL,
      NULL,
      0.623774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.426086,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.518605,
      0.038638,
      0,
      NULL,
      0.230130,
      1,
      1.995366,
      0.292604,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670456,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.711553,
      131,
      NULL,
      1,
      3.331342,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.860766,
      2.427210,
      1,
      1.406687,
      0.350958,
      0.230295,
      1,
      0.701081,
      NULL,
      0.537957,
      NULL,
      NULL,
      NULL,
      1.003086,
      NULL,
      0.622852,
      NULL,
      NULL,
      NULL,
      3.676716,
      NULL,
      NULL,
      NULL,
      2.169313,
      30,
      NULL,
      1.659124,
      NULL,
      2.274344,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.882472,
      NULL,
      1.474929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.054949,
      NULL,
      0.098141,
      NULL,
      0,
      NULL,
      1.368315,
      NULL,
      1.257880,
      NULL,
      1,
      NULL,
      0.822558,
      2.910753,
      0,
      0.181109,
      NULL,
      0.894075,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.804055,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.061019,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.436959,
      NULL,
      3,
      NULL,
      541,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.157398,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.739438,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.929106,
      0.047415,
      NULL,
      0.718312,
      NULL,
      1.341044,
      NULL,
      NULL,
      NULL,
      1.540175,
      0,
      3.866723,
      NULL,
      1,
      NULL,
      1.294467,
      NULL,
      908.345987,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.192756,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0.572983,
      1.978057,
      0,
      3,
      2,
      5.512745,
      3.996565,
      2,
      1,
      1.592780,
      0,
      NULL,
      0.874676,
      1,
      NULL,
      0.365273,
      NULL,
      NULL,
      0.512258,
      NULL,
      NULL,
      3.778256,
      2,
      NULL,
      NULL,
      0.778344,
      NULL,
      0.964253,
      0.519703,
      NULL,
      0.986579,
      1.929706,
      NULL,
      1.571994,
      NULL,
      NULL,
      NULL,
      0.041821,
      NULL,
      NULL,
      0.414528,
      NULL,
      3,
      NULL,
      1.663529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      77.391969,
      96.586554,
      NULL,
      1,
      0.279247,
      '40432',
      '00320',
      '40110',
      1,
      '',
      '',
      '',
      3,
      '11141',
      '',
      '');
commit;
end;
/


