set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '44',
      NULL,
      36,
      2,
      '3302414',
      0,
      1.209482,
      4,
      NULL,
      '3124',
      2.317215,
      0.902853,
      NULL,
      NULL,
      NULL,
      58.496559,
      14.857206,
      NULL,
      1,
      1.859965,
      '10-21-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-1974',
      NULL,
      0,
      2,
      0.353460,
      1,
      3.107623,
      0,
      2,
      NULL,
      NULL,
      NULL,
      10.982281,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      3,
      0,
      1.552847,
      1.233490,
      1.976981,
      1.240229,
      NULL,
      0,
      NULL,
      1.318391,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      1,
      1,
      1,
      0,
      4,
      1,
      9.709552,
      1,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      1.761976,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0,
      NULL,
      3,
      NULL,
      1,
      3,
      NULL,
      0.114039,
      0,
      NULL,
      1.042466,
      2.753605,
      2,
      1,
      0.146791,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.492410,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      5,
      0,
      1,
      NULL,
      0,
      2,
      1,
      1,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.841467,
      0,
      4,
      1,
      1,
      0,
      4,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1,
      3,
      1,
      3,
      1,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      1,
      2.848127,
      ' 5-11-1990',
      277.494152,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      2,
      0,
      1.428783,
      0.259068,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.249457,
      1.204309,
      NULL,
      1.738525,
      NULL,
      1.948149,
      1.186856,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784037,
      0.829108,
      0.617494,
      0.737794,
      1,
      0,
      0.698440,
      NULL,
      NULL,
      NULL,
      1.130869,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      2,
      3,
      NULL,
      1,
      1,
      3,
      1,
      2,
      2,
      2,
      2.062372,
      2,
      1,
      0,
      3,
      1,
      0.533761,
      1,
      1,
      NULL,
      1.306004,
      1,
      1.615329,
      0,
      2,
      3,
      1,
      6,
      10.814550,
      1.324177,
      3.774539,
      4,
      6,
      0,
      3,
      1.558779,
      0,
      1,
      0,
      60.963598,
      3,
      1.731099,
      14,
      NULL,
      NULL,
      NULL,
      4,
      3.074733,
      NULL,
      '30143',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.290766,
      4,
      28.101816,
      11,
      0.380219,
      NULL,
      NULL,
      NULL,
      NULL,
      0.050467,
      3,
      3.214049,
      3.009130,
      NULL,
      1,
      NULL,
      2.067994,
      1.926829,
      2.109440,
      1,
      0,
      0,
      NULL,
      NULL,
      2,
      0,
      0.177136,
      3.678110,
      0.045695,
      3,
      1.846716,
      NULL,
      NULL,
      NULL,
      2.101583,
      2,
      2,
      2,
      3.666520,
      1.341836,
      2.898304,
      2.468434,
      0,
      2.576783,
      1,
      2.657568,
      5.423725,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.678127,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858922,
      0,
      2,
      0.812614,
      1.518061,
      NULL,
      3,
      1,
      1.542229,
      1,
      0.240950,
      3.317250,
      1.837586,
      NULL,
      3,
      3.248073,
      NULL,
      0.837451,
      0.033960,
      1,
      NULL,
      0.218067,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.968082,
      3.670819,
      1,
      NULL,
      1.442209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.493898,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.580895,
      NULL,
      NULL,
      0.094250,
      NULL,
      NULL,
      0.695429,
      2.707845,
      3,
      NULL,
      0.815269,
      NULL,
      5.084344,
      4,
      6.171076,
      0.185376,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      9,
      4.433185,
      8.962169,
      NULL,
      NULL,
      NULL,
      0.174061,
      1.404604,
      2.951542,
      1,
      NULL,
      NULL,
      NULL,
      2.039705,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.960296,
      1.273399,
      0.273874,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.768838,
      5.153373,
      NULL,
      2.218977,
      2,
      NULL,
      NULL,
      0,
      1,
      1.264970,
      0,
      1,
      NULL,
      NULL,
      1.141970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.698811,
      NULL,
      NULL,
      0.725182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947740,
      NULL,
      NULL,
      0.740541,
      1.600276,
      NULL,
      1.744385,
      NULL,
      0.875433,
      0.751208,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      5.731884,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.938203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094404,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.645804,
      NULL,
      NULL,
      NULL,
      0.698835,
      NULL,
      NULL,
      NULL,
      3.533763,
      NULL,
      NULL,
      NULL,
      0.802281,
      NULL,
      NULL,
      NULL,
      0.546668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.038579,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.228040,
      NULL,
      NULL,
      1.172805,
      NULL,
      NULL,
      1.048110,
      0,
      13.344777,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.426729,
      166,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0.751169,
      1,
      1,
      0.460658,
      NULL,
      1,
      0.809441,
      0,
      1.888281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346008,
      1.080862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.030838,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708630,
      0.263749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.539471,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.945821,
      0,
      2.385467,
      NULL,
      3.549841,
      NULL,
      0.176687,
      NULL,
      NULL,
      NULL,
      0.895526,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.894341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      8,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      1.324252,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      3.858803,
      3.946538,
      NULL,
      2.362926,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.298390,
      1,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      1,
      1.270403,
      NULL,
      1,
      0,
      NULL,
      2,
      0.116620,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024028,
      NULL,
      NULL,
      NULL,
      4,
      6,
      7,
      0,
      NULL,
      NULL,
      35.740548,
      64,
      0,
      1.495905,
      2,
      '22204',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


