set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9726580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.223052,
      3.208657,
      1,
      0.563810,
      0,
      2.859039,
      3.369675,
      1,
      NULL,
      '04120030',
      49,
      18.552324,
      '3431242',
      2.485168,
      NULL,
      4,
      NULL,
      '0212',
      NULL,
      1,
      NULL,
      NULL,
      ' 2- 7-1997',
      57,
      8.979873,
      NULL,
      0.301703,
      1.494557,
      ' 9- 7-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 7-18-1988',
      ' 9- 9-1995',
      '11-17-2001',
      2.380459,
      NULL,
      2.561914,
      1,
      NULL,
      3,
      2,
      NULL,
      1.778105,
      NULL,
      NULL,
      6.281052,
      1.532293,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1.892425,
      0,
      1,
      0.903719,
      0.551525,
      1.001896,
      1,
      1.480025,
      1.111515,
      3,
      0.875190,
      4,
      2,
      6,
      0.741327,
      NULL,
      0,
      1,
      2,
      1,
      NULL,
      2,
      0,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      1.190015,
      NULL,
      NULL,
      2.796838,
      1,
      NULL,
      4,
      2,
      NULL,
      3.174372,
      0.607598,
      1,
      1,
      0.132006,
      NULL,
      3.179962,
      0,
      1.977123,
      0,
      3.276932,
      NULL,
      1,
      1.330700,
      NULL,
      1.444176,
      NULL,
      1,
      2,
      6,
      0,
      0,
      2,
      1.749282,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      2,
      1,
      NULL,
      3,
      NULL,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0,
      5,
      NULL,
      3,
      NULL,
      0,
      1,
      4,
      3,
      4,
      NULL,
      2,
      4,
      4,
      1,
      2,
      NULL,
      2,
      5,
      NULL,
      0,
      4,
      2,
      0,
      5,
      2,
      0,
      3,
      ' 8-24-2000',
      139.840708,
      ' 1-10-1998',
      17.728409,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3,
      0.230379,
      3,
      0,
      1,
      2.241421,
      1.610620,
      8,
      4,
      2.889378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660968,
      0,
      6.659042,
      2.940579,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      4.546743,
      2.916913,
      0,
      3,
      NULL,
      4.711884,
      NULL,
      NULL,
      ' 1-12-1985',
      155,
      2,
      NULL,
      1.924044,
      0.372814,
      0.755354,
      0,
      1,
      1,
      0.374047,
      NULL,
      0.710051,
      32.750016,
      3.889261,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.010642,
      3.469953,
      1,
      0,
      0,
      NULL,
      1,
      3,
      1,
      3,
      0,
      2,
      NULL,
      3.750461,
      1.321846,
      0,
      2.481086,
      1.725355,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.394718,
      NULL,
      0.841849,
      NULL,
      0.145101,
      1,
      NULL,
      NULL,
      8,
      0,
      NULL,
      NULL,
      5,
      4.844643,
      1,
      2.834812,
      0.698901,
      NULL,
      1.318628,
      NULL,
      3,
      1,
      40,
      NULL,
      41,
      11,
      3,
      5.190524,
      1.169620,
      '10012',
      '22212',
      '',
      1.483776,
      NULL,
      '',
      '',
      0.073035,
      '0240',
      '',
      '',
      0.399370,
      36.226507,
      25.433541,
      NULL,
      1.225919,
      NULL,
      NULL,
      NULL,
      NULL,
      3.213706,
      2.797343,
      0.724708,
      0,
      NULL,
      NULL,
      1,
      3.014953,
      2.032426,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152049,
      NULL,
      NULL,
      3.041789,
      2.118683,
      0.205480,
      1.483061,
      NULL,
      NULL,
      3.994063,
      NULL,
      1,
      NULL,
      2,
      3.857595,
      0.406760,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      0.327253,
      NULL,
      NULL,
      1.137879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.514504,
      NULL,
      NULL,
      0.910008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.853953,
      NULL,
      1.152553,
      0,
      3.766892,
      3,
      0.912662,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.951694,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.226589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.580315,
      3.273534,
      2,
      0,
      NULL,
      NULL,
      7,
      4,
      4.643028,
      NULL,
      4,
      1.617767,
      1,
      NULL,
      NULL,
      2,
      3.496346,
      0,
      1,
      0.556199,
      1.493118,
      NULL,
      NULL,
      2.908347,
      2,
      5,
      2.922767,
      NULL,
      0,
      1.127691,
      0,
      0.442306,
      NULL,
      1,
      1,
      NULL,
      3.862087,
      NULL,
      1.124444,
      0,
      NULL,
      5,
      5,
      NULL,
      3.406782,
      3.764241,
      3,
      0,
      1,
      0,
      0,
      0.677842,
      0.759012,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326025,
      NULL,
      NULL,
      0.668492,
      NULL,
      NULL,
      0.302002,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.846112,
      NULL,
      NULL,
      1.194047,
      NULL,
      NULL,
      NULL,
      1.634326,
      NULL,
      1.879504,
      0.307773,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      164.311120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.772643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.575390,
      NULL,
      NULL,
      NULL,
      0.927663,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.598425,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.984994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.239453,
      NULL,
      NULL,
      NULL,
      11.961424,
      NULL,
      NULL,
      NULL,
      0.995584,
      1.198381,
      1,
      2,
      NULL,
      1,
      1.686801,
      0.873931,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.802694,
      NULL,
      NULL,
      0.772342,
      NULL,
      0.745529,
      1.253565,
      NULL,
      3,
      1.873318,
      1.636440,
      0.415650,
      NULL,
      0,
      0,
      1.331084,
      1,
      0,
      3.509392,
      0,
      1,
      0.092532,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.836346,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      12,
      NULL,
      2.472228,
      NULL,
      3.766713,
      NULL,
      0,
      1.837350,
      NULL,
      0,
      NULL,
      0.967811,
      NULL,
      NULL,
      NULL,
      0.932853,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.107614,
      NULL,
      1.329566,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.241102,
      NULL,
      1.487914,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.345966,
      0,
      6,
      2,
      0,
      19.951107,
      1,
      2,
      0.646659,
      1.228491,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      0.729329,
      NULL,
      1.256518,
      0.074790,
      NULL,
      3.617837,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.924331,
      1.786782,
      NULL,
      0,
      0,
      NULL,
      1.940778,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.059156,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.860953,
      0,
      NULL,
      3,
      NULL,
      1.498802,
      NULL,
      3.969714,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.611899,
      NULL,
      0,
      NULL,
      1.134320,
      NULL,
      2.924170,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      19.557326,
      2.637328,
      5.612496,
      0.131588,
      NULL,
      0.172086,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      0.036449,
      NULL,
      NULL,
      28.793402,
      NULL,
      3,
      3.676266,
      6,
      '30230',
      '10421',
      '23102',
      0.646969,
      '',
      '',
      '',
      NULL,
      '14301',
      NULL,
      '');
commit;
end;
/


