set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9852721';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2.036597,
      2,
      2,
      0,
      3.779852,
      1.478963,
      NULL,
      '431',
      '31121002',
      9.396124,
      39.022145,
      '4040031',
      0.272861,
      NULL,
      2,
      NULL,
      NULL,
      0.974320,
      0,
      NULL,
      NULL,
      ' 6-14-1986',
      106,
      78,
      NULL,
      1,
      2.524240,
      ' 2-17-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 4- 4-1995',
      ' 9-18-1993',
      1.762825,
      NULL,
      0.869677,
      3,
      NULL,
      1.069181,
      3,
      1,
      1,
      28,
      0,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0.616420,
      NULL,
      NULL,
      1.733806,
      1.972781,
      1.832427,
      1.895417,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      3,
      1,
      2,
      3,
      2,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      0.245845,
      1.883697,
      0,
      1.859855,
      3,
      2,
      NULL,
      1,
      2,
      NULL,
      1,
      3,
      3,
      1.920992,
      0,
      NULL,
      2,
      2,
      1,
      0,
      2.515920,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      5,
      1,
      2,
      1,
      1,
      0,
      1,
      0,
      NULL,
      3,
      1,
      3.714418,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      5,
      NULL,
      0,
      4,
      0,
      NULL,
      4,
      0,
      0,
      5,
      4,
      5,
      0,
      4,
      NULL,
      0,
      4,
      0,
      1,
      5,
      1,
      ' 6-22-1976',
      272,
      ' 9-24-1990',
      357.234197,
      3,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.472877,
      NULL,
      0.664430,
      1,
      0,
      3,
      NULL,
      2,
      1.819320,
      3.449978,
      1.633794,
      NULL,
      NULL,
      NULL,
      1.578036,
      0.564704,
      1.991634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012263,
      NULL,
      1,
      0.956401,
      0,
      NULL,
      0.742545,
      2,
      9,
      3.808676,
      0.878937,
      NULL,
      NULL,
      NULL,
      2,
      1.007580,
      NULL,
      0,
      2,
      2,
      3,
      0,
      1,
      NULL,
      3,
      2,
      0,
      1,
      0,
      2,
      1,
      0,
      0.489874,
      3.663633,
      NULL,
      1,
      0.766247,
      1.251669,
      1,
      NULL,
      0.798849,
      1,
      NULL,
      1,
      3.090204,
      1,
      11,
      1,
      6.727634,
      NULL,
      3.677442,
      0.964904,
      4,
      0,
      7.900326,
      3,
      NULL,
      3,
      28.996795,
      1,
      2.956813,
      66,
      NULL,
      54,
      27,
      0,
      NULL,
      3.475476,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.481900,
      NULL,
      54.363152,
      10,
      1,
      NULL,
      5.399307,
      6,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.033920,
      0.401499,
      0,
      0.091442,
      2.449155,
      1,
      0,
      NULL,
      NULL,
      2,
      1.304157,
      3,
      2,
      0.879826,
      1,
      3,
      1,
      1.062280,
      1,
      1,
      1,
      2.662078,
      0.564131,
      0.854054,
      0.659990,
      0.846944,
      NULL,
      NULL,
      3.904246,
      3.537428,
      NULL,
      1.036826,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.263076,
      1.480693,
      1.509191,
      0.173977,
      NULL,
      0,
      NULL,
      1,
      1.832648,
      2,
      2.410791,
      3.222543,
      0.751556,
      2,
      NULL,
      0.249262,
      0,
      1,
      1.885803,
      1,
      2.225155,
      0.612158,
      1,
      NULL,
      NULL,
      1.592434,
      NULL,
      NULL,
      0.033245,
      0,
      1,
      4.093846,
      7.539996,
      6.590069,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640985,
      2.668823,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      1.513049,
      NULL,
      3,
      3,
      1,
      1,
      5,
      0.921978,
      1.680468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.740477,
      NULL,
      NULL,
      3.579812,
      1.949619,
      0.833784,
      1.566036,
      0.567177,
      2.606287,
      NULL,
      1.278497,
      NULL,
      5,
      5.447132,
      1.327003,
      0.376515,
      NULL,
      NULL,
      3,
      2.403884,
      2,
      1,
      0,
      2.077788,
      1.006296,
      2,
      NULL,
      2.608413,
      NULL,
      3.080717,
      2,
      2.037408,
      3,
      NULL,
      NULL,
      2,
      1.014922,
      1,
      0,
      2,
      0,
      1,
      3.111114,
      1,
      0.102271,
      7.839857,
      3,
      NULL,
      0.902518,
      1,
      1,
      0.052430,
      0.141326,
      1.814106,
      NULL,
      1.544465,
      1.813394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652228,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.504496,
      NULL,
      NULL,
      0.015626,
      NULL,
      NULL,
      0.510336,
      NULL,
      NULL,
      3.611505,
      NULL,
      NULL,
      0.527909,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.466685,
      0.764169,
      2,
      0,
      NULL,
      NULL,
      1.295931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.855892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.294882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.881297,
      NULL,
      NULL,
      NULL,
      1.139693,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.179053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.902822,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.505583,
      34,
      1.800316,
      1.748197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.990349,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.953880,
      41.386674,
      2.441232,
      NULL,
      NULL,
      0,
      0,
      1,
      1.784410,
      0.653278,
      3,
      0.740291,
      0.944362,
      1.270228,
      0,
      NULL,
      0.183770,
      0.600872,
      0.360673,
      1.364729,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.155244,
      NULL,
      1.774418,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      2.426691,
      NULL,
      NULL,
      0,
      0.402021,
      NULL,
      NULL,
      1,
      NULL,
      0.438214,
      NULL,
      0,
      NULL,
      0.254214,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.050000,
      NULL,
      0.256841,
      NULL,
      0.062263,
      NULL,
      0,
      NULL,
      0.304044,
      NULL,
      0,
      NULL,
      1.613282,
      NULL,
      0.569264,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.008815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      55.862470,
      NULL,
      NULL,
      NULL,
      0.747608,
      NULL,
      1.369095,
      NULL,
      1,
      0.179871,
      NULL,
      NULL,
      2.276880,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.921385,
      NULL,
      0,
      NULL,
      3.419684,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921339,
      3.136341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.317629,
      1,
      0.664144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597032,
      NULL,
      0.826090,
      NULL,
      0,
      1.237743,
      NULL,
      3.529276,
      10,
      1.013784,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.201554,
      3,
      3,
      NULL,
      0,
      9.854162,
      NULL,
      NULL,
      NULL,
      0.624046,
      0,
      NULL,
      1.743586,
      3.111667,
      NULL,
      1,
      3,
      NULL,
      0.534463,
      3.857500,
      NULL,
      NULL,
      0.970708,
      NULL,
      0.953391,
      1.442673,
      NULL,
      1,
      NULL,
      NULL,
      0.402450,
      2.937827,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.077941,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314994,
      NULL,
      1,
      NULL,
      1.331195,
      NULL,
      4,
      0,
      2,
      0.243905,
      NULL,
      NULL,
      71.298020,
      NULL,
      4,
      5.238900,
      5,
      NULL,
      '32104',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


