set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016189';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '1021002',
      1.729136,
      1,
      2,
      3,
      '4032',
      0,
      0.915191,
      NULL,
      NULL,
      ' 1- 1-1992',
      69,
      NULL,
      3,
      0,
      NULL,
      ' 4-24-1980',
      75,
      4.339223,
      255.500216,
      87,
      0,
      ' 9- 8-1977',
      NULL,
      ' 2-17-1983',
      1.021250,
      2.855000,
      0.752811,
      0,
      0,
      2.653476,
      1,
      1,
      1.832866,
      46,
      1,
      3.440341,
      NULL,
      15.246007,
      NULL,
      5,
      29,
      NULL,
      3,
      6.340614,
      1.573629,
      0,
      0,
      0.846925,
      0,
      0.311218,
      0,
      0,
      NULL,
      1,
      128,
      4,
      5,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      4,
      3,
      NULL,
      0,
      5,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      0.676292,
      0,
      NULL,
      0,
      1,
      3.365587,
      0.861240,
      NULL,
      1.908910,
      0,
      NULL,
      0.492411,
      0.901440,
      1,
      1.755463,
      3,
      1,
      0,
      8,
      NULL,
      1,
      1,
      0.053870,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      3,
      1,
      0,
      5,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      1.014307,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      0,
      4,
      NULL,
      NULL,
      4,
      3,
      2,
      5,
      3,
      NULL,
      1,
      1,
      2,
      3,
      5,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      8.591466,
      0.469580,
      ' 9-19-1980',
      472,
      ' 6-25-1985',
      1553,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.647378,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510221,
      4,
      1.542103,
      0.719438,
      0.151413,
      5,
      0,
      NULL,
      NULL,
      NULL,
      0.900525,
      1,
      1.303625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.780612,
      0,
      0.705466,
      NULL,
      0.424942,
      1.488503,
      3.400442,
      4189,
      0,
      1.338176,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      1,
      0,
      0,
      NULL,
      3,
      1,
      3,
      2,
      3,
      0,
      1.203640,
      1,
      1.464161,
      NULL,
      1,
      NULL,
      0.887573,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      15,
      0.147959,
      1.046729,
      10.049818,
      8,
      2.642147,
      1.812662,
      10,
      NULL,
      3.128266,
      3.684655,
      NULL,
      1.500648,
      0.069990,
      0.044703,
      26.356776,
      2,
      1,
      NULL,
      45,
      34,
      12,
      5,
      NULL,
      3,
      '41232',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.653606,
      NULL,
      '',
      '',
      3.891018,
      12,
      197,
      10.228896,
      3.002157,
      3,
      NULL,
      46,
      3,
      0.820904,
      2.658074,
      3.770948,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.321060,
      NULL,
      3,
      3.189687,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.989825,
      NULL,
      3,
      0.600682,
      1,
      3,
      NULL,
      2,
      0,
      1,
      NULL,
      0.647363,
      1,
      NULL,
      1,
      NULL,
      NULL,
      5,
      9,
      NULL,
      1,
      0.103264,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.074575,
      0,
      NULL,
      NULL,
      2,
      0.183878,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      2.456171,
      3,
      NULL,
      1,
      NULL,
      1,
      0.228712,
      1.934891,
      1.793384,
      0.865362,
      11,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.919138,
      1,
      NULL,
      0.300182,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.804372,
      NULL,
      NULL,
      0.939009,
      2.491116,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      6,
      3.225192,
      NULL,
      NULL,
      2.074911,
      1,
      3.653653,
      0,
      2,
      9.947025,
      1,
      4.160611,
      0.019827,
      NULL,
      NULL,
      1.529490,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.785424,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.484493,
      NULL,
      NULL,
      2.094276,
      2.984690,
      2,
      1.755260,
      1.009643,
      1.879435,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      5,
      1.098892,
      1.477357,
      0.220269,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.803390,
      1.597916,
      3,
      2,
      7,
      3.545179,
      1.696854,
      1.130173,
      0.001246,
      NULL,
      0,
      2,
      NULL,
      3.109876,
      3.618866,
      2,
      NULL,
      1.528703,
      6,
      6,
      NULL,
      1.309573,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1.988829,
      0,
      0.630381,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.705095,
      NULL,
      NULL,
      1.937915,
      NULL,
      NULL,
      3.120373,
      NULL,
      NULL,
      NULL,
      1.459525,
      1,
      1.808790,
      0,
      2.848554,
      1.392635,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      41.926842,
      NULL,
      NULL,
      NULL,
      3.359804,
      NULL,
      NULL,
      NULL,
      3.013844,
      NULL,
      NULL,
      NULL,
      0.058549,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733797,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.139511,
      1,
      NULL,
      NULL,
      1,
      1.234150,
      NULL,
      NULL,
      1.482553,
      0.185489,
      NULL,
      NULL,
      0.918500,
      NULL,
      NULL,
      NULL,
      3,
      1.652424,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      316,
      NULL,
      0.683169,
      NULL,
      1.840663,
      0.535431,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.064345,
      NULL,
      NULL,
      1.169906,
      NULL,
      NULL,
      3,
      7.114166,
      NULL,
      678.401866,
      49,
      0,
      1.030982,
      1,
      1.412870,
      0.766041,
      0,
      NULL,
      0,
      NULL,
      1.287019,
      1.921204,
      NULL,
      1,
      1,
      0,
      NULL,
      1.886605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6.555874,
      NULL,
      1.434180,
      5.341112,
      1,
      11.344037,
      2.308386,
      NULL,
      2,
      1,
      0,
      0,
      0.220399,
      3.247425,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      0.053968,
      2.807112,
      2,
      3.896455,
      0.505607,
      1.820771,
      NULL,
      0,
      0,
      0.927319,
      0.496215,
      NULL,
      0.821501,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      0.780270,
      0.635236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889386,
      NULL,
      0.519276,
      0,
      NULL,
      NULL,
      2,
      4,
      4,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.925254,
      1,
      '24204',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1.559376,
      '',
      '',
      '');
commit;
end;
/


