set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.727173,
      1,
      3,
      '2413',
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 1-2000',
      3,
      NULL,
      4,
      0.721765,
      1,
      NULL,
      2.560204,
      0.762186,
      290,
      214,
      3,
      NULL,
      ' 7-10-1991',
      NULL,
      NULL,
      1.640732,
      3.679325,
      2,
      NULL,
      2,
      NULL,
      0.683165,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      20,
      NULL,
      5,
      11,
      5,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      2,
      1,
      NULL,
      5,
      0,
      2,
      1,
      0,
      0,
      3,
      2,
      0,
      1,
      5,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.158581,
      0.531362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      2,
      2,
      4,
      0,
      0,
      2,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      0.965617,
      NULL,
      1.892534,
      4,
      3,
      3,
      4,
      1,
      3,
      3,
      0,
      1,
      NULL,
      0,
      3,
      4,
      2,
      5,
      3,
      0,
      NULL,
      4,
      NULL,
      NULL,
      5,
      3,
      0,
      0,
      3,
      1.495468,
      ' 9-18-1979',
      392,
      ' 2- 5-1999',
      NULL,
      2.546188,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0.492104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.392989,
      0.964241,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3.325478,
      2,
      6,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.329033,
      4.853581,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080425,
      1.502190,
      NULL,
      1.219084,
      0,
      0,
      1.753747,
      NULL,
      53.144137,
      0.396812,
      1.383033,
      25.135177,
      NULL,
      NULL,
      0,
      1.011263,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      3,
      3,
      3,
      1.863010,
      3,
      1,
      1.788495,
      1,
      2.878287,
      1.718312,
      NULL,
      1.608493,
      NULL,
      0.727988,
      NULL,
      1.043122,
      0.653431,
      0,
      0.689304,
      NULL,
      0,
      11,
      6.127660,
      NULL,
      7,
      5.461463,
      3.406034,
      4.071976,
      3.427643,
      7.364361,
      2.657587,
      2.224698,
      1,
      53.922619,
      1,
      3.013923,
      NULL,
      60,
      39,
      72,
      3,
      0.250657,
      NULL,
      '02424',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      2.397155,
      8.311567,
      42,
      5,
      1,
      6,
      NULL,
      1.819609,
      0,
      0.804074,
      0.391164,
      0.025442,
      0.041541,
      NULL,
      NULL,
      3.180973,
      1.385734,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.483392,
      3.992852,
      NULL,
      NULL,
      3,
      NULL,
      1.414098,
      0.762436,
      NULL,
      NULL,
      3,
      0.047631,
      NULL,
      1,
      1,
      1,
      1.676107,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.529614,
      8,
      3.203343,
      NULL,
      1.055327,
      NULL,
      NULL,
      NULL,
      1.058186,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.908860,
      NULL,
      NULL,
      3.543418,
      1.263837,
      1.122634,
      NULL,
      1.794662,
      2.724874,
      3.027534,
      3.990945,
      3.277098,
      NULL,
      1.743614,
      2,
      1.259299,
      1,
      1.078144,
      1,
      0,
      1,
      1,
      0.060414,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      3,
      0,
      0,
      1.247852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.001543,
      1.829304,
      NULL,
      NULL,
      1.113844,
      NULL,
      NULL,
      2.924636,
      7.748822,
      4,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      0,
      3,
      2,
      1.380184,
      3.383009,
      1.823931,
      1,
      2,
      0.722997,
      1.677843,
      NULL,
      NULL,
      1.050145,
      NULL,
      NULL,
      NULL,
      0,
      0.745119,
      NULL,
      3.617595,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      0,
      2.952615,
      3,
      NULL,
      2.237079,
      0,
      2.240831,
      3.742454,
      0.765085,
      1.367904,
      0.945977,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      9,
      3,
      1.039896,
      2.410917,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.755344,
      0,
      1.052829,
      NULL,
      0,
      0.109977,
      NULL,
      NULL,
      2.966910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.637235,
      NULL,
      NULL,
      0.781403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.294210,
      NULL,
      NULL,
      0.484854,
      NULL,
      NULL,
      9.436963,
      NULL,
      NULL,
      0,
      0.050005,
      1,
      0.015442,
      1,
      1.146994,
      NULL,
      NULL,
      NULL,
      2.922912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.224832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.770057,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024641,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.556270,
      NULL,
      NULL,
      NULL,
      1.018085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      0.805634,
      102.365974,
      NULL,
      1,
      NULL,
      NULL,
      0.237191,
      NULL,
      NULL,
      1.324950,
      82.055113,
      9,
      0.923582,
      NULL,
      NULL,
      0.207634,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863877,
      NULL,
      33,
      NULL,
      0.760535,
      0,
      NULL,
      1.145473,
      1,
      1,
      1.424927,
      1.467187,
      3,
      0.719267,
      NULL,
      0.048820,
      1.392658,
      1.392121,
      3.090561,
      1.385142,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      30,
      NULL,
      2,
      1.451576,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543341,
      NULL,
      NULL,
      NULL,
      2.910650,
      NULL,
      0.933287,
      NULL,
      1.617125,
      NULL,
      0.077037,
      NULL,
      1.470511,
      NULL,
      1.598058,
      NULL,
      1,
      NULL,
      1.970490,
      NULL,
      1,
      NULL,
      1.431223,
      NULL,
      1.170097,
      2.693180,
      1.262461,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934679,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364682,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.257558,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294477,
      1,
      0.783813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.858533,
      NULL,
      0.553978,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      3.560230,
      NULL,
      1.510305,
      NULL,
      NULL,
      1,
      1.250754,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0.302044,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      2,
      0,
      1.576943,
      3.793858,
      1,
      0.838041,
      1.785189,
      2,
      1.664359,
      0.933014,
      NULL,
      NULL,
      3.791210,
      0.987938,
      NULL,
      0.833754,
      3,
      0,
      3.575090,
      0,
      0.254302,
      1,
      NULL,
      1.127156,
      1.651523,
      1.477229,
      NULL,
      0.360290,
      NULL,
      1,
      0.976465,
      NULL,
      0,
      NULL,
      0.682177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.103762,
      0.669586,
      NULL,
      1.457338,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.569676,
      0.600727,
      0.854438,
      2.535874,
      0.967256,
      3.344551,
      1,
      0.627678,
      3.107408,
      1.328137,
      2.751772,
      1.507307,
      3.812787,
      3,
      0.493800,
      1,
      9,
      NULL,
      2.954764,
      NULL,
      0.290041,
      NULL,
      1,
      0.531138,
      NULL,
      4,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      41,
      1,
      1.863183,
      3,
      '10030',
      '02142',
      '21041',
      1,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


