set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7931645';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      12,
      NULL,
      '0332012',
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      1.089955,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      NULL,
      0,
      0,
      '10-20-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 7- 0-1991',
      2,
      1.320946,
      3.916544,
      1,
      0.776651,
      1,
      3,
      1,
      1,
      338.807715,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.242314,
      0,
      NULL,
      0.802851,
      1,
      0.020004,
      1.684995,
      1.722643,
      4,
      4,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      6,
      0,
      2,
      0,
      1,
      0.127186,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      3,
      3,
      NULL,
      3,
      0,
      0,
      3,
      0,
      NULL,
      2.675110,
      0,
      0,
      NULL,
      1,
      2.139517,
      1.110655,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      2,
      0.889768,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      2.338930,
      3,
      4,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      5,
      NULL,
      0,
      0,
      NULL,
      4,
      5.856002,
      NULL,
      '10- 5-1979',
      2831,
      ' 2-19-1983',
      2444,
      3.714405,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0.602199,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.882325,
      0,
      0,
      3.644833,
      0,
      NULL,
      NULL,
      NULL,
      1.504297,
      0.591487,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801617,
      0.486487,
      1.959629,
      NULL,
      0.613897,
      0,
      0.077040,
      2,
      369,
      NULL,
      0.494701,
      97.994222,
      13,
      NULL,
      NULL,
      1.302687,
      0,
      0,
      1,
      1,
      2,
      3,
      3,
      0,
      NULL,
      NULL,
      3,
      1.768422,
      2,
      NULL,
      NULL,
      0.195172,
      1.234254,
      2,
      NULL,
      1.646421,
      1,
      NULL,
      1,
      1,
      1.188743,
      0.967545,
      1,
      1,
      2,
      1,
      11,
      NULL,
      5.006077,
      2.536530,
      10,
      4,
      3,
      3.919185,
      6.440481,
      0.384814,
      2.003845,
      NULL,
      61.195180,
      3,
      3.300375,
      65,
      NULL,
      55,
      6,
      3,
      0,
      2,
      '20032',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      2.968350,
      11,
      65,
      12,
      0,
      41,
      51.118526,
      108.853245,
      0,
      1,
      0.257788,
      2.873564,
      1,
      NULL,
      NULL,
      3.036636,
      0.549081,
      NULL,
      0.981289,
      NULL,
      NULL,
      2.574640,
      NULL,
      1.118244,
      0.526029,
      NULL,
      NULL,
      2,
      2.579174,
      1.360098,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      0.943829,
      0,
      0,
      1,
      NULL,
      NULL,
      2.788801,
      2.546773,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.873920,
      NULL,
      3,
      1.232475,
      0,
      0,
      NULL,
      1,
      2,
      1.470831,
      NULL,
      0.558316,
      0.852054,
      1.201660,
      2,
      0.259174,
      0,
      0,
      2,
      1,
      3.976274,
      0.929609,
      0,
      0,
      1.183347,
      2,
      0.835750,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.450095,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.397885,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.139616,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.249300,
      5.011691,
      0,
      0,
      NULL,
      NULL,
      1.953104,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.208266,
      NULL,
      NULL,
      1.095774,
      NULL,
      NULL,
      0.187196,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.354137,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.604213,
      0.325131,
      0.324582,
      NULL,
      NULL,
      0.583591,
      0,
      NULL,
      0,
      NULL,
      3,
      2.865142,
      1.116758,
      3.339960,
      6.472416,
      1,
      0,
      2.202275,
      0,
      2.857709,
      2.060161,
      1.787659,
      3,
      3,
      1.821693,
      2,
      1,
      NULL,
      NULL,
      6.519530,
      NULL,
      3.977280,
      5,
      3.744677,
      1,
      3.751517,
      1,
      NULL,
      0.644020,
      1,
      0,
      1,
      1,
      3.969794,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.947754,
      NULL,
      NULL,
      1.954836,
      NULL,
      NULL,
      1.576181,
      NULL,
      NULL,
      1.526857,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.276874,
      NULL,
      NULL,
      3.777648,
      1,
      3.465976,
      1,
      0,
      NULL,
      1.118164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67.511320,
      NULL,
      NULL,
      NULL,
      1.050896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.146615,
      NULL,
      NULL,
      NULL,
      0.694909,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.608894,
      NULL,
      NULL,
      NULL,
      0.943287,
      NULL,
      NULL,
      NULL,
      0.002527,
      NULL,
      NULL,
      NULL,
      1.044324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188213,
      2,
      7,
      2,
      3.783344,
      189.536972,
      235,
      2,
      65,
      6,
      1,
      NULL,
      NULL,
      2.134678,
      67.496544,
      8982,
      0.187182,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.562866,
      23.579644,
      1,
      0,
      0,
      NULL,
      0,
      1.007116,
      1.219405,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      0.612222,
      1,
      0,
      1.059687,
      0.815082,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      NULL,
      NULL,
      2.154852,
      2,
      NULL,
      NULL,
      3,
      3.230290,
      1.991201,
      1.128027,
      2.116568,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      NULL,
      0,
      2.597370,
      NULL,
      1,
      0.193288,
      NULL,
      0.540219,
      1.583725,
      NULL,
      2.167902,
      1.152238,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.508912,
      NULL,
      0,
      1,
      NULL,
      0.284449,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.979579,
      NULL,
      0,
      0,
      1,
      2.062043,
      3,
      2,
      61,
      71,
      0,
      NULL,
      3.553058,
      '34200',
      NULL,
      '',
      0.924422,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


