set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9510460';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20',
      '11',
      NULL,
      7,
      '2100122',
      0.709351,
      1.210450,
      0,
      1,
      '3320',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 9-1990',
      NULL,
      44,
      NULL,
      3.206673,
      2.228393,
      '11- 4-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 8-28-1980',
      ' 8- 4-1983',
      ' 5- 0-1999',
      1,
      NULL,
      NULL,
      NULL,
      2.289235,
      0.529935,
      NULL,
      0,
      1.420897,
      1,
      4,
      12.127787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0.509121,
      NULL,
      1,
      5,
      1,
      1,
      0,
      5,
      0,
      3,
      4,
      1,
      1,
      5,
      NULL,
      1,
      0,
      3,
      3,
      4.471743,
      0,
      2,
      0,
      0,
      0.366757,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1.711616,
      2,
      NULL,
      0.729011,
      2,
      3.436778,
      1,
      0.852451,
      1.270490,
      1.145557,
      1.601884,
      0,
      NULL,
      NULL,
      0.764389,
      3.490487,
      5,
      1,
      NULL,
      10,
      NULL,
      1,
      3.454997,
      0,
      NULL,
      NULL,
      1.234240,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1.045551,
      NULL,
      5,
      1,
      NULL,
      1,
      4,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      5,
      2,
      4,
      5,
      2,
      3,
      1,
      5,
      3.720464,
      1.806122,
      '10-17-1989',
      211.487824,
      ' 9-28-2000',
      303,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0.613101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.933015,
      1,
      0,
      1.787087,
      0.365386,
      2.563728,
      3,
      NULL,
      NULL,
      NULL,
      1.033075,
      0,
      1.737634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.304169,
      0,
      0.014158,
      0,
      1.162454,
      1.762879,
      0.068158,
      NULL,
      0.764041,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      1,
      0,
      NULL,
      1,
      1,
      3,
      2,
      0,
      1,
      NULL,
      0,
      4.433767,
      0.962640,
      1,
      2.861228,
      0.522939,
      0.714197,
      0.292292,
      0.943393,
      1,
      1,
      1.859755,
      0.565160,
      0,
      1.947668,
      0,
      0.509918,
      2,
      1,
      5.686199,
      NULL,
      3,
      7.049978,
      0,
      5.296012,
      3,
      NULL,
      6.474964,
      2.412708,
      3.893485,
      3,
      64,
      1,
      3.370384,
      54,
      NULL,
      23,
      69.071427,
      0,
      2.560954,
      2.884921,
      '21231',
      '01341',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.922221,
      NULL,
      61.079826,
      NULL,
      0.818096,
      1.749356,
      4,
      2.845571,
      5,
      3.637395,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.007393,
      2.695951,
      3,
      3,
      NULL,
      2,
      3,
      0.632948,
      3.735638,
      1,
      NULL,
      NULL,
      2,
      3.693847,
      3,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.591315,
      1.372859,
      0,
      1,
      NULL,
      1,
      8,
      4.841598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      3.829676,
      NULL,
      2.732866,
      NULL,
      3,
      0,
      2,
      3.356733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.345274,
      0,
      NULL,
      1,
      0.124294,
      0.427766,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.756357,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.636864,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.515835,
      NULL,
      NULL,
      0.153163,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.863913,
      NULL,
      NULL,
      0.369060,
      NULL,
      NULL,
      0.532633,
      NULL,
      NULL,
      0.549514,
      NULL,
      NULL,
      0.629954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920630,
      NULL,
      NULL,
      NULL,
      1,
      2.490096,
      2,
      0,
      NULL,
      NULL,
      4.307649,
      0,
      NULL,
      NULL,
      NULL,
      0.339070,
      2,
      0.332465,
      2,
      0.542912,
      NULL,
      1,
      NULL,
      NULL,
      4.498484,
      NULL,
      4.066111,
      0,
      1,
      3,
      2.431083,
      1.087116,
      2,
      2,
      0,
      0.306486,
      3,
      2,
      2.467597,
      NULL,
      9,
      6.896008,
      NULL,
      NULL,
      4,
      1.920318,
      1,
      4,
      1.978771,
      1,
      0.124353,
      1,
      1.375152,
      0.305147,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.918768,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.899703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131692,
      NULL,
      NULL,
      2,
      NULL,
      3.868266,
      0.328643,
      2.032144,
      1,
      0,
      NULL,
      7.972512,
      NULL,
      NULL,
      NULL,
      7,
      4.558454,
      NULL,
      NULL,
      0,
      2.141894,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.081601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.362016,
      0.674295,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.249756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.098221,
      NULL,
      NULL,
      1,
      0.385255,
      NULL,
      NULL,
      3,
      3.063681,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.339881,
      NULL,
      NULL,
      1.518884,
      NULL,
      NULL,
      NULL,
      5,
      3.315792,
      NULL,
      NULL,
      2.735125,
      0,
      0,
      5,
      0,
      0.966947,
      2.885529,
      3.668500,
      2.233290,
      11,
      NULL,
      1,
      12.750609,
      NULL,
      1.118644,
      12.986421,
      1,
      NULL,
      NULL,
      NULL,
      1.984270,
      NULL,
      NULL,
      0,
      NULL,
      1,
      491,
      1.945806,
      1.412528,
      1,
      0.654249,
      NULL,
      0.546117,
      0.084671,
      1.834855,
      1.749930,
      0.396933,
      1,
      0.401399,
      0,
      1,
      NULL,
      1.892974,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.788470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.592618,
      NULL,
      1.119313,
      NULL,
      3.244506,
      NULL,
      40,
      NULL,
      3,
      NULL,
      0.899325,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.471259,
      NULL,
      0,
      NULL,
      361,
      NULL,
      NULL,
      NULL,
      3.219599,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579891,
      NULL,
      NULL,
      3,
      NULL,
      2.348478,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.094225,
      NULL,
      0,
      NULL,
      3.178173,
      NULL,
      215,
      NULL,
      3,
      NULL,
      2,
      NULL,
      3.417765,
      0,
      NULL,
      NULL,
      30,
      0.065719,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      2.948500,
      0.141873,
      0,
      7.958906,
      3,
      2,
      0.216150,
      NULL,
      NULL,
      NULL,
      0.923049,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0.501599,
      NULL,
      1.659871,
      1.748731,
      NULL,
      0.195772,
      1,
      NULL,
      1.255276,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.187895,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006528,
      1,
      NULL,
      NULL,
      0,
      0.647701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.299567,
      NULL,
      NULL,
      NULL,
      1.048574,
      NULL,
      3,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      86.292385,
      NULL,
      4.832864,
      NULL,
      '33102',
      '21002',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


