set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9103077';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '4214232',
      0,
      1,
      6,
      2,
      '2230',
      1.842170,
      NULL,
      NULL,
      NULL,
      ' 0-14-1998',
      NULL,
      NULL,
      0,
      2,
      0.221063,
      NULL,
      27,
      3,
      209.471041,
      26,
      2,
      ' 7-10-1998',
      NULL,
      ' 4-12-1979',
      1,
      0.993066,
      1.569039,
      1,
      0,
      3,
      3,
      0.056157,
      0,
      91.618382,
      4,
      NULL,
      2.233284,
      4,
      14.066862,
      0,
      7.723375,
      2,
      0,
      0,
      1,
      0,
      1,
      0.325360,
      2,
      1,
      1.477445,
      0.057577,
      1.464979,
      2.046112,
      0.001635,
      3,
      2,
      4,
      2,
      0,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      1,
      NULL,
      0,
      3,
      5,
      3.228520,
      2,
      1,
      0,
      2,
      1.248483,
      NULL,
      NULL,
      1.501981,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.821275,
      NULL,
      1,
      1.212871,
      0,
      3,
      0.015067,
      0.803810,
      1.658711,
      1,
      2.968831,
      0.435565,
      0.054015,
      1,
      1,
      1,
      1,
      1,
      0,
      3,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.020791,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      3,
      4,
      5,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      2,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      2,
      NULL,
      2,
      4,
      5,
      5,
      2,
      NULL,
      4,
      4,
      9,
      NULL,
      ' 1-17-1986',
      236.121429,
      ' 2- 6-1979',
      235.911964,
      2.205297,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1.275605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1.194639,
      0,
      NULL,
      0.958538,
      7.220897,
      1,
      NULL,
      1.531747,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      4.963342,
      0,
      NULL,
      NULL,
      NULL,
      1,
      6.703888,
      1.666993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.135085,
      NULL,
      NULL,
      3.180046,
      1,
      NULL,
      100.406693,
      1.818687,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.274135,
      0.609331,
      0,
      0,
      1,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      2.127373,
      1,
      1,
      0.990997,
      NULL,
      1,
      0,
      0,
      0.469783,
      1.600014,
      1.767646,
      7,
      3.227042,
      NULL,
      NULL,
      NULL,
      1.397089,
      2.582885,
      6.493603,
      3,
      2.538407,
      3.183556,
      45,
      0,
      2.671451,
      NULL,
      NULL,
      NULL,
      69.302705,
      1,
      1.187827,
      4,
      NULL,
      '34012',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0,
      49,
      NULL,
      31.282359,
      1.518362,
      40,
      1,
      7.092194,
      3,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489827,
      NULL,
      NULL,
      1,
      0,
      3.421960,
      0.435178,
      2,
      1,
      NULL,
      3,
      0.837891,
      0,
      3.067346,
      1,
      3,
      2.894222,
      0.825722,
      0,
      3.855347,
      1.087034,
      0.714212,
      0.836237,
      4.091337,
      0,
      1.847237,
      NULL,
      NULL,
      NULL,
      0.929677,
      1,
      3,
      3.730400,
      NULL,
      0.695668,
      3,
      0.330185,
      NULL,
      NULL,
      0.562448,
      NULL,
      NULL,
      NULL,
      1.650757,
      3,
      3.487603,
      2,
      2,
      NULL,
      1.629831,
      0,
      1,
      1.357902,
      0.951858,
      0,
      0.975056,
      1.565639,
      0.885268,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.712353,
      3,
      2,
      NULL,
      0.714914,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      1,
      1.858901,
      0.223962,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.292629,
      NULL,
      0.990686,
      NULL,
      NULL,
      5,
      0,
      3,
      1.705618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.845992,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.283190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473125,
      NULL,
      NULL,
      1.646566,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.613397,
      5.506052,
      NULL,
      0,
      3.084457,
      1,
      1,
      2.916440,
      1,
      1.112140,
      2,
      2.853116,
      NULL,
      2.815081,
      7,
      0.512998,
      0,
      1.069717,
      3,
      2.190200,
      2,
      NULL,
      3,
      3.397115,
      3,
      2,
      2,
      0.350883,
      6.094723,
      1,
      4,
      3,
      NULL,
      0.040832,
      2,
      4,
      NULL,
      1.712395,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.154788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043910,
      NULL,
      NULL,
      0.519494,
      NULL,
      NULL,
      0.013927,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.280497,
      NULL,
      NULL,
      0.810095,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.202891,
      2,
      0.606345,
      3,
      0,
      0,
      NULL,
      4.328050,
      4,
      NULL,
      NULL,
      27,
      10.602469,
      NULL,
      NULL,
      2.105243,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.764503,
      0.956449,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.991118,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363826,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.118347,
      1.063454,
      NULL,
      NULL,
      1,
      0.644304,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.145373,
      7.559897,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.348522,
      2.242219,
      14.679765,
      0,
      1,
      NULL,
      NULL,
      NULL,
      7.526392,
      2.534844,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.856898,
      NULL,
      NULL,
      0,
      89.720914,
      18.983200,
      NULL,
      1,
      NULL,
      0,
      1,
      1.923219,
      1,
      0.051103,
      NULL,
      0,
      2,
      1.130578,
      NULL,
      0,
      1.239067,
      0.257032,
      0,
      NULL,
      0.144634,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.134238,
      NULL,
      14,
      NULL,
      0.939244,
      NULL,
      18,
      NULL,
      1,
      NULL,
      NULL,
      0.235330,
      NULL,
      1.782328,
      NULL,
      1.294435,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.085343,
      NULL,
      NULL,
      NULL,
      1.270857,
      NULL,
      1.066020,
      NULL,
      NULL,
      1.520644,
      0.285536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463572,
      1.608680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.680032,
      2,
      1,
      3,
      1.487169,
      NULL,
      NULL,
      NULL,
      1.662367,
      NULL,
      0.960326,
      NULL,
      1.438748,
      0.282871,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419195,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.323464,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.938385,
      NULL,
      1.727313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      4.673249,
      0.093517,
      NULL,
      4.539027,
      3,
      9.094395,
      2.035509,
      2,
      NULL,
      0.889556,
      NULL,
      NULL,
      NULL,
      1.419793,
      NULL,
      0.550655,
      NULL,
      NULL,
      0.716493,
      0,
      NULL,
      3.743896,
      1.207018,
      NULL,
      1,
      0,
      NULL,
      1.406627,
      0,
      NULL,
      0,
      0.811639,
      NULL,
      0.032300,
      1,
      NULL,
      1.799568,
      1.703787,
      NULL,
      1.488855,
      0,
      NULL,
      NULL,
      1,
      0.186562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      0.168093,
      NULL,
      33,
      31,
      1,
      0.930818,
      2,
      '13400',
      '43242',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


