set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9645393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      '14',
      31.768124,
      1.565483,
      NULL,
      0.612885,
      0,
      2,
      NULL,
      '4320',
      NULL,
      1,
      NULL,
      NULL,
      ' 9- 5-1987',
      NULL,
      57.192980,
      NULL,
      2,
      4,
      ' 5-25-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 4-16-1989',
      '10-21-1991',
      ' 4- 1-1983',
      1.521751,
      0,
      NULL,
      1.342537,
      1.409484,
      0,
      0,
      NULL,
      0,
      NULL,
      8,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.049802,
      NULL,
      1.527268,
      0.895593,
      NULL,
      NULL,
      1,
      2,
      3,
      5,
      0,
      NULL,
      1,
      5,
      2,
      0,
      1,
      4,
      2,
      1,
      0,
      1,
      NULL,
      3,
      0,
      0,
      1,
      1,
      0.363744,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.847967,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1.963320,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      4,
      3,
      0,
      3,
      5,
      NULL,
      0,
      NULL,
      3,
      ' 5-14-1975',
      43,
      ' 6- 0-1996',
      19,
      2.057930,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.181453,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      3.467953,
      1,
      0,
      1,
      1.445813,
      3.074451,
      1,
      NULL,
      4.403227,
      3,
      0,
      NULL,
      NULL,
      0.975403,
      NULL,
      1.419598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002162,
      1,
      1,
      0.183904,
      0.910620,
      NULL,
      0.120261,
      2,
      3.133327,
      2.492964,
      0.635100,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.967700,
      0,
      2,
      3,
      0,
      NULL,
      1,
      3,
      1,
      0,
      3,
      2,
      1,
      1,
      0.450524,
      2.336188,
      NULL,
      1,
      1.753141,
      1.500675,
      1,
      1.031603,
      0,
      1,
      1.669956,
      0,
      0,
      0.308827,
      0,
      0,
      7.057014,
      9.765012,
      6.884112,
      8,
      4.832700,
      4.298099,
      2,
      NULL,
      3.221971,
      2,
      NULL,
      3,
      41,
      3,
      0,
      13,
      NULL,
      57,
      37,
      3,
      NULL,
      1,
      '01420',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      '401',
      '3401',
      '',
      0.401874,
      2.600430,
      92,
      14,
      3,
      NULL,
      2,
      0.621046,
      1,
      1.027879,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.654198,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.050363,
      1,
      2.350116,
      2,
      1.071300,
      0.777433,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.334432,
      NULL,
      NULL,
      NULL,
      1,
      1.039813,
      1.488056,
      0,
      1.484869,
      NULL,
      0,
      0,
      NULL,
      0.316748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822577,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.447900,
      NULL,
      NULL,
      1.990591,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.572672,
      NULL,
      NULL,
      1.604224,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.481101,
      NULL,
      NULL,
      0.719638,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210759,
      NULL,
      NULL,
      3.400522,
      1,
      0.274694,
      0,
      NULL,
      0.965916,
      NULL,
      NULL,
      NULL,
      2.213462,
      1,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1.801891,
      2.658309,
      2,
      0,
      3.311499,
      NULL,
      2.790551,
      0.443920,
      1.035236,
      3,
      3.711015,
      0,
      1,
      3.868588,
      0,
      1.607413,
      1.787383,
      0.360192,
      2.945769,
      0.076276,
      NULL,
      2,
      3.733546,
      NULL,
      7,
      6,
      NULL,
      NULL,
      NULL,
      0.980330,
      3,
      1,
      NULL,
      0.900973,
      0.353020,
      NULL,
      0,
      0.922492,
      NULL,
      NULL,
      1.254635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.002278,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.473348,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428659,
      0.407128,
      NULL,
      NULL,
      0,
      3.393360,
      0.950705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735201,
      NULL,
      NULL,
      NULL,
      0.495135,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.068300,
      NULL,
      NULL,
      NULL,
      1.278819,
      NULL,
      NULL,
      NULL,
      1.246253,
      NULL,
      NULL,
      NULL,
      2.876760,
      NULL,
      NULL,
      NULL,
      2.996777,
      NULL,
      NULL,
      NULL,
      1.383386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.097568,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.003889,
      NULL,
      NULL,
      1.511219,
      NULL,
      0,
      373.422534,
      0,
      NULL,
      0.119299,
      0.127839,
      1,
      1.770460,
      0,
      0,
      1.637162,
      0.743579,
      0.317742,
      1,
      2,
      0.876159,
      0.084815,
      0,
      1,
      1,
      3.304211,
      NULL,
      NULL,
      NULL,
      0.287681,
      NULL,
      0,
      NULL,
      1.641512,
      NULL,
      0,
      NULL,
      38,
      NULL,
      1.017097,
      NULL,
      22.592209,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723177,
      NULL,
      3.026252,
      NULL,
      0,
      NULL,
      2.085909,
      NULL,
      0.970426,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.018239,
      NULL,
      0.653416,
      NULL,
      0.711681,
      NULL,
      0.361377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      2,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0,
      3.683632,
      2,
      1,
      2,
      3.015000,
      NULL,
      0,
      0.140182,
      NULL,
      0.015628,
      1,
      NULL,
      1.918518,
      0.995019,
      NULL,
      1.913177,
      0.935769,
      NULL,
      1.038480,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.633784,
      NULL,
      0,
      0.586302,
      NULL,
      0,
      2,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      1.111618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.273805,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.125445,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.136558,
      NULL,
      0.976670,
      NULL,
      2.447135,
      NULL,
      0,
      NULL,
      0,
      NULL,
      10.027665,
      0.625050,
      NULL,
      NULL,
      NULL,
      0.152447,
      NULL,
      0,
      NULL,
      2,
      1,
      7,
      1.641268,
      1,
      1.223029,
      37.464938,
      68,
      0,
      1.899993,
      5.947838,
      '24124',
      '01313',
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '');
commit;
end;
/


