set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9936906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2.722344,
      6.806316,
      2,
      2.053305,
      NULL,
      3,
      1,
      '111',
      '10044034',
      78,
      48.587423,
      '1043141',
      2.822552,
      1.623530,
      1,
      0,
      '0111',
      0.308527,
      0,
      NULL,
      NULL,
      NULL,
      121.311052,
      53.398615,
      NULL,
      3.943769,
      NULL,
      ' 0-13-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 5-27-1999',
      ' 8- 7-1996',
      1.411204,
      NULL,
      3,
      3.697495,
      0.116856,
      3,
      3,
      0,
      1,
      3.188253,
      6,
      1.966582,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      1.240668,
      1.338242,
      0.073979,
      2,
      4,
      3,
      1,
      0,
      0,
      5,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      1.050356,
      NULL,
      NULL,
      NULL,
      1,
      0.599112,
      0.448441,
      0.492511,
      0.251297,
      2,
      NULL,
      NULL,
      NULL,
      1.492560,
      NULL,
      1,
      2,
      0.794152,
      1.072164,
      0.703222,
      3,
      2.470661,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      0.802092,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      5,
      1,
      1,
      1,
      NULL,
      5,
      0,
      0,
      0,
      2.323550,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      2,
      4,
      0,
      2,
      NULL,
      NULL,
      5,
      5,
      2,
      4,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      0,
      0,
      1,
      1,
      0,
      NULL,
      ' 8- 8-1989',
      415.981418,
      ' 8-11-1983',
      198.722752,
      2.946503,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      4,
      1.125274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2,
      NULL,
      3,
      1.436931,
      0,
      2.922325,
      0.616151,
      NULL,
      5,
      1,
      NULL,
      1.689300,
      1,
      0,
      1.080510,
      NULL,
      7.325552,
      NULL,
      NULL,
      1.062509,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.453681,
      0.821989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719774,
      1.477182,
      0.494787,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.278460,
      0.717032,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.125234,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      0,
      2.713454,
      0,
      0,
      3.114045,
      0,
      0.835700,
      3.407369,
      1.513862,
      1,
      1,
      NULL,
      1,
      NULL,
      1.919178,
      1.366810,
      NULL,
      1,
      0.489201,
      1,
      11,
      NULL,
      6.232246,
      3.138546,
      NULL,
      NULL,
      3,
      3.822149,
      0.847965,
      1,
      2.272265,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      37,
      54,
      0,
      4.681256,
      1,
      '14112',
      '22443',
      NULL,
      0,
      '',
      '',
      '',
      1.749055,
      NULL,
      '',
      NULL,
      0,
      33,
      113,
      14.780229,
      2,
      5.679602,
      1,
      1.893967,
      NULL,
      0.384805,
      0.830846,
      2.483828,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364151,
      NULL,
      NULL,
      1.037724,
      1,
      1.353491,
      1.572016,
      NULL,
      NULL,
      0.347001,
      0.060340,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0.421809,
      7,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.777334,
      1.285290,
      0,
      1.452545,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.655580,
      NULL,
      0,
      3,
      NULL,
      2,
      1,
      NULL,
      1.264983,
      0.086242,
      1,
      0,
      NULL,
      2.588464,
      NULL,
      1.398420,
      1,
      NULL,
      NULL,
      0.592608,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530351,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      2,
      1,
      NULL,
      NULL,
      1.593713,
      NULL,
      NULL,
      3,
      1,
      0.233893,
      3,
      NULL,
      1.658797,
      NULL,
      NULL,
      NULL,
      6,
      1.284464,
      1,
      1.110429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545300,
      NULL,
      NULL,
      0.049565,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.488703,
      1.437529,
      1.534917,
      1.351698,
      NULL,
      NULL,
      3,
      0.456435,
      1,
      3,
      0,
      0,
      2,
      0.068131,
      0,
      1,
      0.271995,
      1,
      1,
      3,
      2,
      1.445026,
      1,
      1,
      7.400322,
      1,
      NULL,
      NULL,
      0.793018,
      0,
      NULL,
      3.018730,
      NULL,
      0.651014,
      NULL,
      NULL,
      0.565935,
      NULL,
      1.561886,
      5.935369,
      2,
      2.363169,
      0,
      NULL,
      NULL,
      1.104475,
      2,
      0,
      NULL,
      1,
      0,
      1,
      0.913003,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936148,
      NULL,
      NULL,
      1.461025,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.032895,
      NULL,
      NULL,
      NULL,
      0.405469,
      0.898992,
      NULL,
      1.454827,
      2,
      NULL,
      NULL,
      NULL,
      2.111182,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.493882,
      NULL,
      NULL,
      NULL,
      1.429455,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.842016,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.919639,
      NULL,
      NULL,
      NULL,
      0.596556,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.559723,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.990240,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      2,
      3.202705,
      NULL,
      13.647966,
      2.317113,
      1,
      NULL,
      NULL,
      1.168753,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.129800,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      9,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1.949606,
      0,
      1.953108,
      NULL,
      0.778874,
      NULL,
      1.810963,
      1,
      1,
      0.806122,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.114897,
      NULL,
      0.936274,
      NULL,
      6.931338,
      NULL,
      3,
      5.050691,
      42,
      NULL,
      1.303944,
      0.645874,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.372425,
      NULL,
      0.657025,
      NULL,
      0.402836,
      NULL,
      0,
      NULL,
      1.473639,
      NULL,
      1.284677,
      NULL,
      0.733823,
      NULL,
      1.636493,
      NULL,
      0.388036,
      NULL,
      1.235502,
      NULL,
      0.271887,
      1.480008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.199152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.407308,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.135263,
      1.227166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.970212,
      NULL,
      2.801154,
      NULL,
      686.251086,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.041152,
      NULL,
      0.443674,
      NULL,
      12,
      NULL,
      1,
      3.961599,
      NULL,
      5,
      1,
      1,
      NULL,
      NULL,
      1,
      3.593110,
      3.625218,
      3,
      2.749278,
      NULL,
      0.198758,
      NULL,
      1,
      1,
      NULL,
      0.573162,
      2.024314,
      NULL,
      0.538576,
      NULL,
      NULL,
      0.925357,
      0.224622,
      NULL,
      NULL,
      1.244315,
      NULL,
      NULL,
      1.358511,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.664250,
      NULL,
      NULL,
      0.288146,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900009,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      6,
      3,
      NULL,
      NULL,
      NULL,
      24,
      42,
      NULL,
      NULL,
      5.209530,
      '33014',
      '01203',
      '31220',
      1,
      '',
      '',
      NULL,
      0.505029,
      '',
      '',
      '');
commit;
end;
/


