set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9706710';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '12',
      NULL,
      43,
      '2302233',
      2,
      NULL,
      2,
      NULL,
      '1203',
      4,
      1,
      NULL,
      NULL,
      ' 4- 6-2001',
      67,
      0,
      NULL,
      NULL,
      0,
      ' 9-22-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '10-10-1994',
      ' 6-16-1974',
      0.586217,
      1.431138,
      2.022156,
      1,
      1,
      2.492971,
      0,
      0.754897,
      NULL,
      NULL,
      NULL,
      6.161033,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0.155323,
      0.385258,
      0,
      NULL,
      NULL,
      1.442311,
      0,
      NULL,
      4,
      3.065720,
      NULL,
      0,
      1,
      5,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      0,
      2,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      NULL,
      3,
      0.233504,
      1,
      NULL,
      2.686701,
      2.708055,
      0,
      1,
      0.163900,
      1.770119,
      0.673572,
      0,
      0,
      0.223417,
      1.979484,
      NULL,
      0,
      0,
      3,
      2.657674,
      NULL,
      NULL,
      3.705864,
      NULL,
      NULL,
      NULL,
      0.829456,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      5,
      2,
      4,
      1,
      2,
      1,
      3,
      NULL,
      NULL,
      0.088298,
      0,
      1,
      1,
      1,
      2.951493,
      1.954847,
      5.920798,
      1,
      3,
      1,
      0,
      NULL,
      5,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      5,
      NULL,
      2,
      0,
      1,
      4,
      1,
      1,
      5,
      3,
      1,
      3,
      2,
      2,
      ' 8-17-1996',
      596.617679,
      ' 8-27-1982',
      19.350311,
      0.166788,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      3,
      2,
      1.502742,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      7.044289,
      1.797960,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787245,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.358886,
      0.476640,
      0,
      0.387354,
      0,
      1,
      NULL,
      2.894981,
      59,
      3.114037,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      0,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      1.849365,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      3.690276,
      1.730741,
      1,
      NULL,
      1.599936,
      8,
      1.505077,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      63,
      NULL,
      41,
      68.696679,
      5,
      0,
      NULL,
      '13432',
      '34404',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2.195271,
      34.709631,
      85.333888,
      NULL,
      NULL,
      23.383572,
      NULL,
      4,
      5,
      3,
      3.056228,
      2.746102,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.702065,
      0,
      NULL,
      1.574019,
      NULL,
      1.247654,
      NULL,
      NULL,
      0.742312,
      NULL,
      NULL,
      1.857466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613725,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.367276,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.078286,
      0,
      1.036676,
      2,
      1.761521,
      1,
      NULL,
      0.655599,
      1,
      NULL,
      1.472369,
      NULL,
      1.218460,
      NULL,
      2.930612,
      0.810820,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.795831,
      NULL,
      1.637517,
      2,
      2.538899,
      2.162292,
      0,
      0.551108,
      NULL,
      NULL,
      NULL,
      0.983793,
      NULL,
      NULL,
      NULL,
      0.688420,
      NULL,
      NULL,
      2.664188,
      3,
      0.644169,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.533904,
      0,
      NULL,
      2.443271,
      2.011063,
      NULL,
      0.639891,
      NULL,
      NULL,
      2,
      1.155267,
      5.603428,
      1.074863,
      NULL,
      NULL,
      1.934033,
      NULL,
      NULL,
      1.738192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.910310,
      2,
      NULL,
      NULL,
      0.582537,
      1.598145,
      NULL,
      NULL,
      3.163653,
      2,
      0.459783,
      NULL,
      4.799155,
      2.428344,
      NULL,
      1.549926,
      NULL,
      2.684811,
      NULL,
      2,
      1,
      3,
      NULL,
      0.031350,
      NULL,
      NULL,
      0.919793,
      NULL,
      NULL,
      8.025471,
      5,
      5,
      2.495171,
      2,
      1,
      0,
      NULL,
      3.800577,
      1.911883,
      0,
      NULL,
      NULL,
      NULL,
      0.376800,
      NULL,
      3.005949,
      5.369094,
      5,
      0.711099,
      1.146114,
      NULL,
      4,
      1,
      0,
      1.893463,
      NULL,
      0.204475,
      1.507023,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      8.637310,
      NULL,
      NULL,
      0.864368,
      NULL,
      NULL,
      0.641675,
      NULL,
      NULL,
      0.160973,
      NULL,
      NULL,
      3.998579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685373,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.783190,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.130823,
      NULL,
      NULL,
      0.743419,
      1.001564,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.553299,
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.761265,
      NULL,
      NULL,
      NULL,
      1.360779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.147739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.029841,
      NULL,
      NULL,
      NULL,
      1.814397,
      NULL,
      NULL,
      NULL,
      3.714806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616771,
      16.484243,
      NULL,
      NULL,
      32.796730,
      2,
      NULL,
      NULL,
      NULL,
      2.587575,
      4.776608,
      NULL,
      0.739778,
      NULL,
      NULL,
      0.418315,
      NULL,
      NULL,
      0.595400,
      NULL,
      NULL,
      960.194033,
      14,
      0.508222,
      1.119718,
      1,
      0,
      1.744732,
      0.988425,
      0.401420,
      NULL,
      0.526968,
      2.889374,
      0,
      1.256650,
      1.493915,
      1,
      0,
      0.665376,
      0.663581,
      3,
      NULL,
      0.821226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3.544628,
      NULL,
      6,
      0.103302,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.056949,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.858541,
      NULL,
      1.183328,
      NULL,
      0,
      NULL,
      1.078995,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      NULL,
      0,
      1.402112,
      2.825438,
      0,
      11,
      3.209595,
      NULL,
      1.788723,
      NULL,
      1,
      NULL,
      0,
      1.551096,
      NULL,
      1,
      NULL,
      NULL,
      1.024792,
      0.016553,
      NULL,
      0.610326,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.780487,
      NULL,
      1.472071,
      1.079144,
      NULL,
      1.705049,
      0.967863,
      NULL,
      3.889679,
      1,
      NULL,
      1.402221,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.916679,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      2.843736,
      6.800479,
      27.195198,
      5,
      1.352315,
      1,
      '33020',
      '32012',
      '',
      0,
      '',
      '',
      '',
      1.925238,
      '',
      '',
      NULL);
commit;
end;
/


