set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '4440133',
      0.391392,
      1,
      3,
      NULL,
      '2422',
      2.788967,
      0.283843,
      NULL,
      NULL,
      ' 6- 8-1975',
      NULL,
      NULL,
      2,
      1.284483,
      0.861647,
      ' 3-21-1993',
      18.782002,
      2,
      186.560245,
      32.393944,
      2,
      NULL,
      ' 9- 0-1980',
      ' 9-21-2002',
      0.798170,
      NULL,
      1.050894,
      0,
      1,
      1.397705,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      5.398902,
      3.866112,
      2,
      NULL,
      5,
      3,
      8,
      1.250419,
      3,
      0,
      1.586159,
      0.578656,
      0.909734,
      0.797033,
      3.128562,
      5.210620,
      1.702316,
      0.461245,
      NULL,
      NULL,
      0,
      1.683992,
      4,
      NULL,
      NULL,
      4,
      1,
      3,
      1,
      2,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      0.276219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.178938,
      NULL,
      1.371985,
      1.120571,
      1.030937,
      NULL,
      1.268041,
      2,
      1,
      3,
      3.368278,
      1.017426,
      0.945760,
      NULL,
      0.871479,
      1,
      5,
      NULL,
      4,
      NULL,
      0,
      1,
      0.604309,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      2,
      NULL,
      1,
      5,
      0,
      3,
      3,
      1,
      4,
      0,
      NULL,
      NULL,
      0,
      0.336614,
      NULL,
      NULL,
      5,
      1,
      4,
      1,
      0,
      4,
      5,
      0,
      0,
      2,
      0,
      1,
      0,
      0,
      1,
      2,
      2,
      2,
      0,
      0,
      5,
      5,
      2,
      2,
      0,
      5,
      1.011798,
      ' 6- 9-1997',
      NULL,
      '10- 0-1997',
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      5,
      2,
      0.668107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.265939,
      0,
      1,
      NULL,
      5.189762,
      2,
      1,
      NULL,
      NULL,
      1.009345,
      0.872909,
      6,
      0,
      0.557767,
      0.658183,
      0,
      NULL,
      0.326294,
      NULL,
      NULL,
      NULL,
      1.658917,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.737153,
      1.812477,
      1,
      NULL,
      NULL,
      0.237184,
      0,
      NULL,
      68,
      2.980367,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.037602,
      3,
      3,
      NULL,
      0,
      0,
      1,
      3,
      NULL,
      1,
      2,
      2,
      3.960274,
      3.623998,
      2,
      5,
      0,
      0.572505,
      0,
      0,
      1,
      0.434850,
      1,
      0.363519,
      0.328245,
      1,
      0,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      12,
      NULL,
      4,
      1.918746,
      0.739555,
      '33123',
      '',
      '',
      0,
      '',
      '',
      '',
      1.259111,
      '',
      '',
      '',
      1.375023,
      4,
      42,
      5.994474,
      0.940909,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.744087,
      NULL,
      NULL,
      NULL,
      1.991733,
      NULL,
      NULL,
      NULL,
      2.192905,
      0,
      3.803813,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.262399,
      2,
      2.755401,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.860160,
      19.202351,
      NULL,
      NULL,
      6,
      7.560460,
      9.811507,
      1,
      1.079910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.085545,
      1,
      0,
      NULL,
      NULL,
      0.897461,
      NULL,
      NULL,
      2,
      2.140810,
      0.501439,
      0,
      NULL,
      1,
      0,
      1.272232,
      1.247446,
      2,
      2,
      3,
      0.611580,
      1,
      1,
      1.980445,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      9,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.100622,
      NULL,
      NULL,
      NULL,
      0.747456,
      NULL,
      NULL,
      NULL,
      2.687585,
      0.366958,
      3,
      0,
      0,
      NULL,
      0.536515,
      0.813814,
      9,
      2.377222,
      6,
      1,
      0.677210,
      3,
      3.274421,
      2.351028,
      NULL,
      7,
      4,
      0.637951,
      1.743176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599027,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.550643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.573007,
      2.031022,
      5,
      6,
      2.898806,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.358024,
      0.892310,
      NULL,
      2,
      2.792898,
      1,
      NULL,
      1.180533,
      1,
      1,
      NULL,
      NULL,
      1.516733,
      3.170167,
      0.238196,
      1.501051,
      2.592222,
      0.235127,
      3,
      NULL,
      1,
      5,
      6,
      NULL,
      4,
      0,
      7,
      3.883402,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.693871,
      NULL,
      NULL,
      1.657306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.411201,
      NULL,
      NULL,
      2.134158,
      NULL,
      NULL,
      0.416989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891527,
      NULL,
      NULL,
      1.700837,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.273677,
      NULL,
      0.718155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717687,
      NULL,
      NULL,
      NULL,
      0.748660,
      NULL,
      NULL,
      NULL,
      0.023853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.574739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.125757,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.243666,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.562554,
      36.468836,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.027266,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.090801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.485545,
      0,
      1.606839,
      0,
      0,
      0,
      NULL,
      NULL,
      0.314289,
      1,
      1,
      1.099517,
      0.611645,
      1,
      0.990385,
      0,
      0.726978,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      NULL,
      0,
      0.934693,
      0.089416,
      2,
      8,
      0.256190,
      0,
      0.968026,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.666089,
      NULL,
      1.423883,
      0,
      NULL,
      1,
      0.941350,
      NULL,
      1.255085,
      0,
      NULL,
      1,
      2.040264,
      NULL,
      0.069332,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.811940,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646212,
      NULL,
      0.596972,
      NULL,
      4,
      3,
      5,
      NULL,
      0,
      0.531254,
      26.474354,
      63.316138,
      5,
      0,
      3,
      '24344',
      '',
      '',
      0.236291,
      '',
      '',
      '',
      1.746196,
      '',
      NULL,
      '');
commit;
end;
/


