set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '1333002',
      0,
      0,
      3,
      NULL,
      '3321',
      3,
      1.552542,
      NULL,
      NULL,
      ' 9-16-1985',
      57.837391,
      NULL,
      4,
      0.609819,
      NULL,
      '10- 5-2002',
      24.290207,
      NULL,
      47.420992,
      161.454144,
      2,
      NULL,
      '10-17-1995',
      ' 4- 4-1980',
      NULL,
      3.156296,
      2.370381,
      0.142732,
      0.376275,
      1,
      0,
      1,
      1,
      28.725494,
      6,
      NULL,
      4.697602,
      68,
      30,
      0,
      8.030665,
      3,
      1,
      5,
      0.639418,
      NULL,
      NULL,
      0,
      0,
      0.133220,
      1.616261,
      9.155543,
      NULL,
      0.959694,
      0.834484,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      5,
      3,
      5,
      2,
      1,
      4,
      2,
      2,
      3,
      1,
      0,
      0,
      2,
      0.870251,
      NULL,
      NULL,
      1.709615,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      2,
      2.071646,
      1.573204,
      1.685996,
      0,
      3,
      0.228450,
      1.555294,
      NULL,
      1.030226,
      0,
      2,
      3.939813,
      3.857998,
      2,
      3,
      3,
      4,
      9.659385,
      NULL,
      0,
      2.934111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      5,
      4,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      3,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      4,
      0,
      0,
      4,
      NULL,
      5,
      1,
      0.757165,
      ' 8-18-1992',
      194,
      NULL,
      307,
      1.656805,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      2.975100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952405,
      0,
      2,
      2,
      1.254006,
      1.568185,
      5.888419,
      1.582351,
      1.577087,
      7.261621,
      0.104838,
      NULL,
      NULL,
      NULL,
      NULL,
      7.805873,
      1.858075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.932195,
      0.450241,
      1,
      2,
      0.138026,
      1,
      0,
      1,
      6,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.584369,
      0,
      0,
      0,
      NULL,
      3,
      0,
      0,
      NULL,
      0,
      3,
      0,
      0,
      1,
      6,
      0.870353,
      NULL,
      NULL,
      1,
      1,
      1.813569,
      0,
      1,
      1,
      NULL,
      0.395527,
      NULL,
      1.730108,
      2,
      0,
      2,
      6,
      3,
      0.963211,
      5.590742,
      1.344579,
      4,
      NULL,
      3,
      3.813817,
      3,
      3.937861,
      34,
      1,
      1.274134,
      NULL,
      NULL,
      NULL,
      19,
      3,
      0.300257,
      3.475227,
      '02343',
      '',
      '',
      1.293132,
      '',
      '',
      '',
      0.964447,
      NULL,
      '',
      NULL,
      0,
      17.512033,
      67,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.134840,
      0.867739,
      NULL,
      NULL,
      0.375406,
      NULL,
      NULL,
      3.580232,
      2.542518,
      3,
      1,
      NULL,
      1,
      1.600244,
      NULL,
      3.585998,
      3,
      NULL,
      3,
      NULL,
      3.865766,
      0,
      0,
      3.758639,
      0.589824,
      0.068305,
      2,
      1.254735,
      2,
      0.269167,
      1.073586,
      2,
      1.252324,
      NULL,
      0,
      7.590469,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.560111,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      3.674161,
      NULL,
      2,
      0.391611,
      1.493690,
      3,
      2.868803,
      0,
      0,
      0,
      2.383103,
      NULL,
      3.518252,
      2,
      0,
      0.913289,
      3,
      0,
      NULL,
      NULL,
      1.661824,
      2.851218,
      0.176515,
      4,
      8.532304,
      4.232546,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.709310,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.851695,
      0.434162,
      1,
      2.970461,
      3,
      NULL,
      0,
      1,
      0,
      1.908820,
      NULL,
      0,
      1.362025,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.373031,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.539349,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.455145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332445,
      NULL,
      1.063102,
      0,
      0.907450,
      0,
      NULL,
      5.144943,
      1.403802,
      2.774732,
      4,
      3.724398,
      6,
      2,
      1.567714,
      0.843670,
      NULL,
      NULL,
      0.720015,
      NULL,
      2.495671,
      1.537756,
      NULL,
      NULL,
      8,
      9,
      8.025966,
      1,
      0.027754,
      1.116610,
      3,
      NULL,
      1.067042,
      1,
      1,
      1.225129,
      1,
      1,
      3,
      NULL,
      9,
      NULL,
      4,
      NULL,
      3.432280,
      1,
      2,
      1,
      0.750917,
      1.145961,
      0.824231,
      0,
      1.476158,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.224020,
      NULL,
      NULL,
      1.597281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.005128,
      NULL,
      NULL,
      1,
      0,
      1,
      1.628226,
      1,
      3,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.919928,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.581165,
      NULL,
      NULL,
      NULL,
      0.944980,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735755,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.882125,
      62.443912,
      37.943866,
      2,
      1,
      0.036096,
      0.877050,
      NULL,
      NULL,
      1,
      0.830056,
      0.363438,
      1.879775,
      NULL,
      NULL,
      1.271543,
      NULL,
      NULL,
      0.568004,
      NULL,
      NULL,
      46.186041,
      NULL,
      0,
      NULL,
      0,
      0,
      1.714965,
      NULL,
      0.035297,
      0.888157,
      0.476066,
      1,
      0,
      1.332950,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3,
      4,
      NULL,
      0,
      NULL,
      3.054620,
      0.346376,
      NULL,
      0.157917,
      1,
      NULL,
      0.354604,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.102783,
      1.979454,
      NULL,
      0,
      0.275008,
      NULL,
      NULL,
      0,
      NULL,
      1.222975,
      1,
      NULL,
      0.942761,
      0,
      NULL,
      0.792012,
      0,
      NULL,
      0,
      1.103237,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0.733816,
      1,
      3,
      15.044109,
      30.229524,
      1,
      NULL,
      NULL,
      '41411',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


