set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '2423401',
      NULL,
      0.043570,
      4,
      1,
      '2134',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-16-1986',
      NULL,
      NULL,
      NULL,
      3.136568,
      1.499335,
      ' 1- 8-1993',
      NULL,
      2.161275,
      NULL,
      33,
      2,
      '10- 6-1980',
      ' 0- 9-1987',
      ' 0- 9-1984',
      2.863386,
      1.597279,
      NULL,
      0.666545,
      NULL,
      2,
      NULL,
      0.313246,
      1.699164,
      1,
      4,
      2.541652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0,
      3,
      0,
      NULL,
      1.798041,
      0,
      1.790543,
      11,
      7.048857,
      1,
      0.937527,
      1,
      1,
      0,
      0,
      4,
      1,
      NULL,
      2,
      NULL,
      4,
      NULL,
      0,
      0,
      3,
      2,
      1,
      4,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2,
      NULL,
      3.424943,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.000478,
      2.285979,
      1,
      1.070776,
      3,
      1,
      0,
      1,
      2.324513,
      5,
      2,
      NULL,
      6,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      4,
      3,
      2,
      NULL,
      2,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1.714799,
      5,
      2,
      1,
      0,
      1,
      0,
      5,
      1,
      0,
      5,
      0,
      0,
      NULL,
      5,
      1,
      5,
      1,
      NULL,
      NULL,
      4,
      3,
      1,
      5,
      3,
      1,
      7.869533,
      NULL,
      NULL,
      18.670895,
      NULL,
      193,
      3,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      5,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.267109,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      0.649560,
      2,
      0,
      0.291123,
      3.850221,
      1.750913,
      6.342268,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.259365,
      1.404634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.017946,
      0.710408,
      1,
      1.401568,
      NULL,
      0.397928,
      3.399691,
      NULL,
      2.461131,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      1,
      3,
      0,
      NULL,
      3,
      3,
      3,
      1,
      2,
      0,
      2.153724,
      NULL,
      1.681728,
      0,
      1.610959,
      2.081968,
      NULL,
      0,
      0.526732,
      1,
      NULL,
      0.567084,
      0,
      0,
      NULL,
      1,
      2,
      0.948395,
      1.369989,
      NULL,
      3.099491,
      0,
      5,
      0.787680,
      5,
      0,
      0,
      0,
      NULL,
      3,
      39,
      NULL,
      0,
      NULL,
      25,
      1,
      38.900993,
      2,
      1,
      0,
      '42212',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      15,
      19.481729,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.481200,
      0,
      NULL,
      NULL,
      1.054754,
      NULL,
      NULL,
      1.727902,
      0.977051,
      NULL,
      1,
      1,
      0,
      NULL,
      2.551005,
      1,
      NULL,
      3.483715,
      2,
      0,
      NULL,
      NULL,
      1.058564,
      3.651657,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.740385,
      NULL,
      0,
      NULL,
      NULL,
      10.628147,
      0,
      5.839408,
      1,
      0.391122,
      NULL,
      NULL,
      NULL,
      1.506620,
      NULL,
      NULL,
      NULL,
      3.467928,
      2,
      1.458046,
      0.857119,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.102236,
      0.801614,
      NULL,
      1.119104,
      3.392429,
      3,
      1,
      3.582579,
      NULL,
      1.597496,
      1.239444,
      2,
      NULL,
      2.500112,
      2.548312,
      2,
      0,
      1,
      2.064077,
      1.720186,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.261098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342024,
      1,
      NULL,
      0,
      3,
      0.893231,
      1.604763,
      NULL,
      0,
      4.149620,
      2.123364,
      NULL,
      NULL,
      1,
      3.612630,
      0.941786,
      0,
      2.928516,
      3.353662,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368299,
      NULL,
      NULL,
      0.150234,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.145671,
      0,
      1.435945,
      2,
      0.942161,
      2.691894,
      9,
      4,
      NULL,
      3.602889,
      0,
      5.824229,
      4.073607,
      2,
      0.713152,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0.338662,
      8,
      6,
      2.529312,
      0,
      2.430448,
      3,
      3,
      3,
      NULL,
      0,
      3.773833,
      3,
      NULL,
      2.850549,
      1,
      6,
      0,
      4,
      0,
      6.977598,
      NULL,
      3,
      3,
      0,
      1,
      0.749736,
      1,
      0,
      2.697990,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940690,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.648228,
      NULL,
      NULL,
      0.978454,
      1.108891,
      NULL,
      NULL,
      1,
      NULL,
      1.536328,
      NULL,
      NULL,
      1.795047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.373626,
      NULL,
      NULL,
      NULL,
      2.756627,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      2.292289,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.397045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0.250525,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      0,
      0.343981,
      1.488952,
      0,
      NULL,
      NULL,
      2,
      0,
      0.098147,
      1.201433,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.647859,
      NULL,
      0,
      NULL,
      0.844298,
      1.841191,
      NULL,
      0,
      NULL,
      0.015698,
      0,
      0.480113,
      0,
      0,
      1,
      1.918658,
      NULL,
      NULL,
      0,
      0.631934,
      0.390003,
      0,
      0.567866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      9.088551,
      NULL,
      7.787274,
      2.566747,
      3,
      NULL,
      3,
      2,
      0,
      1.487015,
      0.677741,
      NULL,
      0,
      2,
      NULL,
      1.010202,
      2.504404,
      NULL,
      1,
      0.250118,
      NULL,
      0,
      0,
      NULL,
      0,
      3,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.958880,
      1,
      NULL,
      1,
      0.349822,
      NULL,
      2,
      1,
      1.946624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.245825,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      5,
      NULL,
      1.179521,
      3,
      67,
      86.212293,
      4,
      1.795118,
      0.106753,
      '31034',
      '',
      NULL,
      0.915147,
      NULL,
      '',
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


