set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7224559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0214330',
      NULL,
      0,
      4,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      ' 0-19-1980',
      13.009476,
      NULL,
      0,
      NULL,
      0,
      ' 1-11-1976',
      1.082869,
      1,
      104,
      NULL,
      0,
      NULL,
      ' 8- 4-1982',
      NULL,
      1.827377,
      1.620522,
      1,
      2,
      1,
      0,
      1,
      0,
      0,
      7,
      NULL,
      0.319123,
      1.297493,
      7.536370,
      23.263384,
      2,
      NULL,
      3,
      3,
      3.901987,
      1.739252,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.218069,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      3.262294,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1.745105,
      0,
      0,
      1.259597,
      0,
      1,
      2,
      NULL,
      3,
      NULL,
      1.260297,
      0,
      0.898215,
      2,
      0,
      4,
      1,
      1,
      0,
      0,
      0.666023,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      NULL,
      0,
      3,
      2,
      1,
      0,
      3,
      2,
      0,
      4,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      2.610308,
      NULL,
      0,
      3,
      4,
      1,
      1,
      1,
      3,
      0,
      4,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      5,
      1,
      5,
      3,
      NULL,
      0,
      NULL,
      4,
      NULL,
      3.966864,
      0.069517,
      ' 1-20-1982',
      76.213451,
      ' 5-13-1989',
      293,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      0.384950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.385604,
      1,
      2,
      1.903312,
      2,
      1,
      1,
      NULL,
      5,
      1,
      0.759424,
      1.152060,
      NULL,
      3.145338,
      8,
      0,
      6,
      3.082890,
      4.953576,
      2.594846,
      0,
      0.404050,
      NULL,
      NULL,
      0,
      7.456864,
      0.153691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.222558,
      NULL,
      1.730110,
      3.643827,
      NULL,
      1,
      3.016411,
      NULL,
      3,
      1,
      NULL,
      11,
      2.093727,
      1,
      1,
      1,
      3,
      NULL,
      1,
      0,
      3,
      3,
      0,
      1,
      1,
      3,
      2,
      NULL,
      1,
      0.340736,
      NULL,
      0.951393,
      1,
      0,
      1,
      NULL,
      1.080885,
      0,
      0.219432,
      0,
      0.848365,
      1,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      74,
      47,
      2.532465,
      3,
      1.050705,
      2,
      '32120',
      '',
      '',
      1.791130,
      '',
      NULL,
      NULL,
      0.439653,
      '21233',
      '',
      '',
      2.272036,
      18.716399,
      71.359451,
      7.251993,
      NULL,
      NULL,
      4.699074,
      13,
      0,
      2.568566,
      1,
      0.029379,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.422987,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.244951,
      NULL,
      NULL,
      1.797146,
      NULL,
      NULL,
      0.912646,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.409425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.888593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.252993,
      NULL,
      NULL,
      1.881072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      0.505658,
      NULL,
      NULL,
      6.571859,
      NULL,
      4.995647,
      NULL,
      NULL,
      2.905777,
      NULL,
      NULL,
      NULL,
      6.842812,
      3.024187,
      5,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.912897,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9.056303,
      5,
      1.878138,
      1.704804,
      2,
      3.905615,
      0,
      3.035785,
      0,
      2,
      1.877631,
      2.925629,
      NULL,
      2,
      4.433592,
      NULL,
      NULL,
      2,
      1.107510,
      NULL,
      NULL,
      2,
      NULL,
      0.584662,
      3.300102,
      1.298032,
      0.609240,
      NULL,
      8.489930,
      5,
      NULL,
      6.215020,
      NULL,
      3.115671,
      0,
      NULL,
      1.703419,
      1,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392580,
      NULL,
      NULL,
      1.735368,
      NULL,
      NULL,
      1.330399,
      NULL,
      NULL,
      0.783411,
      NULL,
      NULL,
      0.703768,
      NULL,
      NULL,
      1.230664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.172291,
      NULL,
      NULL,
      0.724630,
      1.716387,
      1,
      0.795960,
      1,
      1.129033,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.934478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.814144,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.047399,
      NULL,
      NULL,
      NULL,
      3,
      1.156097,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.701703,
      NULL,
      NULL,
      328,
      1.748048,
      0.158456,
      0,
      1,
      NULL,
      1.945964,
      1,
      0,
      0.521653,
      0.687313,
      1,
      1,
      1.759005,
      NULL,
      NULL,
      0.982978,
      1.775230,
      0,
      1.353320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      4,
      3.322340,
      5.387051,
      0,
      NULL,
      11.084389,
      2,
      2.554773,
      1,
      0.278022,
      1.389877,
      NULL,
      0.756342,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.269311,
      1.872955,
      NULL,
      NULL,
      0.210312,
      NULL,
      3.146521,
      3,
      NULL,
      0.331468,
      1,
      NULL,
      2.260202,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.005283,
      1,
      NULL,
      NULL,
      1.769227,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      60.968410,
      2,
      1.509945,
      NULL,
      '40014',
      '',
      '',
      1.086222,
      '',
      '',
      '',
      2.585028,
      '24423',
      '',
      NULL);
commit;
end;
/


