set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7224559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      1.253830,
      0,
      1,
      NULL,
      '3314',
      2.745244,
      0,
      NULL,
      NULL,
      ' 6-14-2003',
      0.014373,
      NULL,
      NULL,
      3,
      0.151444,
      '11-26-1994',
      NULL,
      0,
      289,
      124,
      2,
      NULL,
      ' 0-21-1999',
      NULL,
      1.797049,
      2.142727,
      0,
      0.156067,
      NULL,
      1.054136,
      0,
      3.469030,
      NULL,
      NULL,
      NULL,
      NULL,
      2.554762,
      2.441281,
      20,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.935833,
      0.554855,
      2,
      0.407462,
      0,
      1.231837,
      1,
      0,
      NULL,
      3.803001,
      1,
      0,
      1,
      NULL,
      1,
      0,
      2,
      0,
      1,
      0,
      0,
      1,
      4.741143,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.789975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      5,
      5,
      2,
      4,
      0,
      1,
      4,
      0,
      0,
      1.743763,
      1,
      0,
      0,
      0,
      1.594365,
      2.754536,
      8.294415,
      NULL,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      4,
      2,
      2,
      1,
      5,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      4,
      NULL,
      3,
      '10-28-1974',
      124,
      ' 5-26-1974',
      95.689680,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0.739159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.138515,
      1,
      NULL,
      7,
      NULL,
      7,
      1.931328,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.120583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.006049,
      1.531980,
      2,
      0,
      0,
      NULL,
      0.869642,
      156.949471,
      NULL,
      3.497532,
      35.175379,
      NULL,
      57.702628,
      0,
      0.263459,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      1,
      NULL,
      0,
      2,
      2,
      0.946765,
      0.738780,
      0.187898,
      1,
      3.511690,
      1.347888,
      NULL,
      1,
      1,
      NULL,
      1,
      0.316072,
      0.604355,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      6.878982,
      NULL,
      NULL,
      7,
      2,
      5,
      5,
      0,
      NULL,
      2.614557,
      0.715283,
      1,
      54.773476,
      1,
      0.520711,
      NULL,
      60,
      32,
      73,
      NULL,
      0.660332,
      2.351183,
      '14242',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      '33233',
      '',
      '',
      NULL,
      NULL,
      50.641180,
      6.752521,
      2,
      0.900492,
      NULL,
      1.214368,
      3,
      1.588312,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.189266,
      1.074277,
      1,
      NULL,
      NULL,
      0.081310,
      NULL,
      NULL,
      1.938624,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.599560,
      NULL,
      NULL,
      0.122357,
      NULL,
      NULL,
      0.782911,
      NULL,
      NULL,
      1.352498,
      NULL,
      NULL,
      0.116403,
      0,
      NULL,
      0,
      1.814724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684489,
      NULL,
      NULL,
      0.701242,
      NULL,
      NULL,
      1.383116,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248935,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449693,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.664661,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7.240926,
      4.626427,
      1.216337,
      0.315398,
      0.543910,
      1.932655,
      0.284158,
      1,
      5,
      6,
      0.368628,
      0,
      NULL,
      NULL,
      1.116506,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.605936,
      5,
      0.590249,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.673822,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391291,
      0.068709,
      NULL,
      NULL,
      0.331056,
      2,
      NULL,
      0.302072,
      NULL,
      NULL,
      NULL,
      0.788597,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.060925,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      NULL,
      1.814758,
      1,
      2.050570,
      5.674110,
      1.979117,
      2,
      3,
      1,
      0.578819,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      0.785871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.232675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941379,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.447035,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.700071,
      NULL,
      NULL,
      1.984055,
      0,
      0.320401,
      0,
      0.198787,
      3.130663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.106493,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112510,
      NULL,
      NULL,
      NULL,
      0.985326,
      NULL,
      NULL,
      NULL,
      1.290324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.556964,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.949291,
      NULL,
      NULL,
      NULL,
      3.224130,
      43.482569,
      NULL,
      1.316617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.405112,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.427856,
      196.587513,
      NULL,
      1.875670,
      1,
      1,
      1.257137,
      1,
      1,
      0,
      0.015662,
      1.197230,
      0.743801,
      1,
      0.885613,
      0.735713,
      0,
      NULL,
      0.734074,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.471205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067231,
      2.836189,
      NULL,
      0,
      NULL,
      0.195772,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.958298,
      NULL,
      1.861241,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.225181,
      NULL,
      5.097265,
      0.360159,
      0,
      NULL,
      2,
      0,
      0.525954,
      1.059094,
      1.287873,
      NULL,
      1.717167,
      3,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.713223,
      NULL,
      3.856801,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.335031,
      NULL,
      0.605169,
      NULL,
      NULL,
      1.494261,
      0.732973,
      NULL,
      0.607919,
      2.061159,
      NULL,
      1.757786,
      0.407576,
      NULL,
      3.272168,
      1,
      0.335339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.037925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.487503,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      7,
      2.360887,
      0,
      3.241034,
      44.904188,
      80,
      1,
      0.862616,
      0.444270,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '23003',
      '',
      '');
commit;
end;
/


