set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7224559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '2202321',
      2,
      NULL,
      NULL,
      3,
      '1204',
      0.120025,
      1,
      NULL,
      NULL,
      ' 6-16-1991',
      10.291503,
      NULL,
      1,
      1.691521,
      0,
      ' 1-25-1993',
      24.694143,
      NULL,
      244.510820,
      85,
      3,
      ' 4- 3-2002',
      ' 9- 5-1993',
      NULL,
      0.246979,
      2.554645,
      1,
      3,
      1,
      3,
      2,
      0,
      1,
      6,
      NULL,
      13.411500,
      1.374986,
      28,
      23.875207,
      4,
      17.619841,
      2,
      3,
      5,
      1,
      0,
      1,
      0.888395,
      NULL,
      0.781914,
      1,
      NULL,
      1.315169,
      1.531281,
      1.250550,
      0,
      2,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      5,
      5,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.603430,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.726867,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      2,
      2,
      NULL,
      1,
      5,
      0,
      4,
      5,
      3,
      1,
      0,
      9.743354,
      0,
      NULL,
      1,
      1,
      NULL,
      1.810930,
      7.751083,
      5,
      2,
      1,
      1,
      0,
      1,
      3,
      1,
      0,
      NULL,
      0,
      5,
      1,
      0,
      3,
      4,
      NULL,
      5,
      0,
      3,
      2,
      4,
      1,
      0,
      1,
      6.761643,
      1,
      ' 7- 3-1997',
      56.976319,
      ' 2-18-1976',
      153,
      2.354325,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      2,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.426808,
      2.997974,
      1.403137,
      0.804094,
      10.551667,
      NULL,
      NULL,
      2.364395,
      NULL,
      0.826464,
      2,
      1,
      1,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578311,
      NULL,
      0.820576,
      1,
      2,
      1,
      NULL,
      NULL,
      46.539882,
      NULL,
      1.757497,
      3.937177,
      NULL,
      24,
      NULL,
      0.493724,
      1.529233,
      NULL,
      1,
      2,
      1,
      3,
      NULL,
      2,
      2,
      3,
      3,
      1.460099,
      NULL,
      1.796548,
      1,
      2.622120,
      1,
      0,
      0,
      1.095836,
      1.122591,
      1.374635,
      1,
      1.783232,
      NULL,
      1.562953,
      0,
      1.947529,
      2.668918,
      0,
      7.210403,
      3,
      6.157306,
      3,
      10.810589,
      NULL,
      1.722634,
      NULL,
      6,
      3.011211,
      NULL,
      0,
      32,
      2,
      NULL,
      NULL,
      2,
      12,
      NULL,
      NULL,
      1.723837,
      NULL,
      '20314',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '02340',
      NULL,
      '',
      NULL,
      NULL,
      69,
      20,
      NULL,
      2.426737,
      4.097545,
      1.936303,
      4,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      1.248369,
      NULL,
      NULL,
      1.466458,
      0,
      1.837035,
      0.538041,
      0.337213,
      0,
      1.771260,
      NULL,
      1.346546,
      3.082273,
      0.846076,
      3.160448,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.683518,
      1.241385,
      1.722341,
      7.796336,
      0.873987,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.931233,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.646825,
      0.881443,
      NULL,
      1,
      0.336904,
      1,
      0.557357,
      0.216567,
      NULL,
      0,
      3.935655,
      3,
      1.777002,
      NULL,
      0,
      3.707939,
      NULL,
      0,
      0.801486,
      NULL,
      NULL,
      NULL,
      1.041913,
      1,
      NULL,
      1.900646,
      0.850047,
      3,
      1.066398,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.875997,
      NULL,
      NULL,
      0.985693,
      3.177143,
      3.375509,
      1,
      1.420749,
      NULL,
      2.878399,
      1,
      NULL,
      3,
      8.634743,
      0,
      NULL,
      3,
      NULL,
      1.007074,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.152434,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.698751,
      11,
      0.315026,
      1,
      1.185895,
      NULL,
      NULL,
      0,
      3,
      3,
      NULL,
      4.027006,
      0,
      3,
      NULL,
      NULL,
      2,
      9,
      0,
      0.484418,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      2.289391,
      0.300017,
      2,
      8,
      8.112792,
      1.358099,
      0.894473,
      0,
      3,
      2,
      1.274612,
      NULL,
      2.639150,
      0,
      NULL,
      2.695115,
      0.229270,
      NULL,
      4.593942,
      7,
      NULL,
      4,
      7.552008,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0.645009,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.663462,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.069078,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.449721,
      NULL,
      NULL,
      2.466723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.030066,
      1.514859,
      0,
      1,
      1.212593,
      2.627007,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.777529,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.931245,
      NULL,
      NULL,
      NULL,
      0.960640,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.421924,
      NULL,
      NULL,
      NULL,
      0.318879,
      NULL,
      NULL,
      NULL,
      1.645931,
      NULL,
      NULL,
      NULL,
      0.068813,
      NULL,
      NULL,
      NULL,
      9.041483,
      NULL,
      NULL,
      NULL,
      0.402059,
      NULL,
      NULL,
      NULL,
      NULL,
      39.240581,
      9.883533,
      0.404314,
      NULL,
      NULL,
      0.735551,
      NULL,
      NULL,
      NULL,
      NULL,
      0.429728,
      1,
      5.765482,
      1.376596,
      NULL,
      NULL,
      NULL,
      1.258203,
      NULL,
      0.036305,
      36,
      2,
      NULL,
      0,
      1,
      1.592738,
      0,
      0.910750,
      0.494800,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0.449098,
      1.264660,
      NULL,
      0.460404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193875,
      0.475019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.918677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623678,
      1.908751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136249,
      1.226763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164220,
      1.557459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.330983,
      NULL,
      1,
      NULL,
      0.387091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      1,
      3,
      2,
      1,
      14,
      0,
      1.824180,
      1.042406,
      NULL,
      0.033085,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.958358,
      NULL,
      NULL,
      1.171820,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.203953,
      NULL,
      1,
      3.442400,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.038973,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257275,
      NULL,
      1.978995,
      NULL,
      1.466294,
      NULL,
      4,
      5,
      2,
      3.039636,
      0.832062,
      1.442007,
      70.825680,
      90.363049,
      NULL,
      0.836187,
      0.891510,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '44213',
      NULL,
      '');
commit;
end;
/


