set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8229218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      0.104041,
      NULL,
      3,
      2,
      '3410',
      2,
      NULL,
      NULL,
      NULL,
      '11-26-1997',
      NULL,
      NULL,
      1,
      1,
      0.509205,
      '10- 1-1996',
      45,
      3.671417,
      281.049906,
      83.505325,
      1,
      NULL,
      ' 4- 1-1990',
      ' 7-19-1980',
      2,
      NULL,
      0.707504,
      0.235551,
      0,
      0,
      0,
      1.623528,
      1,
      1.336322,
      7,
      19,
      5.693488,
      NULL,
      NULL,
      5,
      10.221281,
      4,
      4,
      NULL,
      NULL,
      NULL,
      0,
      0.475341,
      0,
      0.559254,
      1,
      0,
      0.670135,
      NULL,
      0,
      3,
      NULL,
      NULL,
      3.182081,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      2,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1.327856,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.042558,
      1,
      0.031230,
      NULL,
      NULL,
      3.304519,
      NULL,
      1.317723,
      1.431400,
      0,
      NULL,
      2.717684,
      1.355577,
      1,
      NULL,
      2.408510,
      NULL,
      1,
      0,
      0,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      3,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.415444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.423240,
      1.561627,
      NULL,
      1.378583,
      0.982864,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.273838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042245,
      0,
      1.751548,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.083067,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.599432,
      2,
      2,
      1,
      1,
      1,
      3,
      3,
      1,
      2,
      3,
      3.628047,
      0.597988,
      2.399527,
      1.477614,
      NULL,
      0,
      0.300365,
      3.726090,
      0,
      0.993488,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0.860745,
      2.451045,
      0.215698,
      5,
      10.982389,
      7,
      2,
      1,
      0.413925,
      3,
      3.717145,
      1.693143,
      0,
      3.823671,
      0,
      38.084245,
      0,
      3.268047,
      NULL,
      NULL,
      33,
      55.585961,
      1,
      0.358657,
      0,
      '',
      '',
      NULL,
      1,
      '11314',
      '',
      '',
      0.045619,
      '',
      '',
      '',
      NULL,
      NULL,
      10,
      23.607960,
      1.895956,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.386166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.802510,
      NULL,
      NULL,
      3.447514,
      0.098580,
      1,
      NULL,
      3,
      2.053583,
      1.584948,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.713247,
      NULL,
      NULL,
      2,
      2,
      5.971989,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518789,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.061149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.837522,
      1,
      1,
      1.033726,
      NULL,
      NULL,
      5,
      NULL,
      0.862448,
      1,
      NULL,
      NULL,
      0.732177,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.521826,
      NULL,
      NULL,
      1.968135,
      NULL,
      NULL,
      3,
      1,
      2.248003,
      1.031583,
      NULL,
      NULL,
      NULL,
      3.363197,
      5.569084,
      NULL,
      NULL,
      1.452774,
      1.089128,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.293163,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.956459,
      NULL,
      NULL,
      1.509425,
      NULL,
      NULL,
      1.750245,
      NULL,
      NULL,
      0.745710,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.164693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852455,
      3,
      1,
      0,
      0.530987,
      1,
      1.121782,
      NULL,
      0.439696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143062,
      0,
      NULL,
      0,
      0.819892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.958008,
      1.766621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508801,
      NULL,
      NULL,
      12.855813,
      0.900911,
      0,
      1,
      0.036850,
      0,
      0.560864,
      1.694499,
      NULL,
      0,
      NULL,
      1.158782,
      1.649508,
      0,
      NULL,
      1.841398,
      NULL,
      1.914121,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      1,
      2,
      1,
      1,
      7.503197,
      1.269336,
      NULL,
      0,
      3,
      1.616314,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770188,
      1,
      NULL,
      1,
      1.094192,
      NULL,
      1.225077,
      1.356008,
      NULL,
      0,
      0.263915,
      NULL,
      2.342154,
      NULL,
      NULL,
      NULL,
      1.168630,
      NULL,
      1,
      NULL,
      NULL,
      0.156100,
      0.348282,
      NULL,
      0.605159,
      1.429156,
      NULL,
      0,
      1.505062,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.163044,
      NULL,
      NULL,
      27.414806,
      18,
      NULL,
      1.449544,
      1.457930,
      '',
      '',
      NULL,
      3,
      '42212',
      '',
      '',
      0.919644,
      '',
      '',
      NULL);
commit;
end;
/


