set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8229218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1.081853,
      3,
      3,
      '3103',
      1,
      1.269692,
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      6,
      0,
      0,
      ' 6- 7-1994',
      22.664031,
      NULL,
      265,
      16.733014,
      0,
      ' 5- 1-1997',
      ' 7- 1-1991',
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      3,
      2.249130,
      NULL,
      NULL,
      NULL,
      2,
      1,
      23,
      20.430690,
      2,
      1,
      2,
      NULL,
      1,
      1.403078,
      2,
      0,
      NULL,
      0,
      0.552659,
      NULL,
      NULL,
      0.556528,
      NULL,
      1.928652,
      3,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      2,
      1,
      1,
      2,
      1,
      3,
      NULL,
      3,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1.252862,
      1.680355,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      1.406924,
      1.719437,
      3,
      0,
      NULL,
      NULL,
      4.558290,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      1,
      0,
      0,
      1,
      1,
      4,
      1,
      1,
      NULL,
      4.008377,
      1,
      1,
      NULL,
      0,
      0.002621,
      NULL,
      0,
      0,
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      5,
      3,
      NULL,
      0,
      1,
      2,
      1,
      2,
      0,
      1.997341,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0.095053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.120224,
      0.929976,
      0,
      2.399001,
      3.157639,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662942,
      1.409318,
      NULL,
      0,
      5,
      2,
      1.736860,
      NULL,
      NULL,
      NULL,
      0.890807,
      1.165349,
      0.308975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.598389,
      NULL,
      1,
      3,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.079414,
      NULL,
      0,
      3,
      0,
      0,
      3,
      0,
      2,
      0,
      3,
      0,
      0,
      1.914840,
      1.786327,
      0.679359,
      1,
      NULL,
      NULL,
      3,
      0.275931,
      1,
      NULL,
      0.355748,
      1.303802,
      0.370865,
      0.697701,
      NULL,
      1.074779,
      NULL,
      1.837984,
      7,
      6,
      6.816369,
      2.809844,
      4,
      1,
      2,
      0,
      4.231948,
      3,
      NULL,
      3.821529,
      NULL,
      0,
      3,
      NULL,
      12,
      16,
      27,
      5,
      1,
      0,
      '14321',
      '',
      '',
      0.550126,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.467642,
      11,
      NULL,
      2.286043,
      1.525314,
      NULL,
      NULL,
      NULL,
      NULL,
      0.848112,
      NULL,
      NULL,
      1.067835,
      NULL,
      NULL,
      1.126433,
      NULL,
      NULL,
      3.254427,
      3,
      0.320338,
      1.072766,
      NULL,
      NULL,
      3,
      0.137599,
      1,
      3,
      2.410245,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.775097,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.100313,
      0.199171,
      1.695879,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.961624,
      0.217015,
      NULL,
      NULL,
      1.752073,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.062289,
      0,
      1,
      NULL,
      0.367611,
      NULL,
      NULL,
      NULL,
      1.475579,
      NULL,
      NULL,
      NULL,
      0.686371,
      NULL,
      1.368965,
      0,
      NULL,
      NULL,
      1.629310,
      NULL,
      NULL,
      3,
      NULL,
      0.517152,
      6.893299,
      4.057598,
      NULL,
      2,
      3.842169,
      2.040333,
      0,
      NULL,
      NULL,
      0.195494,
      2.351479,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417506,
      2.121789,
      2,
      NULL,
      3,
      1.153389,
      NULL,
      4.898481,
      1.519480,
      2.527813,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.016587,
      2.281622,
      0,
      9,
      NULL,
      6,
      1.013569,
      3.331042,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4.304698,
      7,
      5,
      1.895487,
      NULL,
      NULL,
      0.034135,
      NULL,
      NULL,
      1.876914,
      NULL,
      0,
      0.287492,
      0.170858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.862103,
      1.613767,
      1.973069,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.041676,
      1.744081,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.119925,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.089153,
      NULL,
      NULL,
      NULL,
      0.704018,
      1.194077,
      NULL,
      1.838315,
      1.914605,
      0.044374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.136547,
      1.703535,
      0.213862,
      1.511482,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      5.966804,
      3.449197,
      0.094511,
      5,
      1,
      10.302675,
      0,
      0.820971,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661801,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.626208,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.756065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719595,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      6,
      5,
      0.943273,
      2.997039,
      0,
      77,
      NULL,
      5,
      1.372558,
      1.769585,
      '21410',
      NULL,
      '',
      2,
      '31240',
      '',
      '',
      0.412645,
      NULL,
      NULL,
      NULL);
commit;
end;
/


