set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714445';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '3244314',
      0,
      0.196546,
      2,
      0,
      '3442',
      2.165541,
      NULL,
      NULL,
      6.199225,
      ' 1-27-1981',
      35.867361,
      NULL,
      NULL,
      NULL,
      0.529985,
      ' 2- 6-1999',
      NULL,
      3.001946,
      165,
      98,
      0,
      NULL,
      NULL,
      ' 3-23-1986',
      0,
      NULL,
      2.938339,
      1.968493,
      0,
      NULL,
      0,
      1.423149,
      NULL,
      NULL,
      NULL,
      6.049392,
      NULL,
      13,
      10.998125,
      2,
      25.335297,
      4,
      2,
      7.356127,
      0,
      1,
      NULL,
      0,
      1,
      1.547982,
      0.459239,
      0,
      1,
      0.399760,
      0.878181,
      0,
      2,
      3,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.350749,
      1.601590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1.958293,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      3,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      2,
      1,
      1,
      0,
      0,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0.595472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000663,
      1.648682,
      2.304866,
      4.337105,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.725235,
      1,
      0.574460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.977629,
      2,
      0,
      2,
      NULL,
      2,
      1,
      1,
      3,
      0,
      1,
      NULL,
      0.610978,
      3.120070,
      2.830144,
      NULL,
      0.179163,
      0,
      0.063518,
      1,
      6.924758,
      0,
      0,
      1,
      0.959687,
      0.460319,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0.223902,
      NULL,
      '34101',
      '31441',
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      631.538983,
      6.760585,
      2,
      4,
      6,
      6,
      3,
      0.313368,
      0.978196,
      1.545404,
      1,
      19.396029,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.623449,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.196652,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.765881,
      0,
      0.201083,
      NULL,
      NULL,
      NULL,
      2.637115,
      1.526877,
      3.891522,
      17,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058721,
      NULL,
      NULL,
      0.173222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617408,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.179512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      1.125710,
      0.083573,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.544143,
      NULL,
      NULL,
      0.536614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062927,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.264897,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.035688,
      NULL,
      NULL,
      NULL,
      2.473286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.418956,
      NULL,
      NULL,
      2,
      10,
      NULL,
      NULL,
      13.979280,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3.876772,
      1,
      0,
      1.643823,
      0.840161,
      0,
      0.966452,
      2,
      6.637577,
      3,
      NULL,
      NULL,
      3,
      0,
      2,
      0.987110,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.086365,
      NULL,
      NULL,
      1.092392,
      NULL,
      NULL,
      1.083192,
      NULL,
      NULL,
      0.155124,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.605488,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.260218,
      NULL,
      2,
      0.030778,
      NULL,
      0.923819,
      1.756460,
      NULL,
      3.277935,
      NULL,
      NULL,
      NULL,
      4.922931,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.297293,
      NULL,
      NULL,
      NULL,
      0.183338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.608964,
      NULL,
      NULL,
      NULL,
      1.463910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.123024,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.424941,
      NULL,
      NULL,
      NULL,
      2.344425,
      NULL,
      NULL,
      NULL,
      0.516367,
      NULL,
      NULL,
      NULL,
      4.610731,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.344379,
      0,
      3,
      505,
      1216,
      1.910317,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.542170,
      1.343080,
      NULL,
      NULL,
      NULL,
      NULL,
      0.696073,
      926,
      0,
      6778,
      1.215195,
      1,
      1,
      0.434204,
      NULL,
      0.066929,
      0.902170,
      0.252898,
      1,
      1,
      1.935027,
      1.984823,
      0,
      1,
      0.393740,
      0.607999,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      4,
      2,
      3,
      1,
      NULL,
      4.933334,
      1.673859,
      2.555673,
      2,
      1,
      NULL,
      NULL,
      5.139967,
      9.730012,
      0,
      14,
      13.061600,
      3.848758,
      1.462300,
      1,
      0,
      2.566233,
      NULL,
      1.575554,
      0.175461,
      0,
      0,
      NULL,
      1,
      2,
      0.513130,
      1.382283,
      0.636146,
      0.553963,
      1.025478,
      NULL,
      NULL,
      19,
      12,
      NULL,
      NULL,
      1.369934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634378,
      1,
      0,
      0.440826,
      0,
      NULL,
      2,
      1,
      1,
      2.569264,
      0,
      2,
      91.180860,
      60.788452,
      0,
      NULL,
      NULL,
      '03001',
      '14221',
      '',
      0.540919,
      '',
      '',
      NULL,
      1.561191,
      NULL,
      NULL,
      '');
commit;
end;
/


