set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9630558';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      5,
      NULL,
      2.603480,
      NULL,
      0,
      0,
      0.974551,
      '221',
      '33304230',
      29.123823,
      44.580274,
      '0423314',
      2.186643,
      0,
      3,
      1,
      '1420',
      4.602115,
      0.910065,
      NULL,
      NULL,
      ' 6-26-1990',
      4,
      182,
      NULL,
      2,
      3.749470,
      ' 6-18-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10-11-2002',
      ' 8-25-1980',
      ' 3-29-1974',
      3.403900,
      NULL,
      2.313284,
      1.683385,
      1.871166,
      0,
      NULL,
      3.608734,
      NULL,
      NULL,
      NULL,
      0,
      4.447824,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989699,
      1.432859,
      0.302825,
      NULL,
      1,
      1.348229,
      1,
      0.047277,
      NULL,
      2,
      1,
      3.023311,
      5,
      1,
      1,
      0,
      1,
      0,
      3,
      1,
      2,
      1,
      1,
      1,
      9,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331003,
      1,
      0,
      2,
      3,
      0.934848,
      1.073390,
      2,
      NULL,
      1,
      0.900305,
      2,
      0.925169,
      0.890265,
      2,
      3.408144,
      1,
      1,
      0,
      0,
      4.537715,
      0,
      NULL,
      3,
      0.595380,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      4,
      3,
      5,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1.014465,
      NULL,
      1.120924,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      5,
      2,
      NULL,
      4,
      NULL,
      NULL,
      4.621200,
      1.477589,
      ' 7-17-1987',
      593.088826,
      ' 3-14-2003',
      417,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067437,
      0.493785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.298257,
      5.474027,
      0,
      1.838121,
      1.398782,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.864008,
      0.051083,
      1,
      NULL,
      2,
      1,
      0.798269,
      1.302464,
      6,
      3.741375,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744471,
      0.884494,
      2,
      0,
      0,
      2,
      1,
      3,
      NULL,
      0,
      3,
      3,
      3.307574,
      3.220424,
      3.389781,
      NULL,
      NULL,
      1.708057,
      1,
      1.701666,
      1,
      0,
      0,
      1.394591,
      1.885376,
      NULL,
      1.208169,
      1,
      NULL,
      NULL,
      1,
      NULL,
      10,
      3.866975,
      NULL,
      6,
      4,
      NULL,
      NULL,
      0.568314,
      1,
      1,
      1,
      41.307125,
      1,
      1.386683,
      NULL,
      NULL,
      26,
      46.778965,
      4,
      5,
      2.033744,
      '02001',
      '',
      '',
      0.970538,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      10.476722,
      95,
      8,
      NULL,
      21.973919,
      5,
      NULL,
      0,
      NULL,
      1,
      3.449558,
      1,
      NULL,
      NULL,
      2,
      1.608763,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.574302,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2.823299,
      0,
      NULL,
      2.293460,
      1.240577,
      1,
      0,
      NULL,
      NULL,
      1.134583,
      NULL,
      NULL,
      8.539097,
      5,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.373318,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      2.471218,
      0,
      1.399442,
      2,
      0,
      1.268317,
      0,
      1,
      0,
      0.340251,
      3,
      0,
      NULL,
      3,
      0.934188,
      0,
      0,
      NULL,
      NULL,
      1.807962,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.597470,
      2.319755,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3,
      3.440700,
      3,
      0,
      1.811471,
      3.606434,
      0,
      NULL,
      NULL,
      10.081221,
      0.717336,
      3,
      1,
      0,
      1.807035,
      0.936608,
      NULL,
      NULL,
      4,
      7,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.169309,
      NULL,
      NULL,
      1.530226,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.532219,
      NULL,
      NULL,
      4,
      NULL,
      3.403481,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      4.830304,
      1,
      5,
      3,
      2,
      NULL,
      3.843673,
      0.373349,
      2.086052,
      2.182160,
      NULL,
      2.771051,
      0,
      1.910673,
      1.778576,
      2,
      3.025563,
      2,
      0.298393,
      0.741500,
      5,
      1.988077,
      1,
      1,
      0.104035,
      0.848994,
      3,
      0,
      1.514636,
      2.697972,
      NULL,
      NULL,
      5.651207,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.982480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.250439,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.505627,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.514097,
      0,
      2.310515,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      45.899632,
      NULL,
      NULL,
      NULL,
      3.338342,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.529962,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.519306,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.878088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      106.413176,
      NULL,
      1,
      48,
      3,
      1.448923,
      NULL,
      NULL,
      3.289635,
      5,
      4.001609,
      2.529008,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.718808,
      NULL,
      1.374929,
      1,
      1,
      0.133336,
      0,
      1.821356,
      NULL,
      1,
      0.673749,
      0.060972,
      0,
      0.141981,
      1.482193,
      1.738758,
      0.739631,
      1.426028,
      NULL,
      0.574781,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      4.785719,
      0.460626,
      2.976701,
      2.257023,
      0,
      6,
      NULL,
      1,
      1.969219,
      0.964020,
      1.687464,
      NULL,
      1.082009,
      1.236606,
      NULL,
      1.392422,
      2,
      NULL,
      NULL,
      2.587317,
      NULL,
      0.250808,
      3.407859,
      NULL,
      NULL,
      0.379773,
      NULL,
      0.432463,
      NULL,
      NULL,
      1.694378,
      1.618678,
      NULL,
      0.998353,
      0.545120,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      3.029190,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.922742,
      NULL,
      1.317421,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.615233,
      NULL,
      1,
      NULL,
      1,
      NULL,
      25,
      1.372919,
      1.792058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959913,
      NULL,
      0.146267,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      1.007072,
      NULL,
      NULL,
      24.905304,
      4.443216,
      NULL,
      1,
      1,
      '01104',
      '',
      '',
      1,
      '',
      '',
      '',
      0.205856,
      NULL,
      '',
      '');
commit;
end;
/


