set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9879235';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5.315081,
      0.443861,
      2,
      5.666916,
      2.300645,
      2.033665,
      0.296358,
      5,
      '324',
      '11223104',
      67,
      2.679084,
      '0223441',
      0,
      NULL,
      NULL,
      3,
      '3102',
      6.006856,
      NULL,
      NULL,
      NULL,
      ' 2-29-1996',
      0.582662,
      9.398793,
      NULL,
      0.650051,
      2,
      ' 3-23-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 3- 7-1981',
      ' 2- 5-1989',
      ' 7- 4-1999',
      NULL,
      2,
      3.427743,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      0,
      1,
      11,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069132,
      7.218329,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      4,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      2,
      0,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      0.903071,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      0,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0.862678,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      5,
      1,
      0,
      0,
      0,
      3,
      4,
      3,
      3,
      NULL,
      3,
      1,
      1,
      0,
      3,
      NULL,
      3,
      4,
      NULL,
      1,
      1,
      3,
      4,
      NULL,
      5,
      5.336031,
      NULL,
      ' 9- 4-1999',
      47.895588,
      '10- 7-1990',
      0.982977,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1.270425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.320392,
      NULL,
      2,
      1.259289,
      0.680880,
      2,
      1,
      3.209613,
      2,
      0.196035,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      7,
      4.648039,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.955783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.259926,
      0.366722,
      1.725246,
      3.767393,
      1,
      NULL,
      NULL,
      NULL,
      20,
      1,
      1.943489,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      0,
      2,
      2,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      0.430614,
      NULL,
      NULL,
      0,
      0,
      1.463981,
      3.025925,
      1,
      NULL,
      1.004389,
      NULL,
      0,
      0.009643,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.389691,
      1,
      NULL,
      7,
      0.973406,
      1.538651,
      NULL,
      2,
      NULL,
      3,
      3,
      2,
      18,
      NULL,
      3,
      19,
      NULL,
      2,
      41,
      4,
      4.355262,
      2.444213,
      '32212',
      '',
      '',
      1,
      '10000',
      '',
      '',
      2.796095,
      '40202',
      '',
      '',
      0.438116,
      15,
      15.113020,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.868484,
      NULL,
      1.474571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014417,
      NULL,
      NULL,
      0.610284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754327,
      3,
      1.773795,
      NULL,
      NULL,
      NULL,
      0.380108,
      NULL,
      NULL,
      0.533356,
      NULL,
      NULL,
      0.302381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      6.709817,
      2,
      NULL,
      1.424645,
      NULL,
      NULL,
      NULL,
      0.311189,
      NULL,
      NULL,
      NULL,
      0.019620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.876595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.408993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.537687,
      NULL,
      NULL,
      1.771094,
      NULL,
      3.303154,
      1.492702,
      NULL,
      NULL,
      2,
      5.947999,
      3,
      0,
      NULL,
      NULL,
      0.246242,
      NULL,
      NULL,
      1.413699,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.980002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.069839,
      0,
      NULL,
      1.646326,
      NULL,
      NULL,
      1,
      0.011974,
      4,
      NULL,
      4,
      1.460523,
      1,
      NULL,
      NULL,
      1.282968,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      9,
      3,
      1,
      3.825870,
      0,
      1,
      3,
      NULL,
      3,
      3,
      3.706676,
      NULL,
      NULL,
      0,
      5.719727,
      9.367970,
      6,
      0.787958,
      0.347275,
      1,
      0,
      3,
      1,
      0.614273,
      0.737260,
      0,
      0.846423,
      0.915982,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.415873,
      NULL,
      NULL,
      0.206988,
      NULL,
      NULL,
      0.629929,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.016714,
      NULL,
      NULL,
      0.209126,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364703,
      0.574192,
      1.446389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      9,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.783937,
      1.152122,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.851906,
      NULL,
      NULL,
      NULL,
      0.519263,
      NULL,
      NULL,
      0,
      1.864439,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.197888,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.497676,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.389764,
      NULL,
      NULL,
      0.842549,
      3.155049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.980672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.023708,
      1.106684,
      0,
      0.905032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.346068,
      1.456527,
      0,
      1.284997,
      0,
      1.730952,
      0.859500,
      1,
      0.083307,
      0,
      0.967621,
      1.962443,
      1,
      0,
      1,
      0,
      1.010132,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.970138,
      1.624309,
      1.541300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993043,
      1.570001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.619194,
      NULL,
      0,
      NULL,
      0.800387,
      NULL,
      NULL,
      NULL,
      1.242837,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.904989,
      0.969726,
      NULL,
      2.604601,
      0,
      3,
      1.990038,
      0.645390,
      0.814503,
      1,
      NULL,
      0,
      1,
      1,
      1.076421,
      NULL,
      NULL,
      0.602956,
      NULL,
      0,
      1,
      0.560826,
      2.536744,
      NULL,
      1,
      2,
      2.429696,
      NULL,
      0.245046,
      1.492428,
      2,
      1.065050,
      0,
      0,
      0.025938,
      0.874725,
      1,
      3,
      1,
      0.462370,
      1,
      NULL,
      3,
      0,
      0.117092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.632850,
      NULL,
      0,
      1,
      0.164659,
      1,
      1,
      1,
      4,
      1.515835,
      NULL,
      NULL,
      NULL,
      50,
      2,
      5.801879,
      2.841594,
      '43104',
      '',
      '',
      2.193482,
      '34040',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


