set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '0103013',
      3.646315,
      0,
      2,
      NULL,
      '2212',
      NULL,
      0,
      NULL,
      NULL,
      ' 7-17-1986',
      66.465377,
      NULL,
      3,
      1.729696,
      0.760721,
      ' 8-22-1998',
      NULL,
      1.405715,
      7,
      32,
      1,
      ' 9- 1-1994',
      ' 0- 3-1992',
      NULL,
      0.111942,
      2.382670,
      1.042550,
      0,
      NULL,
      NULL,
      2,
      1.960024,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.749993,
      14.867562,
      5,
      22,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3.279100,
      5,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      5,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.911832,
      NULL,
      NULL,
      3,
      5,
      4,
      0,
      1.492150,
      NULL,
      NULL,
      1,
      1.684817,
      3.617429,
      0.721772,
      1,
      0,
      1,
      3,
      0,
      0.163875,
      2.302299,
      1.786581,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      0.101072,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      4,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      4,
      NULL,
      1.447147,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0,
      5,
      NULL,
      NULL,
      4,
      0,
      0,
      2,
      0,
      1,
      3,
      1,
      2,
      5,
      4,
      2,
      3,
      NULL,
      3,
      3,
      3,
      NULL,
      3,
      4,
      4,
      1,
      1,
      0,
      ' 2- 2-2002',
      1610,
      ' 2- 4-1974',
      479.519752,
      1.388563,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      1,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.825667,
      0.950755,
      1.469478,
      0.011853,
      0.397631,
      2,
      NULL,
      NULL,
      NULL,
      1.712974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      2.736957,
      9.820134,
      0.271066,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.531721,
      2,
      NULL,
      3,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      1,
      0,
      0,
      1.389674,
      4.091287,
      1.548874,
      1.239795,
      1.580260,
      1.880944,
      1,
      NULL,
      0.403196,
      1,
      1,
      NULL,
      0,
      0,
      2.187837,
      8,
      NULL,
      1,
      9.920916,
      4,
      NULL,
      NULL,
      3.185458,
      2.635742,
      3,
      0,
      54,
      2,
      0,
      NULL,
      30,
      56,
      NULL,
      1,
      1,
      NULL,
      '44410',
      '',
      '',
      3.370642,
      '33403',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      163,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.870445,
      1.763594,
      NULL,
      NULL,
      0.268198,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.321468,
      NULL,
      NULL,
      2.014014,
      0,
      1.092090,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.935441,
      1.025882,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4,
      4,
      6.379685,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.377566,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.052899,
      NULL,
      1,
      3,
      3,
      0,
      2.879771,
      3,
      NULL,
      1.796791,
      NULL,
      2.088456,
      1,
      1.643982,
      3,
      0,
      3,
      3.588053,
      NULL,
      1,
      NULL,
      3,
      2,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.697489,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2.907648,
      0.675728,
      1,
      0.880731,
      NULL,
      NULL,
      1,
      4.279728,
      3.101033,
      3.244804,
      1.943323,
      3,
      0.059484,
      NULL,
      NULL,
      2,
      0,
      2.470870,
      1,
      NULL,
      NULL,
      0.945645,
      NULL,
      NULL,
      0.020022,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.189635,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.950520,
      0.744912,
      1.409917,
      2.229669,
      1.327687,
      4.392883,
      NULL,
      5.572073,
      NULL,
      NULL,
      1.022964,
      5,
      NULL,
      0,
      0,
      1,
      1.829519,
      NULL,
      1,
      NULL,
      NULL,
      5.402589,
      1,
      4.831123,
      NULL,
      0.336633,
      1.537946,
      0,
      0.704775,
      0,
      0.159938,
      NULL,
      NULL,
      1.543314,
      NULL,
      1,
      2,
      2.571775,
      9,
      4.267148,
      NULL,
      0,
      1.689534,
      0,
      0,
      0,
      1,
      0.360313,
      NULL,
      1.172404,
      0.907283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.047561,
      1,
      2,
      NULL,
      NULL,
      NULL,
      9.959659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.706974,
      NULL,
      NULL,
      NULL,
      1.721825,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.536318,
      NULL,
      NULL,
      NULL,
      1.009339,
      NULL,
      NULL,
      NULL,
      1.748950,
      NULL,
      NULL,
      NULL,
      1.544157,
      NULL,
      NULL,
      NULL,
      1.247514,
      NULL,
      NULL,
      NULL,
      1.386658,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.243215,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.223075,
      NULL,
      NULL,
      NULL,
      0.478689,
      NULL,
      NULL,
      NULL,
      2.198828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.691732,
      NULL,
      NULL,
      1.004737,
      NULL,
      NULL,
      0.410196,
      NULL,
      NULL,
      1.763040,
      NULL,
      1,
      NULL,
      NULL,
      0.856369,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0,
      0.702434,
      1.926641,
      0,
      0.758849,
      NULL,
      0.962054,
      NULL,
      1,
      1.420226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      11,
      3,
      NULL,
      5.129418,
      3,
      NULL,
      3.998609,
      1,
      0.488745,
      0.349743,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.667727,
      NULL,
      0.095255,
      NULL,
      NULL,
      1,
      0.911156,
      NULL,
      3.289027,
      0.696262,
      NULL,
      2,
      2,
      NULL,
      0.150766,
      3,
      NULL,
      0.513083,
      1.123893,
      NULL,
      0.122033,
      NULL,
      NULL,
      0,
      1.162136,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749717,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      2.859208,
      3,
      3,
      26,
      NULL,
      5,
      0,
      2,
      '41101',
      '',
      NULL,
      2.187133,
      '44011',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


