set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '0203113',
      3,
      1,
      0,
      2,
      '2111',
      0,
      0,
      NULL,
      NULL,
      NULL,
      20.774506,
      NULL,
      4,
      NULL,
      1.870727,
      ' 3-28-2003',
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      '11-14-1988',
      ' 6- 2-1978',
      ' 3-12-1978',
      0,
      0,
      0,
      1.299544,
      0,
      1.670633,
      3,
      2.541100,
      NULL,
      NULL,
      NULL,
      10,
      4.055118,
      NULL,
      18.141027,
      NULL,
      1,
      2,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      3,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.715289,
      0.267980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      0,
      4.218321,
      0,
      1,
      NULL,
      1,
      1.971695,
      NULL,
      1.255183,
      1,
      0,
      1,
      1,
      0,
      0,
      4,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      3,
      3,
      NULL,
      4,
      0,
      NULL,
      NULL,
      4,
      1,
      2,
      NULL,
      1,
      ' 2- 3-1988',
      738.479846,
      ' 7-11-1987',
      546.783218,
      NULL,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      2,
      NULL,
      1.268885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979567,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.703871,
      0,
      2,
      NULL,
      3.054975,
      1,
      NULL,
      NULL,
      NULL,
      1.567326,
      0.235782,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995675,
      0,
      0,
      1.040749,
      0,
      0,
      2,
      45.580311,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      2,
      NULL,
      3,
      NULL,
      2,
      3,
      NULL,
      3,
      NULL,
      NULL,
      1.952803,
      1.475738,
      2.011970,
      4,
      0,
      1.185477,
      5,
      NULL,
      NULL,
      0,
      0,
      1.194336,
      1.561252,
      0,
      0,
      0,
      1.370809,
      0,
      0.285521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      15,
      13,
      NULL,
      2,
      1,
      1,
      '13004',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      3,
      31,
      99.857511,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.253465,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.393829,
      1.769150,
      1.663327,
      0,
      NULL,
      NULL,
      0.123822,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.086882,
      1,
      2,
      1,
      0.280840,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.642358,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.191056,
      1.087925,
      0.243202,
      NULL,
      0,
      0.629465,
      1.267477,
      1,
      0.039736,
      1.749647,
      0.784717,
      1.739790,
      0,
      0.844122,
      0.785658,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109243,
      NULL,
      NULL,
      1.811219,
      NULL,
      NULL,
      0.644735,
      1.925591,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817921,
      2.877007,
      1,
      0,
      NULL,
      NULL,
      0.698943,
      NULL,
      NULL,
      6.055670,
      NULL,
      2.793288,
      NULL,
      1.260163,
      1,
      0.778824,
      NULL,
      NULL,
      4.358624,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.086955,
      NULL,
      NULL,
      0.505372,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.289030,
      NULL,
      NULL,
      1.139276,
      NULL,
      NULL,
      1.279643,
      NULL,
      NULL,
      0.671582,
      NULL,
      NULL,
      5,
      0.492906,
      4.946259,
      5,
      5.916558,
      1.873077,
      2,
      NULL,
      1,
      1,
      1.579386,
      1,
      1.582450,
      NULL,
      1,
      4.627921,
      0,
      5,
      3.231520,
      NULL,
      3,
      3,
      NULL,
      NULL,
      2.863964,
      3.418128,
      1,
      2,
      2,
      NULL,
      0,
      5,
      2,
      6.431564,
      5,
      4,
      0.577075,
      2,
      NULL,
      1.433284,
      1,
      0,
      1.242954,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.699153,
      NULL,
      NULL,
      0.940800,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184340,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.587913,
      NULL,
      0,
      0,
      1.166628,
      NULL,
      NULL,
      1.948825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.556533,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.492061,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.169436,
      NULL,
      NULL,
      NULL,
      1.706840,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377322,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.025869,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816901,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.296745,
      NULL,
      NULL,
      1.009587,
      NULL,
      NULL,
      0,
      NULL,
      0.342790,
      395,
      1.371504,
      NULL,
      1.689924,
      1,
      NULL,
      1,
      1,
      1.193177,
      NULL,
      0,
      0.344514,
      NULL,
      1.415212,
      0,
      1.466060,
      NULL,
      1,
      1.353719,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      1,
      2.796567,
      0,
      NULL,
      NULL,
      NULL,
      0.787940,
      0,
      0.583552,
      NULL,
      0.648190,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.416114,
      NULL,
      1.931855,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.345056,
      3,
      NULL,
      0.963531,
      NULL,
      NULL,
      0.034225,
      0.846842,
      NULL,
      1.184019,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.067929,
      0.276301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460425,
      NULL,
      1.144835,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5,
      3.920988,
      NULL,
      1,
      NULL,
      38.234557,
      4,
      0,
      2.442900,
      '30404',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


