set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '4302343',
      1.599751,
      0.329398,
      3,
      NULL,
      '3423',
      1,
      0,
      NULL,
      NULL,
      ' 3- 8-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-16-2000',
      9,
      3,
      284.721674,
      103,
      0,
      ' 2- 4-1996',
      NULL,
      NULL,
      2,
      NULL,
      3.239619,
      2.962035,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7.876687,
      NULL,
      1.122758,
      4,
      1.110932,
      3,
      NULL,
      7.165984,
      0.790076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.954386,
      3,
      1,
      0,
      0,
      0,
      4,
      5,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.586300,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      NULL,
      0.742208,
      1.988225,
      NULL,
      1,
      0.103108,
      2.108963,
      NULL,
      0.645907,
      1.447954,
      NULL,
      0.394297,
      0,
      0.221018,
      NULL,
      2,
      0,
      0,
      6.311091,
      1,
      NULL,
      0,
      0.757896,
      NULL,
      NULL,
      0.681941,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      2,
      1,
      5.610952,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0.661262,
      0,
      1,
      4,
      5,
      1,
      NULL,
      4,
      0,
      1,
      3,
      1,
      1,
      4,
      4,
      NULL,
      1,
      3,
      0,
      2,
      5,
      5,
      5,
      0,
      4,
      1,
      NULL,
      0.091740,
      NULL,
      1523,
      '10-15-1995',
      771,
      0.345169,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      0,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.526324,
      NULL,
      NULL,
      NULL,
      0.836336,
      0,
      0.581208,
      4,
      0.648540,
      NULL,
      5.902422,
      1.583468,
      NULL,
      NULL,
      1,
      2.889046,
      0.803262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.600616,
      NULL,
      0.844692,
      1.041970,
      1,
      3.929852,
      NULL,
      0.934087,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      3,
      2.141646,
      1.384643,
      1,
      0.518927,
      NULL,
      1.932948,
      0.984293,
      NULL,
      NULL,
      0,
      1.424873,
      1.829878,
      0,
      0,
      0.792461,
      0,
      NULL,
      10.288678,
      3.014515,
      2.041326,
      5,
      5,
      4.230778,
      1,
      0.121911,
      6.630979,
      1,
      3,
      1.414480,
      31.348619,
      2,
      3,
      NULL,
      NULL,
      16,
      73,
      0,
      1,
      3.291708,
      '44414',
      NULL,
      NULL,
      0.657852,
      '01042',
      '',
      NULL,
      1.455443,
      '',
      '',
      '',
      NULL,
      NULL,
      141.587770,
      27.566635,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.477756,
      1.616795,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.092266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0.029192,
      1.715416,
      NULL,
      NULL,
      0.803624,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.091836,
      0,
      0.255363,
      1.616820,
      NULL,
      NULL,
      5.837893,
      3.904775,
      4.306169,
      0,
      1.393886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.453328,
      NULL,
      0,
      3,
      2,
      1,
      3.177783,
      2.036596,
      0,
      1.362086,
      NULL,
      3.612087,
      1,
      0,
      3.288731,
      0.347835,
      0,
      1,
      1,
      0.903270,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.910862,
      1.692667,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.862227,
      1,
      1,
      1.823539,
      1.670644,
      0,
      0,
      NULL,
      NULL,
      8,
      0,
      3,
      2.666397,
      1.111153,
      1.174979,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.528831,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.041373,
      NULL,
      NULL,
      1.781128,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.946360,
      1.284024,
      1.323136,
      7,
      0.462077,
      0,
      6,
      NULL,
      0.057889,
      7,
      1.495096,
      6.495663,
      3.504161,
      1,
      3.345050,
      3.182726,
      1,
      0.498095,
      3.877601,
      0.293157,
      NULL,
      7,
      0,
      0,
      3.968742,
      1,
      3.051361,
      0.525273,
      2,
      3,
      1.520340,
      NULL,
      NULL,
      NULL,
      3.122619,
      0,
      9,
      3.148828,
      3.526281,
      NULL,
      0.160594,
      5,
      0.353017,
      NULL,
      NULL,
      0,
      1.714643,
      1,
      NULL,
      0.115239,
      NULL,
      NULL,
      NULL,
      1.958028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.632020,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.202145,
      1,
      1.888278,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.413635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.931900,
      NULL,
      NULL,
      NULL,
      1.300108,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452669,
      NULL,
      NULL,
      NULL,
      3.292056,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.526267,
      NULL,
      NULL,
      NULL,
      1.652073,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0.399192,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.251002,
      0.431390,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249927,
      NULL,
      NULL,
      1,
      NULL,
      0.428602,
      1218.520238,
      1.699739,
      1.540101,
      1,
      0,
      0,
      0.225365,
      NULL,
      NULL,
      0.833584,
      NULL,
      1.679417,
      1,
      0.757998,
      0.457789,
      1,
      1,
      0.622903,
      0.800741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      9.560411,
      NULL,
      NULL,
      5.950844,
      3,
      13,
      3,
      1.442057,
      NULL,
      0.796689,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.329095,
      1,
      NULL,
      0.033989,
      3,
      NULL,
      1.070020,
      NULL,
      NULL,
      1.451948,
      0,
      NULL,
      1.519279,
      3.205013,
      NULL,
      0.726803,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.767524,
      NULL,
      0,
      1.110372,
      NULL,
      2.172150,
      1,
      1.325539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      6,
      3,
      1,
      0,
      2,
      NULL,
      24,
      5,
      0,
      0.590749,
      NULL,
      '34040',
      NULL,
      NULL,
      '34133',
      '',
      NULL,
      1.199530,
      '',
      '',
      '');
commit;
end;
/


