set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9664424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      3,
      5,
      6,
      NULL,
      2.539920,
      1,
      NULL,
      '233',
      '12323140',
      29.289359,
      NULL,
      '1024042',
      0.430204,
      0.524868,
      NULL,
      3,
      '1023',
      4,
      0,
      NULL,
      NULL,
      ' 3-21-1977',
      NULL,
      43.388720,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-24-1980',
      '11-25-1993',
      NULL,
      1,
      0,
      1.047119,
      1.455840,
      0,
      2,
      5,
      1.503710,
      0,
      13.122693,
      4,
      NULL,
      3.419122,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      6,
      0,
      2,
      2,
      NULL,
      1,
      0,
      2,
      2,
      2,
      1,
      5,
      1,
      NULL,
      1,
      11.728010,
      1,
      1,
      1,
      1,
      0.006893,
      NULL,
      NULL,
      0.635244,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1.245331,
      0.574252,
      NULL,
      1,
      1.604750,
      2,
      0,
      NULL,
      1,
      0.435882,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      2.250273,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      3,
      0,
      2,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1.499596,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0.104834,
      3,
      0,
      NULL,
      1,
      4,
      3,
      1,
      0,
      0,
      5,
      3,
      1,
      NULL,
      0,
      2,
      4,
      NULL,
      1,
      1,
      0,
      0,
      5,
      1,
      NULL,
      NULL,
      2.891670,
      NULL,
      '10- 9-2000',
      230,
      ' 1-29-1995',
      23.975538,
      3.956588,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2,
      0,
      0,
      0.396312,
      NULL,
      3.744288,
      1,
      NULL,
      NULL,
      1.130022,
      NULL,
      NULL,
      NULL,
      NULL,
      5.149733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.145714,
      NULL,
      0,
      0.462587,
      NULL,
      0,
      0,
      2,
      42,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      2,
      NULL,
      2,
      3,
      1,
      2,
      0,
      0,
      3,
      2,
      1,
      2,
      0,
      3.185354,
      2.373436,
      0.369020,
      3,
      3,
      1.049652,
      1,
      1,
      1,
      5.119198,
      0.144588,
      NULL,
      0,
      2,
      NULL,
      1.634899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      21,
      NULL,
      12,
      56.852836,
      NULL,
      5,
      2,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1.454308,
      '',
      '',
      '',
      1.027670,
      37,
      135.418945,
      34.171828,
      1.215968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.335228,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302376,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      2.007058,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.623130,
      2,
      0.899280,
      NULL,
      NULL,
      1.849964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.248490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882199,
      0.780185,
      1.281620,
      0,
      2,
      0,
      1.678003,
      NULL,
      NULL,
      4.461613,
      5.970788,
      2.985452,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.436732,
      NULL,
      NULL,
      1.013605,
      NULL,
      NULL,
      0.626390,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.294361,
      3.983339,
      0.523719,
      NULL,
      NULL,
      5,
      8,
      7,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.986974,
      2.794205,
      0,
      1,
      3,
      2,
      1,
      0,
      NULL,
      NULL,
      8,
      NULL,
      3,
      0.382439,
      1.972077,
      2,
      3.984684,
      1,
      3,
      NULL,
      1,
      0.877530,
      3,
      3.816469,
      NULL,
      7.631061,
      2.412970,
      5,
      2,
      2,
      3,
      1,
      2,
      0.752904,
      1,
      0,
      1,
      1,
      3.186041,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839065,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.092254,
      1,
      1,
      3,
      1.516765,
      NULL,
      NULL,
      0.739566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405963,
      NULL,
      NULL,
      NULL,
      1.179996,
      NULL,
      NULL,
      NULL,
      0.655055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.534380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3.388053,
      1.859007,
      2.138020,
      1,
      0,
      0.239364,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.356866,
      NULL,
      1,
      104.799049,
      19,
      NULL,
      1.789539,
      0.618280,
      NULL,
      1.900069,
      0.613290,
      0.694243,
      1.731368,
      0,
      NULL,
      0.989553,
      NULL,
      NULL,
      1,
      1,
      1.038016,
      0.080399,
      0.293024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      10.231834,
      1.717855,
      0.345709,
      5.311096,
      NULL,
      2,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.618650,
      NULL,
      NULL,
      1,
      1.125396,
      NULL,
      1.907173,
      NULL,
      NULL,
      0.582936,
      0,
      NULL,
      1.895824,
      2.318658,
      NULL,
      0.847338,
      0.739234,
      NULL,
      1,
      0.750333,
      NULL,
      0,
      3.763942,
      NULL,
      1,
      2.416315,
      NULL,
      2.328191,
      1,
      1.832319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.258719,
      NULL,
      NULL,
      NULL,
      1.472674,
      NULL,
      0,
      NULL,
      6,
      0,
      1,
      0,
      NULL,
      82,
      NULL,
      2.594019,
      3.990652,
      '01311',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      1.892467,
      '',
      NULL,
      '');
commit;
end;
/


